/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.search.collapsed;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;
import me.shedaniel.rei.api.client.registry.entry.CollapsibleEntryRegistry;
import me.shedaniel.rei.impl.common.InternalLogger;
import me.shedaniel.rei.impl.common.entry.type.collapsed.CollapsibleEntryRegistryImpl;
import me.shedaniel.rei.impl.common.util.HashedEntryStackWrapper;
import net.minecraft.class_2960;

public class CollapsedEntriesCache {
    private static CollapsedEntriesCache instance = new CollapsedEntriesCache();
    private final Long2ObjectMap<Set<class_2960>> cache = new Long2ObjectOpenHashMap();

    public static void reset() {
        instance = new CollapsedEntriesCache();
    }

    public static CollapsedEntriesCache getInstance() {
        return instance;
    }

    public void prepare(Collection<? extends HashedEntryStackWrapper> stacks) {
        Collection<CollapsibleEntryRegistryImpl.Entry> entries = ((CollapsibleEntryRegistryImpl)CollapsibleEntryRegistry.getInstance()).getEntries();
        InternalLogger.getInstance().debug("Preparing collapsed entry groups cache with %d entries and %d stacks", entries.size(), stacks.size());
        for (CollapsibleEntryRegistryImpl.Entry entry : entries) {
            if (!entry.canCache()) continue;
            for (HashedEntryStackWrapper hashedEntryStackWrapper : stacks) {
                if (entry.getMatcher().matches(hashedEntryStackWrapper.unwrap(), hashedEntryStackWrapper.hashExact())) {
                    ((Set)this.cache.computeIfAbsent(hashedEntryStackWrapper.hashExact(), $ -> new HashSet())).add(entry.getId());
                    continue;
                }
                Set locations = (Set)this.cache.get(hashedEntryStackWrapper.hashExact());
                if (locations == null) continue;
                locations.remove(entry.getId());
                if (!locations.isEmpty()) continue;
                this.cache.remove(hashedEntryStackWrapper.hashExact());
            }
        }
        InternalLogger.getInstance().debug("Prepared collapsed entry groups cache with %d entries and %d stacks", entries.size(), stacks.size());
    }

    @Nullable
    public Set<class_2960> getEntries(long hash) {
        return (Set)this.cache.get(hash);
    }
}

