/*
 * Decompiled with CFR 0.152.
 */
package griglog.relt.table_storage;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import griglog.relt.RELT;
import java.awt.Desktop;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import net.minecraft.class_2960;
import net.minecraft.class_52;
import net.minecraft.class_60;
import org.apache.commons.lang3.SystemUtils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a\u0015\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0001\u001a\u00020\u0000\u00a2\u0006\u0004\b\u0003\u0010\u0004\u001a\u0015\u0010\u0007\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\b\"3\u0010\f\u001a\u001e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\n0\tj\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\n`\u000b8\u0006\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lnet/minecraft/class_2960;", "name", "", "openTableJson", "(Lnet/minecraft/class_2960;)V", "", "compressed", "recieveLootTables", "([B)V", "Ljava/util/HashMap;", "Lnet/minecraft/class_52;", "Lkotlin/collections/HashMap;", "clientTables", "Ljava/util/HashMap;", "getClientTables", "()Ljava/util/HashMap;", "RoughlyEnoughLootTables"})
public final class ClientTablesKt {
    @NotNull
    private static final HashMap<class_2960, class_52> clientTables = new HashMap();

    @NotNull
    public static final HashMap<class_2960, class_52> getClientTables() {
        return clientTables;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void recieveLootTables(@NotNull byte[] compressed) {
        Intrinsics.checkNotNullParameter((Object)compressed, (String)"compressed");
        long t1 = System.nanoTime();
        byte[] bytes = null;
        Closeable closeable = new ByteArrayInputStream(compressed);
        Throwable throwable = null;
        try {
            GZIPInputStream gZIPInputStream;
            InputStream it = (ByteArrayInputStream)closeable;
            boolean bl = false;
            GZIPInputStream $this$recieveLootTables_u24lambda_u2d1_u24lambda_u2d0 = gZIPInputStream = new GZIPInputStream(it);
            boolean bl2 = false;
            byte[] byArray = $this$recieveLootTables_u24lambda_u2d1_u24lambda_u2d0.readAllBytes();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"readAllBytes()");
            bytes = byArray;
            $this$recieveLootTables_u24lambda_u2d1_u24lambda_u2d0.close();
            it = gZIPInputStream;
        }
        catch (Throwable it) {
            throwable = it;
            throw it;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        JsonElement json = JsonParser.parseString((String)new String(bytes, Charsets.UTF_8));
        clientTables.clear();
        Set set = json.getAsJsonObject().entrySet();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"json.asJsonObject.entrySet()");
        Iterable $this$forEach$iv = set;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Map.Entry entry = (Map.Entry)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)entry, (String)"(key, value)");
            String key = (String)entry.getKey();
            JsonElement value = (JsonElement)entry.getValue();
            class_2960 rl = new class_2960(key);
            class_52 table = (class_52)class_60.field_974.fromJson(value, class_52.class);
            clientTables.put(rl, table);
        }
        long t2 = System.nanoTime();
        RELT.INSTANCE.getLogger().info("Recieved and decompressed " + clientTables.size() + " loot tables (" + bytes.length + " bytes). Took " + (t2 - t1) / (long)1000000 + " ms.");
    }

    public static final void openTableJson(@NotNull class_2960 name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        class_52 class_522 = clientTables.get(name);
        if (class_522 == null) {
            return;
        }
        class_52 table = class_522;
        String json = class_60.field_974.newBuilder().setPrettyPrinting().create().toJson((Object)table);
        String string = name.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name.toString()");
        File temp = File.createTempFile("RELT_" + StringsKt.replace$default((String)StringsKt.replace$default((String)string, (char)':', (char)'_', (boolean)false, (int)4, null), (char)'/', (char)'_', (boolean)false, (int)4, null), ".json");
        Intrinsics.checkNotNullExpressionValue((Object)temp, (String)"temp");
        FilesKt.writeText((File)temp, (String)json.toString(), (Charset)Charsets.UTF_8);
        if (Desktop.isDesktopSupported()) {
            Desktop.getDesktop().open(temp);
        } else {
            RELT.INSTANCE.getLogger().warn("Desktop is not supported. Let's try OS-specific operations.");
            try {
                if (SystemUtils.IS_OS_WINDOWS) {
                    String[] stringArray = new String[]{"rundll32", "url.dll,FileProtocolHandler", temp.getAbsolutePath()};
                    Runtime.getRuntime().exec(stringArray);
                } else if (SystemUtils.IS_OS_MAC) {
                    String[] stringArray = new String[]{"/usr/bin/open", temp.getAbsolutePath()};
                    Runtime.getRuntime().exec(stringArray);
                } else if (SystemUtils.IS_OS_LINUX) {
                    String[] stringArray = new String[]{"xdg-open", temp.getAbsolutePath()};
                    Runtime.getRuntime().exec(stringArray);
                } else {
                    RELT.INSTANCE.getLogger().error("Unknown operating system. Please report to the mod author.");
                    RELT.INSTANCE.getLogger().info("Anyways, here is your loot table:\n" + json);
                }
            }
            catch (Exception e) {
                RELT.INSTANCE.getLogger().error("Unable to open file. Please report to the mod author.");
                RELT.INSTANCE.getLogger().info("Anyways, here is your loot table:\n" + json);
            }
        }
        temp.deleteOnExit();
    }
}

