/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.base.data.lang;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.railwayteam.railways.registry.CRPalettes;
import com.railwayteam.railways.registry.CRTags;
import com.simibubi.create.foundation.utility.FilesHelper;
import com.tterrag.registrate.providers.RegistrateLangProvider;
import java.util.Map;
import java.util.function.BiConsumer;

public class CRLangGen {
    public static void generate(RegistrateLangProvider provider) {
        BiConsumer<String, String> langConsumer = (arg_0, arg_1) -> ((RegistrateLangProvider)provider).add(arg_0, arg_1);
        CRLangGen.provideDefaultLang("interface", langConsumer);
        CRLangGen.provideDefaultLang("tooltips", langConsumer);
        CRTags.provideLangEntries(langConsumer);
        CRPalettes.provideLangEntries(langConsumer);
    }

    private static void provideDefaultLang(String fileName, BiConsumer<String, String> consumer) {
        String path = "assets/railways/lang/default/" + fileName + ".json";
        JsonElement jsonElement = FilesHelper.loadJsonResource((String)path);
        if (jsonElement == null) {
            throw new IllegalStateException(String.format("Could not find default lang file: %s", path));
        }
        JsonObject jsonObject = jsonElement.getAsJsonObject();
        for (Map.Entry entry : jsonObject.entrySet()) {
            String key = (String)entry.getKey();
            String value = ((JsonElement)entry.getValue()).getAsString();
            consumer.accept(key, value);
        }
    }
}

