/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.base.datafixerapi;

import com.mojang.datafixers.DataFixer;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.railwayteam.railways.base.datafixerapi.DataFixesInternals;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_4284;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Range;

@ApiStatus.Internal
public final class DataFixesInternalsImpl
extends DataFixesInternals {
    @NotNull
    private final Schema latestVanillaSchema;
    private DataFixesInternals.DataFixerEntry dataFixer;

    public DataFixesInternalsImpl(@NotNull Schema latestVanillaSchema) {
        this.latestVanillaSchema = latestVanillaSchema;
        this.dataFixer = null;
    }

    @Override
    public void registerFixer(@Range(from=0L, to=0x7FFFFFFFL) int currentVersion, @NotNull DataFixer dataFixer) {
        if (this.dataFixer != null) {
            throw new IllegalArgumentException("Railways already has a registered data fixer");
        }
        this.dataFixer = new DataFixesInternals.DataFixerEntry(dataFixer, currentVersion);
    }

    @Override
    @Nullable
    public DataFixesInternals.DataFixerEntry getFixerEntry() {
        return this.dataFixer;
    }

    @Override
    @NotNull
    public Schema createBaseSchema() {
        return new Schema(0, this.latestVanillaSchema);
    }

    @Override
    @NotNull
    public class_2487 updateWithAllFixers(@NotNull class_4284 dataFixTypes, @NotNull class_2487 compound) {
        Dynamic current = new Dynamic((DynamicOps)class_2509.field_11560, (Object)compound);
        if (this.dataFixer != null) {
            int modDataVersion = DataFixesInternals.getModDataVersion(compound);
            current = this.dataFixer.dataFixer().update(dataFixTypes.method_20329(), current, modDataVersion, this.dataFixer.currentVersion());
        }
        return (class_2487)current.getValue();
    }

    @Override
    @NotNull
    public class_2487 addModDataVersions(@NotNull class_2487 compound) {
        if (this.dataFixer != null) {
            compound.method_10569("Railways_DataVersion", this.dataFixer.currentVersion());
        }
        return compound;
    }
}

