/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.compat.tracks.mods;

import com.google.common.collect.ImmutableMap;
import com.railwayteam.railways.Railways;
import com.railwayteam.railways.compat.Mods;
import com.railwayteam.railways.compat.tracks.GenericTrackCompat;
import java.util.Map;
import net.minecraft.class_2960;

public class TwilightForestTrackCompat
extends GenericTrackCompat {
    private static final Map<String, String> slab_map = ImmutableMap.of((Object)"minewood", (Object)"mining_slab", (Object)"transwood", (Object)"transformation_slab");
    private static boolean registered = false;

    TwilightForestTrackCompat() {
        super(Mods.TWILIGHTFOREST);
    }

    @Override
    protected class_2960 getSlabLocation(String name) {
        if (slab_map.containsKey(name)) {
            return this.asResource(slab_map.get(name));
        }
        return this.asResource(name.replaceAll("wood", "") + "_slab");
    }

    public static void register() {
        if (registered) {
            Railways.LOGGER.error("Duplicate registration of Twilight Forest track compat");
            return;
        }
        registered = true;
        Railways.LOGGER.info("Registering tracks for Twilight Forest");
        new TwilightForestTrackCompat().register("canopy", "darkwood", "mangrove", "minewood", "sortingwood", "timewood", "transwood", "twilight_oak");
    }
}

