/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.content.fuel;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.class_151;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3611;
import net.minecraft.class_5321;
import net.minecraft.class_6862;

public class LiquidFuelType {
    private final List<Supplier<class_3611>> fluids = new ArrayList<Supplier<class_3611>>();
    private final List<Supplier<class_6862<class_3611>>> fluidTags = new ArrayList<Supplier<class_6862<class_3611>>>();
    private int fuelTicks = 40;
    private boolean invalid = false;

    public List<Supplier<class_3611>> getFluids() {
        return this.fluids;
    }

    public List<Supplier<class_6862<class_3611>>> getFluidTags() {
        return this.fluidTags;
    }

    public int getFuelTicks() {
        return this.fuelTicks;
    }

    public boolean getInvalid() {
        return this.invalid;
    }

    public static LiquidFuelType fromJson(JsonObject object) {
        LiquidFuelType type = new LiquidFuelType();
        try {
            JsonElement fluidsElement = object.get("fluids");
            if (fluidsElement != null && fluidsElement.isJsonArray()) {
                for (JsonElement element : fluidsElement.getAsJsonArray()) {
                    JsonPrimitive primitive2;
                    if (!element.isJsonPrimitive() || !(primitive2 = element.getAsJsonPrimitive()).isString()) continue;
                    try {
                        String string = primitive2.getAsString();
                        if (string.startsWith("#")) {
                            class_6862 tag = class_6862.method_40092((class_5321)class_2378.field_25103, (class_2960)new class_2960(primitive2.getAsString().substring(1)));
                            if (tag == null) continue;
                            type.fluidTags.add(() -> tag);
                            continue;
                        }
                        class_3611 fluid = (class_3611)class_2378.field_11154.method_10223(new class_2960(primitive2.getAsString()));
                        if (fluid == null) continue;
                        type.fluids.add(() -> fluid);
                    }
                    catch (class_151 class_1512) {}
                }
            } else {
                return null;
            }
            LiquidFuelType.parseJsonPrimitive(object, "fuel_ticks", JsonPrimitive::isNumber, primitive -> {
                type.fuelTicks = primitive.getAsInt();
            });
            LiquidFuelType.parseJsonPrimitive(object, "invalid", JsonPrimitive::isBoolean, primitive -> {
                type.invalid = primitive.getAsBoolean();
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
        return type;
    }

    private static void parseJsonPrimitive(JsonObject object, String key, Predicate<JsonPrimitive> predicate, Consumer<JsonPrimitive> consumer) {
        JsonPrimitive primitive;
        JsonElement element = object.get(key);
        if (element != null && element.isJsonPrimitive() && predicate.test(primitive = element.getAsJsonPrimitive())) {
            consumer.accept(primitive);
        }
    }
}

