/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.content.smokestack.block;

import com.railwayteam.railways.config.CRConfigs;
import com.railwayteam.railways.content.smokestack.SmokeType;
import com.railwayteam.railways.content.smokestack.block.AbstractSmokeStackBlock;
import com.railwayteam.railways.content.smokestack.block.be.SmokeStackBlockEntity;
import com.railwayteam.railways.content.smokestack.particles.legacy.SmokeParticleData;
import com.railwayteam.railways.content.smokestack.particles.puffs.PuffSmokeParticleData;
import com.railwayteam.railways.registry.CRBlockEntities;
import com.railwayteam.railways.util.ShapeWrapper;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1767;
import net.minecraft.class_1769;
import net.minecraft.class_1792;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2400;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3489;
import net.minecraft.class_3532;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_5819;
import net.minecraft.class_6328;

@class_6328
@ParametersAreNonnullByDefault
public class SmokeStackBlock
extends AbstractSmokeStackBlock<SmokeStackBlockEntity> {
    public final SmokeStackType type;
    public boolean createsStationarySmoke;

    public SmokeStackBlock(class_4970.class_2251 properties, SmokeStackType type, ShapeWrapper shape, boolean createsStationarySmoke, String variant) {
        super(properties, shape, variant);
        this.method_9590(this.makeDefaultState());
        this.type = type;
        this.createsStationarySmoke = createsStationarySmoke;
    }

    @Override
    public class_1269 method_9534(class_2680 pState, class_1937 pLevel, class_2338 pPos, class_1657 pPlayer, class_1268 pHand, class_3965 pHit) {
        class_1792 class_17922 = pPlayer.method_5998(pHand).method_7909();
        if (class_17922 instanceof class_1769) {
            class_1769 dyeItem = (class_1769)class_17922;
            class_1767 color = dyeItem.method_7802();
            this.withBlockEntityDo((class_1922)pLevel, pPos, te -> te.setColor(color));
            if (!pPlayer.method_7337()) {
                pPlayer.method_5998(pHand).method_7934(1);
            }
            return class_1269.method_29236((boolean)pLevel.field_9236);
        }
        if (pPlayer.method_5998(pHand).method_31573(class_3489.field_23801)) {
            this.withBlockEntityDo((class_1922)pLevel, pPos, te -> te.setSoul(true));
            if (!pPlayer.method_7337()) {
                pPlayer.method_5998(pHand).method_7934(1);
            }
            return class_1269.method_29236((boolean)pLevel.field_9236);
        }
        if (pPlayer.method_5715()) {
            this.withBlockEntityDo((class_1922)pLevel, pPos, te -> {
                te.setSoul(false);
                te.setColor(null);
            });
            return class_1269.method_29236((boolean)pLevel.field_9236);
        }
        return super.method_9534(pState, pLevel, pPos, pPlayer, pHand, pHit);
    }

    public static void makeParticlesStationary(class_1937 level, class_2338 pos, boolean isSignalFire, boolean spawnExtraSmoke, class_243 spawnOffset, class_243 spawnDelta) {
        SmokeStackBlock.makeParticles(level, new class_243((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260()), isSignalFire, spawnExtraSmoke, spawnOffset, spawnDelta, 1.0, true);
    }

    public static void makeParticles(class_1937 level, class_243 pos, boolean isSignalFire, boolean spawnExtraSmoke, class_243 spawnOffset, class_243 spawnDelta) {
        SmokeStackBlock.makeParticles(level, pos, isSignalFire, spawnExtraSmoke, spawnOffset, spawnDelta, 1.0);
    }

    public static void makeParticles(class_1937 level, class_243 pos, boolean isSignalFire, boolean spawnExtraSmoke, class_243 spawnOffset, class_243 spawnDelta, double speedMultiplier) {
        SmokeStackBlock.makeParticles(level, pos, isSignalFire, spawnExtraSmoke, spawnOffset, spawnDelta, speedMultiplier, false);
    }

    public static void makeParticles(class_1937 level, class_243 pos, boolean isSignalFire, boolean spawnExtraSmoke, class_243 spawnOffset, class_243 spawnDelta, double speedMultiplier, boolean stationary) {
        class_1767 color = null;
        boolean isSoul = false;
        class_2586 class_25862 = level.method_8321(new class_2338(pos));
        if (class_25862 instanceof SmokeStackBlockEntity) {
            SmokeStackBlockEntity be = (SmokeStackBlockEntity)class_25862;
            isSoul = be.isSoul();
            color = be.getColor();
        }
        SmokeStackBlock.makeParticles(level, pos, isSignalFire, spawnExtraSmoke, spawnOffset, spawnDelta, speedMultiplier, stationary, color, null, isSoul);
    }

    public static void makeParticles(class_1937 level, class_243 pos, boolean isSignalFire, boolean spawnExtraSmoke, class_243 spawnOffset, class_243 spawnDelta, double speedMultiplier, boolean stationary, @Nullable class_1767 color) {
        SmokeStackBlock.makeParticles(level, pos, isSignalFire, spawnExtraSmoke, spawnOffset, spawnDelta, speedMultiplier, stationary, color, null);
    }

    public static void makeParticles(class_1937 level, class_243 pos, boolean isSignalFire, boolean spawnExtraSmoke, class_243 spawnOffset, class_243 spawnDelta, double speedMultiplier, boolean stationary, @Nullable class_1767 color, @Nullable Boolean small) {
        SmokeStackBlock.makeParticles(level, pos, isSignalFire, spawnExtraSmoke, spawnOffset, spawnDelta, speedMultiplier, stationary, color, small, false);
    }

    public static void makeParticles(class_1937 level, class_243 pos, boolean isSignalFire, boolean spawnExtraSmoke, class_243 spawnOffset, class_243 spawnDelta, double speedMultiplier, boolean stationary, @Nullable class_1767 color, @Nullable Boolean small, boolean isSoul) {
        class_5819 random = level.method_8409();
        SmokeType smokeType = (SmokeType)((Object)CRConfigs.client().smokeType.get());
        if (small == null) {
            small = random.method_43058() < 0.33;
        }
        switch (smokeType) {
            case VANILLA: {
                class_2400 particleType = isSignalFire ? class_2398.field_17431 : class_2398.field_17430;
                level.method_17452((class_2394)particleType, true, pos.method_10216() + spawnOffset.field_1352 + random.method_43058() * spawnDelta.field_1352 * (double)(random.method_43056() ? 1 : -1), pos.method_10214() + random.method_43058() * spawnDelta.field_1351 + spawnOffset.field_1351, pos.method_10215() + spawnOffset.field_1350 + random.method_43058() * spawnDelta.field_1350 * (double)(random.method_43056() ? 1 : -1), 0.0, 0.07 * speedMultiplier / (stationary ? 1.0 : 25.0), 0.0);
                break;
            }
            case OLD: {
                SmokeParticleData particleType;
                if (color != null) {
                    float[] c = color.method_7787();
                    particleType = new SmokeParticleData(stationary, c[0], c[1], c[2]);
                } else {
                    particleType = new SmokeParticleData(stationary);
                }
                level.method_17452((class_2394)particleType, true, pos.method_10216() + spawnOffset.field_1352 + random.method_43058() * spawnDelta.field_1352 * (random.method_43058() * 2.0 - 1.0), pos.method_10214() + random.method_43058() * spawnDelta.field_1351 + spawnOffset.field_1351 + 0.5, pos.method_10215() + spawnOffset.field_1350 + random.method_43058() * spawnDelta.field_1350 * (random.method_43058() * 2.0 - 1.0), 0.0, 0.07 * speedMultiplier * (double)(stationary ? 25 : 1), 0.0);
                break;
            }
            case CARTOON: {
                PuffSmokeParticleData<?> particleType = isSoul ? PuffSmokeParticleData.create(small, stationary, -2.0f, -2.0f, -2.0f) : (color != null ? PuffSmokeParticleData.create(small, stationary, color) : PuffSmokeParticleData.create(small, stationary));
                level.method_17452(particleType, true, pos.method_10216() + spawnOffset.field_1352 + random.method_43058() * spawnDelta.field_1352 * (random.method_43058() * 2.0 - 1.0), pos.method_10214() + random.method_43058() * spawnDelta.field_1351 + spawnOffset.field_1351 + 0.5, pos.method_10215() + spawnOffset.field_1350 + random.method_43058() * spawnDelta.field_1350 * (random.method_43058() * 2.0 - 1.0), 0.0, class_3532.method_20390((double)speedMultiplier, (double)-1.0) ? 42.0 : 2.1, 0.0);
            }
        }
        if (spawnExtraSmoke && smokeType != SmokeType.CARTOON) {
            level.method_8406((class_2394)class_2398.field_11251, pos.method_10216() + spawnOffset.field_1352 + random.method_43058() * spawnDelta.field_1352 * 0.75 * (double)(random.method_43056() ? 1 : -1), pos.method_10214() + spawnOffset.field_1351 - 0.1, pos.method_10215() + spawnOffset.field_1350 + random.method_43058() * spawnDelta.field_1350 * 0.75 * (double)(random.method_43056() ? 1 : -1), 0.0, 0.005 * speedMultiplier, 0.0);
        }
    }

    public void blockEntityAnimateTick(class_2680 state, class_1937 level, class_2338 pos, class_5819 random) {
        if (((Boolean)state.method_11654((class_2769)ENABLED)).booleanValue() && (double)random.method_43057() < this.type.particleSpawnChance * 1.5 && this.createsStationarySmoke) {
            for (int i = 0; i < random.method_43048(this.type.maxParticles - this.type.minParticles) + this.type.minParticles; ++i) {
                SmokeStackBlock.makeParticlesStationary(level, pos, random.method_43056(), true, this.type.getParticleSpawnOffset(), this.type.getParticleSpawnDelta());
            }
        }
    }

    public Class<SmokeStackBlockEntity> getBlockEntityClass() {
        return SmokeStackBlockEntity.class;
    }

    public class_2591<? extends SmokeStackBlockEntity> getBlockEntityType() {
        return (class_2591)CRBlockEntities.SMOKE_STACK.get();
    }

    public static class SmokeStackType {
        public class_243 particleSpawnOffset;
        public class_243 particleSpawnDelta;
        public double particleSpawnChance;
        public int minParticles;
        public int maxParticles;

        public SmokeStackType(double xOffset, double yOffset, double zOffset) {
            this(new class_243(xOffset, yOffset, zOffset));
        }

        public SmokeStackType(class_243 particleSpawnOffset) {
            this(particleSpawnOffset, new class_243(0.3, 2.0, 0.3));
        }

        public SmokeStackType(class_243 particleSpawnOffset, class_243 particleSpawnDelta) {
            this(particleSpawnOffset, particleSpawnDelta, 2, 4);
        }

        public SmokeStackType(class_243 particleSpawnOffset, class_243 particleSpawnDelta, int minParticles, int maxParticles) {
            this(particleSpawnOffset, particleSpawnDelta, minParticles, maxParticles, 1.0);
        }

        public SmokeStackType(class_243 particleSpawnOffset, class_243 particleSpawnDelta, int minParticles, int maxParticles, double particleSpawnChance) {
            this.particleSpawnOffset = particleSpawnOffset;
            this.particleSpawnDelta = particleSpawnDelta;
            this.minParticles = minParticles;
            this.maxParticles = maxParticles;
            this.particleSpawnChance = particleSpawnChance;
        }

        public class_243 getParticleSpawnOffset() {
            return this.particleSpawnOffset;
        }

        public class_243 getParticleSpawnDelta() {
            return this.particleSpawnDelta;
        }
    }

    public static enum RotationType {
        NONE,
        AXIS,
        FACING;

    }
}

