/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.mixin.client;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.railwayteam.railways.mixin_interfaces.ILimited;
import com.railwayteam.railways.registry.CRPackets;
import com.railwayteam.railways.util.Utils;
import com.simibubi.create.content.trains.entity.Train;
import com.simibubi.create.content.trains.entity.TrainIconType;
import com.simibubi.create.content.trains.station.AbstractStationScreen;
import com.simibubi.create.content.trains.station.GlobalStation;
import com.simibubi.create.content.trains.station.StationBlockEntity;
import com.simibubi.create.content.trains.station.StationScreen;
import com.simibubi.create.content.trains.station.TrainEditPacket;
import com.simibubi.create.foundation.gui.widget.ScrollInput;
import com.simibubi.create.foundation.networking.SimplePacketBase;
import com.simibubi.create.foundation.utility.Components;
import com.simibubi.create.foundation.utility.Lang;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_342;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_4286;
import net.minecraft.class_4587;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={StationScreen.class}, remap=false)
public abstract class MixinStationScreen
extends AbstractStationScreen {
    @Shadow
    private class_342 trainNameBox;
    private class_4286 limitEnableCheckbox;
    private List<class_2960> iconTypes;
    private ScrollInput iconTypeScroll;

    private MixinStationScreen(StationBlockEntity te, GlobalStation station) {
        super(te, station);
    }

    @Inject(method={"init"}, at={@At(value="INVOKE", target="Lcom/simibubi/create/content/trains/station/StationScreen;tickTrainDisplay()V")}, remap=true)
    private void initCheckbox(CallbackInfo ci) {
        int x = this.guiLeft;
        int y = this.guiTop;
        this.limitEnableCheckbox = new class_4286(x + this.background.width - 98, y + this.background.height - 26, 50, 20, (class_2561)Components.translatable((String)"railways.station.train_limit"), this.station != null && ((ILimited)this.station).isLimitEnabled()){
            private static final class_2960 TEXTURE = new class_2960("textures/gui/checkbox.png");
            private static final int TEXT_COLOR = 0xEFEFEF;

            public void method_25306() {
                super.method_25306();
                CRPackets.PACKETS.send((SimplePacketBase)ILimited.makeLimitEnabledPacket(MixinStationScreen.this.blockEntity.method_11016(), this.method_20372()));
            }

            public void method_25359(class_4587 poseStack, int mouseX, int mouseY, float partialTick) {
                class_310 minecraft = class_310.method_1551();
                RenderSystem.setShaderTexture((int)0, (class_2960)TEXTURE);
                RenderSystem.enableDepthTest();
                class_327 font = minecraft.field_1772;
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)this.field_22765);
                RenderSystem.enableBlend();
                RenderSystem.defaultBlendFunc();
                RenderSystem.blendFunc((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA);
                class_4286.method_25290((class_4587)poseStack, (int)this.field_22760, (int)this.field_22761, (float)(this.method_25370() ? 20.0f : 0.0f), (float)(this.method_20372() ? 20.0f : 0.0f), (int)20, (int)this.field_22759, (int)64, (int)64);
                this.method_25353(poseStack, minecraft, mouseX, mouseY);
                class_4286.method_27535((class_4587)poseStack, (class_327)font, (class_2561)this.method_25369(), (int)(this.field_22760 + 24), (int)(this.field_22761 + (this.field_22759 - 8) / 2), (int)(0xEFEFEF | class_3532.method_15386((float)(this.field_22765 * 255.0f)) << 24));
                if (this.method_25367()) {
                    MixinStationScreen.this.method_30901(poseStack, (List)ImmutableList.of((Object)Components.translatable((String)"railways.station.train_limit.tooltip.1"), (Object)Components.translatable((String)"railways.station.train_limit.tooltip.2")), mouseX, mouseY);
                }
            }
        };
        this.method_37063((class_364)this.limitEnableCheckbox);
        this.iconTypes = TrainIconType.REGISTRY.keySet().stream().toList();
        this.iconTypeScroll = new ScrollInput(x + 4, y + 17, 184, 14).titled(Lang.translateDirect((String)"station.icon_type", (Object[])new Object[0]));
        this.iconTypeScroll.withRange(0, this.iconTypes.size());
        this.iconTypeScroll.withStepFunction(ctx -> -((Integer)this.iconTypeScroll.standardStep().apply(ctx)).intValue());
        this.iconTypeScroll.calling(s -> {
            Train train = (Train)this.displayedTrain.get();
            if (train != null) {
                train.icon = TrainIconType.byId((class_2960)this.iconTypes.get((int)s));
                Utils.sendCreatePacketToServer((SimplePacketBase)new TrainEditPacket(train.id, this.trainNameBox.method_1882(), train.icon.getId()));
            }
        });
        this.iconTypeScroll.field_22763 = false;
    }

    @Inject(method={"tickTrainDisplay"}, at={@At(value="HEAD")})
    private void tickIconScroll(CallbackInfo ci) {
        Train train = (Train)this.displayedTrain.get();
        if (train == null) {
            Train imminentTrain;
            if (this.iconTypeScroll.field_22763) {
                this.iconTypeScroll.field_22763 = false;
                this.method_37066((class_364)this.iconTypeScroll);
            }
            if ((imminentTrain = this.getImminent()) != null) {
                this.iconTypeScroll.field_22763 = true;
                this.iconTypeScroll.setState(this.iconTypes.indexOf(imminentTrain.icon.getId()));
                this.method_37063((class_364)this.iconTypeScroll);
            }
        }
    }
}

