/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.registry;

import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.DataFixerBuilder;
import com.mojang.datafixers.schemas.Schema;
import com.railwayteam.railways.Railways;
import com.railwayteam.railways.base.datafixerapi.DataFixesInternals;
import com.railwayteam.railways.base.datafixers.LocoMetalSmokeboxFacingFix;
import com.railwayteam.railways.base.datafixers.StreamlinedSmokeStackFacingFix;
import com.railwayteam.railways.base.datafixers.UpsideDownMonoBogeyFix;
import com.railwayteam.railways.config.CRConfigs;
import java.util.concurrent.Executor;
import java.util.function.BiFunction;
import net.minecraft.class_1220;
import net.minecraft.class_156;

public class CRDataFixers {
    private static final BiFunction<Integer, Schema, Schema> SAME = Schema::new;
    private static final BiFunction<Integer, Schema, Schema> SAME_NAMESPACED = class_1220::new;

    public static void register() {
        Railways.LOGGER.info("Registering data fixers");
        if (CRConfigs.getDisableDatafixer()) {
            Railways.LOGGER.warn("Skipping Datafixer Registration due to it being disabled in the config.");
            return;
        }
        DataFixesInternals api = DataFixesInternals.get();
        DataFixerBuilder builder = new DataFixerBuilder(2);
        CRDataFixers.addFixers(builder);
        api.registerFixer(2, builder.buildOptimized((Executor)class_156.method_28124()));
    }

    private static void addFixers(DataFixerBuilder builder) {
        builder.addSchema(0, DataFixesInternals.BASE_SCHEMA);
        Schema schemaV1 = builder.addSchema(1, SAME_NAMESPACED);
        builder.addFixer((DataFix)new UpsideDownMonoBogeyFix(schemaV1, "Merge railways:mono_bogey_upside_down into railways:mono_bogey[upside_down=true]"));
        Schema schemaV2 = builder.addSchema(2, SAME_NAMESPACED);
        builder.addFixer((DataFix)new StreamlinedSmokeStackFacingFix(schemaV2, "Convert railways:smokestack_streamlined[axis=\"*\"] to railways:smokestack_streamlined[facing=\"*\"]"));
        builder.addFixer((DataFix)new LocoMetalSmokeboxFacingFix(schemaV2, "Convert railways:${*}_locometal_smokebox[axis=\"*\"] to railways:${*}_locometal_smokebox[facing=\"*\"]"));
    }
}

