/*
 * Decompiled with CFR 0.152.
 */
package techreborn.blockentity.generator;

import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import org.jetbrains.annotations.Nullable;
import reborncore.api.IToolDrop;
import reborncore.common.blockentity.MachineBaseBlockEntity;
import reborncore.common.blocks.BlockMachineBase;
import reborncore.common.powerSystem.PowerAcceptorBlockEntity;
import reborncore.common.powerSystem.PowerSystem;
import reborncore.common.powerSystem.RcEnergyTier;
import reborncore.common.screen.BuiltScreenHandler;
import reborncore.common.screen.BuiltScreenHandlerProvider;
import reborncore.common.screen.builder.ScreenHandlerBuilder;
import reborncore.common.util.StringUtils;
import techreborn.blocks.generator.BlockSolarPanel;
import techreborn.init.TRBlockEntities;
import techreborn.init.TRContent;

public class SolarPanelBlockEntity
extends PowerAcceptorBlockEntity
implements IToolDrop,
BuiltScreenHandlerProvider {
    private boolean generating = false;
    private int dayNightRange = 0;
    private TRContent.SolarPanels panel;

    public SolarPanelBlockEntity(class_2338 pos, class_2680 state) {
        super(TRBlockEntities.SOLAR_PANEL, pos, state);
    }

    public SolarPanelBlockEntity(class_2338 pos, class_2680 state, TRContent.SolarPanels panel) {
        super(TRBlockEntities.SOLAR_PANEL, pos, state);
        this.panel = panel;
    }

    private void updatePanel() {
        if (this.field_11863 == null) {
            return;
        }
        class_2248 panelBlock = this.field_11863.method_8320(this.field_11867).method_26204();
        if (panelBlock instanceof BlockSolarPanel) {
            BlockSolarPanel solarPanelBlock = (BlockSolarPanel)panelBlock;
            this.panel = solarPanelBlock.panelType;
        }
        this.dayNightRange = this.getPanel().generationRateD - this.getPanel().generationRateN;
    }

    public boolean isGenerating() {
        return this.generating;
    }

    private void setIsGenerating(boolean isGenerating) {
        if (isGenerating != this.isGenerating()) {
            this.field_11863.method_8501(this.field_11867, (class_2680)this.field_11863.method_8320(this.field_11867).method_11657((class_2769)BlockMachineBase.ACTIVE, (Comparable)Boolean.valueOf(isGenerating)));
        }
        this.generating = isGenerating;
    }

    TRContent.SolarPanels getPanel() {
        if (this.panel == null) {
            this.updatePanel();
        }
        return this.panel;
    }

    private void updateState() {
        if (this.field_11863 == null) {
            return;
        }
        this.setIsGenerating(this.field_11863.method_8311(this.field_11867.method_10084()));
    }

    public int getGenerationRate() {
        if (!this.isGenerating()) {
            return 0;
        }
        float skyAngle = this.field_11863.method_30274(0.0f);
        if (!this.field_11863.method_8597().comp_642() || (double)skyAngle > 0.25 && (double)skyAngle < 0.75 || this.field_11863.method_8419() || this.field_11863.method_8546()) {
            return this.getPanel().generationRateN;
        }
        float multiplier = (double)skyAngle > 0.75 ? (0.25f - (1.0f - skyAngle)) / 0.25f : (0.25f - skyAngle) / 0.25f;
        return (int)Math.ceil((float)this.getPanel().generationRateN + (float)this.dayNightRange * multiplier);
    }

    public void tick(class_1937 world, class_2338 pos, class_2680 state, MachineBaseBlockEntity blockEntity) {
        super.tick(world, pos, state, blockEntity);
        if (world == null || world.field_9236) {
            return;
        }
        if (this.getPanel() == TRContent.SolarPanels.CREATIVE) {
            this.checkOverfill = false;
            this.setEnergy(Integer.MAX_VALUE);
            return;
        }
        if (world.method_8510() % 20L == 0L) {
            this.checkOverfill = true;
            this.updateState();
        }
        this.addEnergy(this.getGenerationRate());
    }

    public long getBaseMaxPower() {
        return this.getPanel().internalCapacity;
    }

    protected boolean canAcceptEnergy(@Nullable class_2350 side) {
        return false;
    }

    public long getBaseMaxOutput() {
        if (this.getPanel() == TRContent.SolarPanels.CREATIVE) {
            return RcEnergyTier.INSANE.getMaxOutput();
        }
        return RcEnergyTier.EXTREME.getMaxOutput();
    }

    public long getBaseMaxInput() {
        return 0L;
    }

    public boolean canBeUpgraded() {
        return false;
    }

    public boolean hasSlotConfig() {
        return false;
    }

    public RcEnergyTier getTier() {
        return this.getPanel().powerTier;
    }

    public void checkTier() {
    }

    public void addInfo(List<class_2561> info, boolean isReal, boolean hasData) {
        if (this.panel == TRContent.SolarPanels.CREATIVE) {
            return;
        }
        info.add((class_2561)class_2561.method_43471((String)"reborncore.tooltip.energy.maxEnergy").method_27692(class_124.field_1080).method_27693(": ").method_10852((class_2561)class_2561.method_43470((String)PowerSystem.getLocalizedPower((double)this.getMaxStoredPower())).method_27692(class_124.field_1065)));
        info.add((class_2561)class_2561.method_43471((String)"techreborn.tooltip.generationRate.day").method_27692(class_124.field_1080).method_27693(": ").method_10852((class_2561)class_2561.method_43470((String)PowerSystem.getLocalizedPower((double)this.panel.generationRateD)).method_27692(class_124.field_1065)));
        info.add((class_2561)class_2561.method_43471((String)"techreborn.tooltip.generationRate.night").method_27692(class_124.field_1080).method_27693(": ").method_10852((class_2561)class_2561.method_43470((String)PowerSystem.getLocalizedPower((double)this.panel.generationRateN)).method_27692(class_124.field_1065)));
        info.add((class_2561)class_2561.method_43471((String)"reborncore.tooltip.energy.tier").method_27692(class_124.field_1080).method_27693(": ").method_10852((class_2561)class_2561.method_43470((String)StringUtils.toFirstCapitalAllLowercase((String)this.getTier().toString())).method_27692(class_124.field_1065)));
    }

    public void method_11014(class_2487 tag) {
        if (this.field_11863 == null) {
            this.checkOverfill = false;
        }
        this.updatePanel();
        super.method_11014(tag);
    }

    public void onLoad() {
        super.onLoad();
        this.updatePanel();
    }

    public class_1799 getToolDrop(class_1657 playerIn) {
        return new class_1799((class_1935)this.getBlockType());
    }

    public BuiltScreenHandler createScreenHandler(int syncID, class_1657 player) {
        return new ScreenHandlerBuilder("solar_panel").player(player.method_31548()).inventory().hotbar().addInventory().blockEntity((class_2586)this).syncEnergyValue().sync(this::isGenerating, this::setIsGenerating).addInventory().create((MachineBaseBlockEntity)this, syncID);
    }
}

