/*
 * Decompiled with CFR 0.152.
 */
package techreborn.blockentity.storage.item;

import java.util.List;
import java.util.Objects;
import net.fabricmc.fabric.api.transfer.v1.item.InventoryStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.item.base.SingleStackStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.base.CombinedStorage;
import net.minecraft.class_124;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1809;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import org.jetbrains.annotations.Nullable;
import reborncore.api.IListInfoProvider;
import reborncore.api.IToolDrop;
import reborncore.api.blockentity.InventoryProvider;
import reborncore.common.blockentity.MachineBaseBlockEntity;
import reborncore.common.screen.BuiltScreenHandler;
import reborncore.common.screen.BuiltScreenHandlerProvider;
import reborncore.common.screen.builder.ScreenHandlerBuilder;
import reborncore.common.util.ItemUtils;
import reborncore.common.util.RebornInventory;
import reborncore.common.util.WorldUtils;
import techreborn.init.TRBlockEntities;
import techreborn.init.TRContent;

public class StorageUnitBaseBlockEntity
extends MachineBaseBlockEntity
implements InventoryProvider,
IToolDrop,
IListInfoProvider,
BuiltScreenHandlerProvider {
    public static final int INPUT_SLOT = 0;
    public static final int OUTPUT_SLOT = 1;
    public int storedAmount = 0;
    protected RebornInventory<StorageUnitBaseBlockEntity> inventory;
    private int maxCapacity;
    private int serverCapacity = -1;
    private class_1799 storeItemStack;
    private final SingleStackStorage[] internalStoreStorage = new SingleStackStorage[6];
    private TRContent.StorageUnit type;
    private class_1799 lockedItemStack = class_1799.field_8037;

    public StorageUnitBaseBlockEntity(class_2338 pos, class_2680 state) {
        super(TRBlockEntities.STORAGE_UNIT, pos, state);
        this.inventory = new RebornInventory(2, "ItemInventory", 64, (MachineBaseBlockEntity)this);
    }

    public StorageUnitBaseBlockEntity(class_2338 pos, class_2680 state, TRContent.StorageUnit type) {
        super(TRBlockEntities.STORAGE_UNIT, pos, state);
        this.inventory = new RebornInventory(2, "ItemInventory", 64, (MachineBaseBlockEntity)this);
        this.configureEntity(type);
    }

    private void configureEntity(TRContent.StorageUnit type) {
        if (this.serverCapacity == -1) {
            this.maxCapacity = type.capacity;
        }
        this.storeItemStack = class_1799.field_8037;
        this.type = type;
    }

    public boolean isLocked() {
        return this.lockedItemStack != class_1799.field_8037;
    }

    public void setLocked(boolean value) {
        if (this.isLocked() == value) {
            return;
        }
        class_1799 stack = this.getStoredStack().method_7972();
        stack.method_7939(1);
        this.lockedItemStack = value ? stack : class_1799.field_8037;
        this.syncWithAll();
    }

    public boolean canModifyLocking() {
        if (this.isLocked()) {
            return true;
        }
        return !this.method_5442();
    }

    private void populateOutput() {
        class_1799 output = this.storeItemStack.method_7972();
        int outputSlotCount = this.inventory.method_5438(1).method_7947();
        output.method_7939(outputSlotCount);
        int amountToFill = this.getStoredStack().method_7914() - outputSlotCount;
        if (this.storeItemStack.method_7947() >= amountToFill) {
            this.storeItemStack.method_7934(amountToFill);
            if (this.storeItemStack.method_7960()) {
                this.storeItemStack = class_1799.field_8037;
            }
            output.method_7933(amountToFill);
        } else {
            output.method_7933(this.storeItemStack.method_7947());
            this.storeItemStack = class_1799.field_8037;
        }
        this.inventory.method_5447(1, output);
    }

    private void addStoredItemCount(int amount) {
        this.storeItemStack.method_7933(amount);
    }

    public class_1799 getStoredStack() {
        return this.storeItemStack.method_7960() ? this.inventory.method_5438(1) : this.storeItemStack;
    }

    public class_1799 getDisplayedStack() {
        if (!this.isLocked()) {
            return this.getStoredStack();
        }
        return this.lockedItemStack;
    }

    public class_1799 getAll() {
        class_1799 returnStack = class_1799.field_8037;
        if (!this.method_5442()) {
            returnStack = this.getStoredStack().method_7972();
            returnStack.method_7939(this.getCurrentCapacity());
        }
        return returnStack;
    }

    public class_1799 processInput(class_1799 inputStack) {
        if (!this.method_5437(0, inputStack)) {
            return inputStack;
        }
        if (this.getDisplayedStack().method_7960()) {
            this.storeItemStack = inputStack.method_7972();
            if (inputStack.method_7947() <= this.maxCapacity) {
                inputStack = class_1799.field_8037;
            } else {
                this.storeItemStack.method_7939(this.maxCapacity);
                inputStack.method_7934(this.maxCapacity);
            }
        } else {
            int reminder = this.maxCapacity - this.getCurrentCapacity();
            if (inputStack.method_7947() <= reminder) {
                if (this.storeItemStack == class_1799.field_8037) {
                    this.storeItemStack = inputStack.method_7972();
                } else {
                    this.addStoredItemCount(inputStack.method_7947());
                }
                inputStack = class_1799.field_8037;
            } else {
                this.addStoredItemCount(reminder);
                inputStack.method_7934(reminder);
            }
        }
        this.inventory.setHashChanged();
        return inputStack;
    }

    private void fillToCapacity() {
        this.storeItemStack = this.getStoredStack();
        this.storeItemStack.method_7939(this.maxCapacity);
        this.inventory.method_5447(1, class_1799.field_8037);
    }

    public boolean isFull() {
        return this.getCurrentCapacity() == this.maxCapacity;
    }

    public int getCurrentCapacity() {
        return this.storeItemStack.method_7947() + this.inventory.method_5438(1).method_7947();
    }

    public void tick(class_1937 world, class_2338 pos, class_2680 state, MachineBaseBlockEntity blockEntity) {
        super.tick(world, pos, state, blockEntity);
        if (world == null || world.field_9236) {
            return;
        }
        if (!this.inventory.method_5438(0).method_7960() && !this.isFull()) {
            this.inventory.method_5447(0, this.processInput(this.inventory.method_5438(0)));
        }
        if (this.storeItemStack.method_7947() > 0 && this.inventory.method_5438(1).method_7947() < this.getStoredStack().method_7914()) {
            this.populateOutput();
        }
        if (this.type == TRContent.StorageUnit.CREATIVE) {
            if (!this.isFull() && !this.method_5442()) {
                this.fillToCapacity();
            }
            this.inventory.method_5447(0, class_1799.field_8037);
        }
        if (this.inventory.hasChanged()) {
            this.syncWithAll();
            this.inventory.resetHasChanged();
        }
    }

    public boolean method_5442() {
        return this.getCurrentCapacity() == 0;
    }

    public boolean method_5492(int index, class_1799 stack, @Nullable class_2350 direction) {
        return super.method_5492(index, stack, direction) && this.method_5437(0, stack);
    }

    public void method_11014(class_2487 tagCompound) {
        super.method_11014(tagCompound);
        if (tagCompound.method_10545("unitType")) {
            this.type = TRContent.StorageUnit.valueOf(tagCompound.method_10558("unitType"));
            this.configureEntity(this.type);
        } else {
            this.type = TRContent.StorageUnit.QUANTUM;
        }
        this.storeItemStack = class_1799.field_8037;
        if (tagCompound.method_10545("storedStack")) {
            this.storeItemStack = class_1799.method_7915((class_2487)tagCompound.method_10562("storedStack"));
        }
        if (!this.storeItemStack.method_7960()) {
            this.storeItemStack.method_7939(Math.min(tagCompound.method_10550("storedQuantity"), this.maxCapacity));
        }
        if (tagCompound.method_10545("totalStoredAmount")) {
            this.storedAmount = tagCompound.method_10550("totalStoredAmount");
        }
        if (tagCompound.method_10545("lockedItem")) {
            this.lockedItemStack = class_1799.method_7915((class_2487)tagCompound.method_10562("lockedItem"));
        }
    }

    public void method_11007(class_2487 tagCompound) {
        super.method_11007(tagCompound);
        tagCompound.method_10582("unitType", this.type.name());
        if (!this.storeItemStack.method_7960()) {
            class_1799 temp = this.storeItemStack.method_7972();
            if (this.storeItemStack.method_7947() > this.storeItemStack.method_7914()) {
                temp.method_7939(this.storeItemStack.method_7914());
            }
            tagCompound.method_10566("storedStack", (class_2520)temp.method_7953(new class_2487()));
            tagCompound.method_10569("storedQuantity", Math.min(this.storeItemStack.method_7947(), this.maxCapacity));
        } else {
            tagCompound.method_10569("storedQuantity", 0);
        }
        tagCompound.method_10569("totalStoredAmount", this.getCurrentCapacity());
        if (this.isLocked()) {
            tagCompound.method_10566("lockedItem", (class_2520)this.lockedItemStack.method_7953(new class_2487()));
        }
    }

    public void onBreak(class_1937 world, class_1657 playerEntity, class_2338 blockPos, class_2680 blockState) {
        super.onBreak(world, playerEntity, blockPos, blockState);
        if (this.type == TRContent.StorageUnit.CREATIVE) {
            this.inventory.method_5448();
            return;
        }
        if (this.storeItemStack != class_1799.field_8037) {
            if (this.storeItemStack.method_7914() == 64) {
                WorldUtils.dropItem((class_1799)this.storeItemStack, (class_1937)world, (class_2338)this.field_11867);
            } else {
                int size = this.storeItemStack.method_7914();
                for (int i = 0; i < this.storeItemStack.method_7947() / size; ++i) {
                    class_1799 toDrop = this.storeItemStack.method_7972();
                    toDrop.method_7939(size);
                    WorldUtils.dropItem((class_1799)toDrop, (class_1937)world, (class_2338)this.field_11867);
                }
                if (this.storeItemStack.method_7947() % size != 0) {
                    class_1799 toDrop = this.storeItemStack.method_7972();
                    toDrop.method_7939(this.storeItemStack.method_7947() % size);
                    WorldUtils.dropItem((class_1799)toDrop, (class_1937)world, (class_2338)this.field_11867);
                }
            }
        }
    }

    public boolean method_5437(int slot, class_1799 inputStack) {
        if (slot != 0) {
            return false;
        }
        if (inputStack == class_1799.field_8037) {
            return false;
        }
        if (inputStack.method_7909() instanceof class_1809) {
            return false;
        }
        if (inputStack.method_31573(TRContent.ItemTags.STORAGE_UNITS)) {
            return false;
        }
        if (this.isLocked()) {
            return ItemUtils.isItemEqual((class_1799)this.lockedItemStack, (class_1799)inputStack, (boolean)true, (boolean)true);
        }
        if (this.method_5442()) {
            return true;
        }
        return ItemUtils.isItemEqual((class_1799)this.getStoredStack(), (class_1799)inputStack, (boolean)true, (boolean)true);
    }

    public boolean canBeUpgraded() {
        return false;
    }

    public RebornInventory<StorageUnitBaseBlockEntity> getInventory() {
        return this.inventory;
    }

    public class_1799 getToolDrop(class_1657 entityPlayer) {
        class_1799 dropStack = new class_1799((class_1935)this.getBlockType(), 1);
        class_2487 blockEntity = new class_2487();
        this.method_11007(blockEntity);
        dropStack.method_7980(new class_2487());
        dropStack.method_7948().method_10566("blockEntity", (class_2520)blockEntity);
        return dropStack;
    }

    public void addInfo(List<class_2561> info, boolean isReal, boolean hasData) {
        if (isReal || hasData) {
            if (!this.method_5442()) {
                info.add((class_2561)class_2561.method_43470((String)String.valueOf(this.getCurrentCapacity())).method_10852((class_2561)class_2561.method_43471((String)"techreborn.tooltip.unit.divider")).method_10852(this.getStoredStack().method_7964()));
            } else {
                info.add((class_2561)class_2561.method_43471((String)"techreborn.tooltip.unit.empty"));
            }
        }
        info.add((class_2561)class_2561.method_43471((String)"techreborn.tooltip.unit.capacity").method_27692(class_124.field_1080).method_10852((class_2561)class_2561.method_43470((String)String.valueOf(this.getMaxCapacity())).method_27692(class_124.field_1065).method_27693(" ").method_10852((class_2561)class_2561.method_43471((String)"techreborn.tooltip.unit.items")).method_27693(" (").method_27693(String.valueOf(this.getMaxCapacity() / 64)).method_27693(" ").method_10852((class_2561)class_2561.method_43471((String)"techreborn.tooltip.unit.stacks")).method_27693(")")));
    }

    public BuiltScreenHandler createScreenHandler(int syncID, class_1657 playerEntity) {
        return new ScreenHandlerBuilder("chest").player(playerEntity.method_31548()).inventory().hotbar().addInventory().blockEntity((class_2586)this).slot(0, 100, 53).outputSlot(1, 140, 53).sync(this::isLockedInt, this::setLockedInt).sync(this::getStoredStackNBT, this::setStoredStackFromNBT).sync(this::getStoredAmount, this::setStoredAmount).sync(this::getMaxCapacity, this::setMaxCapacity).addInventory().create((MachineBaseBlockEntity)this, syncID);
    }

    private int isLockedInt() {
        return this.isLocked() ? 1 : 0;
    }

    private void setLockedInt(int lockedInt) {
        this.setLocked(lockedInt == 1);
    }

    public int getStoredAmount() {
        return this.getCurrentCapacity();
    }

    public void setStoredAmount(int storedAmount) {
        this.storedAmount = storedAmount;
    }

    public int getMaxCapacity() {
        return this.maxCapacity;
    }

    public void setMaxCapacity(int maxCapacity) {
        this.maxCapacity = maxCapacity;
        this.serverCapacity = maxCapacity;
    }

    public class_2487 getStoredStackNBT() {
        class_2487 tag = new class_2487();
        this.getStoredStack().method_7953(tag);
        return tag;
    }

    public void setStoredStackFromNBT(class_2487 tag) {
        this.storeItemStack = class_1799.method_7915((class_2487)tag);
    }

    private Storage<ItemVariant> getInternalStoreStorage(final class_2350 side) {
        Objects.requireNonNull(side);
        if (this.internalStoreStorage[side.method_10146()] == null) {
            this.internalStoreStorage[side.method_10146()] = new SingleStackStorage(){

                protected class_1799 getStack() {
                    return StorageUnitBaseBlockEntity.this.storeItemStack;
                }

                protected void setStack(class_1799 stack) {
                    StorageUnitBaseBlockEntity.this.storeItemStack = stack.method_7960() ? class_1799.field_8037 : stack;
                }

                protected int getCapacity(ItemVariant itemVariant) {
                    return StorageUnitBaseBlockEntity.this.maxCapacity - super.getCapacity(itemVariant);
                }

                protected boolean canInsert(ItemVariant itemVariant) {
                    return StorageUnitBaseBlockEntity.this.method_5492(0, itemVariant.toStack(), side);
                }

                protected boolean canExtract(ItemVariant itemVariant) {
                    return StorageUnitBaseBlockEntity.this.method_5493(1, itemVariant.toStack(), side);
                }

                protected void onFinalCommit() {
                    StorageUnitBaseBlockEntity.this.inventory.setHashChanged();
                }
            };
        }
        return this.internalStoreStorage[side.method_10146()];
    }

    public Storage<ItemVariant> getExposedStorage(class_2350 side) {
        return new CombinedStorage(List.of(this.getInternalStoreStorage(side), InventoryStorage.of((class_1263)this, (class_2350)side)));
    }
}

