/*
 * Decompiled with CFR 0.152.
 */
package techreborn.client.compat.rei;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.architectury.event.CompoundEventResult;
import dev.architectury.fluid.FluidStack;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Stream;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.entry.renderer.AbstractEntryRenderer;
import me.shedaniel.rei.api.client.entry.renderer.EntryRenderer;
import me.shedaniel.rei.api.client.gui.AbstractRenderer;
import me.shedaniel.rei.api.client.gui.Renderer;
import me.shedaniel.rei.api.client.gui.widgets.Tooltip;
import me.shedaniel.rei.api.client.gui.widgets.TooltipContext;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.client.plugins.REIClientPlugin;
import me.shedaniel.rei.api.client.registry.category.CategoryRegistry;
import me.shedaniel.rei.api.client.registry.display.DisplayCategory;
import me.shedaniel.rei.api.client.registry.display.DisplayRegistry;
import me.shedaniel.rei.api.client.registry.screen.ExclusionZones;
import me.shedaniel.rei.api.client.registry.screen.ExclusionZonesProvider;
import me.shedaniel.rei.api.client.registry.screen.ScreenRegistry;
import me.shedaniel.rei.api.client.util.ClientEntryStacks;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.entry.comparison.ItemComparatorRegistry;
import me.shedaniel.rei.api.common.fluid.FluidSupportProvider;
import me.shedaniel.rei.api.common.util.EntryStacks;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.render.fluid.v1.FluidRenderHandler;
import net.fabricmc.fabric.api.client.render.fluid.v1.FluidRenderHandlerRegistry;
import net.minecraft.class_1058;
import net.minecraft.class_1723;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1920;
import net.minecraft.class_1935;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_3611;
import net.minecraft.class_4587;
import org.jetbrains.annotations.Nullable;
import reborncore.api.blockentity.IUpgradeable;
import reborncore.client.gui.builder.GuiBase;
import reborncore.client.gui.builder.slot.GuiTab;
import reborncore.client.gui.guibuilder.GuiBuilder;
import reborncore.common.crafting.RebornRecipe;
import reborncore.common.crafting.RebornRecipeType;
import reborncore.common.crafting.RecipeManager;
import reborncore.common.fluid.container.ItemFluidInfo;
import reborncore.common.powerSystem.PowerSystem;
import techreborn.api.generator.EFluidGenerator;
import techreborn.api.generator.FluidGeneratorRecipe;
import techreborn.api.generator.GeneratorRecipeHelper;
import techreborn.api.recipe.recipes.AssemblingMachineRecipe;
import techreborn.api.recipe.recipes.BlastFurnaceRecipe;
import techreborn.api.recipe.recipes.CentrifugeRecipe;
import techreborn.api.recipe.recipes.FluidReplicatorRecipe;
import techreborn.api.recipe.recipes.FusionReactorRecipe;
import techreborn.api.recipe.recipes.IndustrialGrinderRecipe;
import techreborn.api.recipe.recipes.IndustrialSawmillRecipe;
import techreborn.api.recipe.recipes.RollingMachineRecipe;
import techreborn.client.compat.rei.MachineRecipeDisplay;
import techreborn.client.compat.rei.SlotConfigExclusionZones;
import techreborn.client.compat.rei.fluidgenerator.FluidGeneratorRecipeCategory;
import techreborn.client.compat.rei.fluidgenerator.FluidGeneratorRecipeDisplay;
import techreborn.client.compat.rei.fluidreplicator.FluidReplicatorRecipeCategory;
import techreborn.client.compat.rei.fluidreplicator.FluidReplicatorRecipeDisplay;
import techreborn.client.compat.rei.machine.AssemblingMachineCategory;
import techreborn.client.compat.rei.machine.BlastFurnaceCategory;
import techreborn.client.compat.rei.machine.DistillationTowerCategory;
import techreborn.client.compat.rei.machine.ElectrolyzerCategory;
import techreborn.client.compat.rei.machine.GrinderCategory;
import techreborn.client.compat.rei.machine.ImplosionCompressorCategory;
import techreborn.client.compat.rei.machine.IndustrialCentrifugeCategory;
import techreborn.client.compat.rei.machine.OneInputOneOutputCategory;
import techreborn.client.compat.rei.machine.SawmillCategory;
import techreborn.client.compat.rei.machine.TwoInputsCenterOutputCategory;
import techreborn.client.compat.rei.rollingmachine.RollingMachineCategory;
import techreborn.client.compat.rei.rollingmachine.RollingMachineDisplay;
import techreborn.init.ModRecipes;
import techreborn.init.TRContent;

@Environment(value=EnvType.CLIENT)
public class ReiPlugin
implements REIClientPlugin {
    public static final Map<RebornRecipeType<?>, class_1935> iconMap = new HashMap();

    public ReiPlugin() {
        iconMap.put(ModRecipes.ALLOY_SMELTER, TRContent.Machine.ALLOY_SMELTER);
        iconMap.put(ModRecipes.ASSEMBLING_MACHINE, TRContent.Machine.ASSEMBLY_MACHINE);
        iconMap.put(ModRecipes.BLAST_FURNACE, TRContent.Machine.INDUSTRIAL_BLAST_FURNACE);
        iconMap.put(ModRecipes.CENTRIFUGE, TRContent.Machine.INDUSTRIAL_CENTRIFUGE);
        iconMap.put(ModRecipes.CHEMICAL_REACTOR, TRContent.Machine.CHEMICAL_REACTOR);
        iconMap.put(ModRecipes.COMPRESSOR, TRContent.Machine.COMPRESSOR);
        iconMap.put(ModRecipes.DISTILLATION_TOWER, TRContent.Machine.DISTILLATION_TOWER);
        iconMap.put(ModRecipes.EXTRACTOR, TRContent.Machine.EXTRACTOR);
        iconMap.put(ModRecipes.FLUID_REPLICATOR, TRContent.Machine.FLUID_REPLICATOR);
        iconMap.put(ModRecipes.FUSION_REACTOR, TRContent.Machine.FUSION_CONTROL_COMPUTER);
        iconMap.put(ModRecipes.GRINDER, TRContent.Machine.GRINDER);
        iconMap.put(ModRecipes.IMPLOSION_COMPRESSOR, TRContent.Machine.IMPLOSION_COMPRESSOR);
        iconMap.put(ModRecipes.INDUSTRIAL_ELECTROLYZER, TRContent.Machine.INDUSTRIAL_ELECTROLYZER);
        iconMap.put(ModRecipes.INDUSTRIAL_GRINDER, TRContent.Machine.INDUSTRIAL_GRINDER);
        iconMap.put(ModRecipes.INDUSTRIAL_SAWMILL, TRContent.Machine.INDUSTRIAL_SAWMILL);
        iconMap.put(ModRecipes.ROLLING_MACHINE, TRContent.Machine.ROLLING_MACHINE);
        iconMap.put(ModRecipes.SCRAPBOX, (class_1935)TRContent.SCRAP_BOX);
        iconMap.put(ModRecipes.SOLID_CANNING_MACHINE, TRContent.Machine.SOLID_CANNING_MACHINE);
        iconMap.put(ModRecipes.VACUUM_FREEZER, TRContent.Machine.VACUUM_FREEZER);
        iconMap.put(ModRecipes.WIRE_MILL, TRContent.Machine.WIRE_MILL);
    }

    public void registerCategories(CategoryRegistry registry) {
        registry.add(new TwoInputsCenterOutputCategory<RebornRecipe>(ModRecipes.ALLOY_SMELTER));
        registry.add(new AssemblingMachineCategory<AssemblingMachineRecipe>(ModRecipes.ASSEMBLING_MACHINE));
        registry.add(new BlastFurnaceCategory<BlastFurnaceRecipe>(ModRecipes.BLAST_FURNACE));
        registry.add(new IndustrialCentrifugeCategory<CentrifugeRecipe>(ModRecipes.CENTRIFUGE));
        registry.add(new TwoInputsCenterOutputCategory<RebornRecipe>(ModRecipes.CHEMICAL_REACTOR));
        registry.add(new OneInputOneOutputCategory<RebornRecipe>(ModRecipes.COMPRESSOR));
        registry.add(new DistillationTowerCategory<RebornRecipe>(ModRecipes.DISTILLATION_TOWER));
        registry.add(new OneInputOneOutputCategory<RebornRecipe>(ModRecipes.EXTRACTOR));
        registry.add((DisplayCategory)new FluidReplicatorRecipeCategory(ModRecipes.FLUID_REPLICATOR));
        registry.add(new TwoInputsCenterOutputCategory<FusionReactorRecipe>(ModRecipes.FUSION_REACTOR));
        registry.add(new OneInputOneOutputCategory<RebornRecipe>(ModRecipes.GRINDER));
        registry.add(new ImplosionCompressorCategory<RebornRecipe>(ModRecipes.IMPLOSION_COMPRESSOR));
        registry.add(new ElectrolyzerCategory<RebornRecipe>(ModRecipes.INDUSTRIAL_ELECTROLYZER));
        registry.add(new GrinderCategory<IndustrialGrinderRecipe>(ModRecipes.INDUSTRIAL_GRINDER));
        registry.add(new SawmillCategory<IndustrialSawmillRecipe>(ModRecipes.INDUSTRIAL_SAWMILL));
        registry.add((DisplayCategory)new RollingMachineCategory(ModRecipes.ROLLING_MACHINE));
        registry.add(new OneInputOneOutputCategory<RebornRecipe>(ModRecipes.SCRAPBOX));
        registry.add(new TwoInputsCenterOutputCategory<RebornRecipe>(ModRecipes.SOLID_CANNING_MACHINE));
        registry.add(new OneInputOneOutputCategory<RebornRecipe>(ModRecipes.VACUUM_FREEZER));
        registry.add(new OneInputOneOutputCategory<RebornRecipe>(ModRecipes.WIRE_MILL));
        registry.add((DisplayCategory)new FluidGeneratorRecipeCategory(TRContent.Machine.THERMAL_GENERATOR));
        registry.add((DisplayCategory)new FluidGeneratorRecipeCategory(TRContent.Machine.GAS_TURBINE));
        registry.add((DisplayCategory)new FluidGeneratorRecipeCategory(TRContent.Machine.DIESEL_GENERATOR));
        registry.add((DisplayCategory)new FluidGeneratorRecipeCategory(TRContent.Machine.SEMI_FLUID_GENERATOR));
        registry.add((DisplayCategory)new FluidGeneratorRecipeCategory(TRContent.Machine.PLASMA_GENERATOR));
        this.addWorkstations(ModRecipes.ALLOY_SMELTER.name(), EntryStacks.of((class_1935)TRContent.Machine.ALLOY_SMELTER), EntryStacks.of((class_1935)TRContent.Machine.IRON_ALLOY_FURNACE));
        this.addWorkstations(ModRecipes.ASSEMBLING_MACHINE.name(), EntryStacks.of((class_1935)TRContent.Machine.ASSEMBLY_MACHINE));
        this.addWorkstations(ModRecipes.BLAST_FURNACE.name(), EntryStacks.of((class_1935)TRContent.Machine.INDUSTRIAL_BLAST_FURNACE));
        this.addWorkstations(ModRecipes.CENTRIFUGE.name(), EntryStacks.of((class_1935)TRContent.Machine.INDUSTRIAL_CENTRIFUGE));
        this.addWorkstations(ModRecipes.CHEMICAL_REACTOR.name(), EntryStacks.of((class_1935)TRContent.Machine.CHEMICAL_REACTOR));
        this.addWorkstations(ModRecipes.COMPRESSOR.name(), EntryStacks.of((class_1935)TRContent.Machine.COMPRESSOR));
        this.addWorkstations(ModRecipes.DISTILLATION_TOWER.name(), EntryStacks.of((class_1935)TRContent.Machine.DISTILLATION_TOWER));
        this.addWorkstations(ModRecipes.EXTRACTOR.name(), EntryStacks.of((class_1935)TRContent.Machine.EXTRACTOR));
        this.addWorkstations(ModRecipes.FLUID_REPLICATOR.name(), EntryStacks.of((class_1935)TRContent.Machine.FLUID_REPLICATOR));
        this.addWorkstations(ModRecipes.FUSION_REACTOR.name(), EntryStacks.of((class_1935)TRContent.Machine.FUSION_CONTROL_COMPUTER));
        this.addWorkstations(ModRecipes.GRINDER.name(), EntryStacks.of((class_1935)TRContent.Machine.GRINDER));
        this.addWorkstations(ModRecipes.IMPLOSION_COMPRESSOR.name(), EntryStacks.of((class_1935)TRContent.Machine.IMPLOSION_COMPRESSOR));
        this.addWorkstations(ModRecipes.INDUSTRIAL_ELECTROLYZER.name(), EntryStacks.of((class_1935)TRContent.Machine.INDUSTRIAL_ELECTROLYZER));
        this.addWorkstations(ModRecipes.INDUSTRIAL_GRINDER.name(), EntryStacks.of((class_1935)TRContent.Machine.INDUSTRIAL_GRINDER));
        this.addWorkstations(ModRecipes.INDUSTRIAL_SAWMILL.name(), EntryStacks.of((class_1935)TRContent.Machine.INDUSTRIAL_SAWMILL));
        this.addWorkstations(ModRecipes.ROLLING_MACHINE.name(), EntryStacks.of((class_1935)TRContent.Machine.ROLLING_MACHINE));
        this.addWorkstations(ModRecipes.SOLID_CANNING_MACHINE.name(), EntryStacks.of((class_1935)TRContent.Machine.SOLID_CANNING_MACHINE));
        this.addWorkstations(ModRecipes.VACUUM_FREEZER.name(), EntryStacks.of((class_1935)TRContent.Machine.VACUUM_FREEZER));
        this.addWorkstations(ModRecipes.WIRE_MILL.name(), EntryStacks.of((class_1935)TRContent.Machine.WIRE_MILL));
        registry.addWorkstations(CategoryIdentifier.of((String)"techreborn", (String)TRContent.Machine.THERMAL_GENERATOR.name), new EntryStack[]{EntryStacks.of((class_1935)TRContent.Machine.THERMAL_GENERATOR)});
        registry.addWorkstations(CategoryIdentifier.of((String)"techreborn", (String)TRContent.Machine.GAS_TURBINE.name), new EntryStack[]{EntryStacks.of((class_1935)TRContent.Machine.GAS_TURBINE)});
        registry.addWorkstations(CategoryIdentifier.of((String)"techreborn", (String)TRContent.Machine.DIESEL_GENERATOR.name), new EntryStack[]{EntryStacks.of((class_1935)TRContent.Machine.DIESEL_GENERATOR)});
        registry.addWorkstations(CategoryIdentifier.of((String)"techreborn", (String)TRContent.Machine.SEMI_FLUID_GENERATOR.name), new EntryStack[]{EntryStacks.of((class_1935)TRContent.Machine.SEMI_FLUID_GENERATOR)});
        registry.addWorkstations(CategoryIdentifier.of((String)"techreborn", (String)TRContent.Machine.PLASMA_GENERATOR.name), new EntryStack[]{EntryStacks.of((class_1935)TRContent.Machine.PLASMA_GENERATOR)});
    }

    private void addWorkstations(class_2960 identifier, EntryStack<?> ... stacks) {
        CategoryRegistry.getInstance().addWorkstations(CategoryIdentifier.of((class_2960)identifier), stacks);
    }

    public void registerDisplays(DisplayRegistry registry) {
        RecipeManager.getRecipeTypes((String)"techreborn").forEach(rebornRecipeType -> this.registerMachineRecipe(registry, (RebornRecipeType)rebornRecipeType));
        this.registerFluidGeneratorDisplays(registry, EFluidGenerator.THERMAL, TRContent.Machine.THERMAL_GENERATOR);
        this.registerFluidGeneratorDisplays(registry, EFluidGenerator.GAS, TRContent.Machine.GAS_TURBINE);
        this.registerFluidGeneratorDisplays(registry, EFluidGenerator.DIESEL, TRContent.Machine.DIESEL_GENERATOR);
        this.registerFluidGeneratorDisplays(registry, EFluidGenerator.SEMIFLUID, TRContent.Machine.SEMI_FLUID_GENERATOR);
        this.registerFluidGeneratorDisplays(registry, EFluidGenerator.PLASMA, TRContent.Machine.PLASMA_GENERATOR);
    }

    public void registerFluidSupport(FluidSupportProvider support) {
        support.register(stack -> {
            class_3611 fluid;
            class_1799 itemStack = (class_1799)stack.getValue();
            if (itemStack.method_7909() instanceof ItemFluidInfo && (fluid = ((ItemFluidInfo)itemStack.method_7909()).getFluid(itemStack)) != null) {
                return CompoundEventResult.interruptTrue(Stream.of(EntryStacks.of((class_3611)fluid)));
            }
            return CompoundEventResult.pass();
        });
    }

    public void registerItemComparators(ItemComparatorRegistry registry) {
        registry.registerNbt((class_1792)TRContent.CELL);
    }

    private void registerFluidGeneratorDisplays(DisplayRegistry registry, EFluidGenerator generator, TRContent.Machine machine) {
        class_2960 identifier = new class_2960("techreborn", machine.name);
        GeneratorRecipeHelper.getFluidRecipesForGenerator(generator).getRecipes().forEach(recipe -> registry.add((Display)new FluidGeneratorRecipeDisplay((FluidGeneratorRecipe)recipe, identifier)));
    }

    private <R extends RebornRecipe> void registerMachineRecipe(DisplayRegistry registry, RebornRecipeType<R> recipeType) {
        if (recipeType == ModRecipes.RECYCLER) {
            return;
        }
        Function<RebornRecipe, Display> recipeDisplay = r -> new MachineRecipeDisplay<RebornRecipe>((RebornRecipe)r);
        if (recipeType == ModRecipes.ROLLING_MACHINE) {
            recipeDisplay = r -> {
                RollingMachineRecipe rollingMachineRecipe = (RollingMachineRecipe)((Object)r);
                return new RollingMachineDisplay(rollingMachineRecipe.getShapedRecipe());
            };
        }
        if (recipeType == ModRecipes.FLUID_REPLICATOR) {
            recipeDisplay = r -> {
                FluidReplicatorRecipe recipe = (FluidReplicatorRecipe)((Object)r);
                return new FluidReplicatorRecipeDisplay(recipe);
            };
        }
        registry.registerFiller(RebornRecipe.class, recipe -> {
            if (recipe != null) {
                return recipe.getRebornRecipeType() == recipeType;
            }
            return false;
        }, recipeDisplay);
    }

    public void registerScreens(ScreenRegistry registry) {
        ExclusionZones exclusionZones = registry.exclusionZones();
        exclusionZones.register(GuiBase.class, guiBase -> {
            IUpgradeable upgradeable;
            class_2586 patt13745$temp;
            int height = 0;
            if (guiBase.tryAddUpgrades() && (patt13745$temp = guiBase.be) instanceof IUpgradeable && (upgradeable = (IUpgradeable)patt13745$temp).canBeUpgraded()) {
                height = 80;
            }
            for (GuiTab slot : guiBase.getTabs()) {
                if (!slot.enabled()) continue;
                height += 24;
            }
            if (height > 0) {
                int width = 20;
                return Collections.singletonList(new Rectangle(guiBase.getGuiLeft() - width, guiBase.getGuiTop() + 8, width, height));
            }
            return Collections.emptyList();
        });
    }

    public void registerExclusionZones(ExclusionZones zones) {
        zones.register(GuiBase.class, (ExclusionZonesProvider)new SlotConfigExclusionZones());
    }

    public static Widget createProgressBar(int x, int y, double animationDuration, GuiBuilder.ProgressDirection direction) {
        return Widgets.createDrawableWidget((helper, matrices, mouseX, mouseY, delta) -> {
            RenderSystem.setShaderTexture((int)0, (class_2960)GuiBuilder.defaultTextureSheet);
            helper.method_25302(matrices, x, y, direction.x, direction.y, direction.width, direction.height);
            int j = (int)((double)System.currentTimeMillis() / animationDuration % 1.0 * 16.0);
            if (j < 0) {
                j = 0;
            }
            switch (direction) {
                case RIGHT: {
                    helper.method_25302(matrices, x, y, direction.xActive, direction.yActive, j, 10);
                    break;
                }
                case LEFT: {
                    helper.method_25302(matrices, x + 16 - j, y, direction.xActive + 16 - j, direction.yActive, j, 10);
                    break;
                }
                case UP: {
                    helper.method_25302(matrices, x, y + 16 - j, direction.xActive, direction.yActive + 16 - j, 10, j);
                    break;
                }
                case DOWN: {
                    helper.method_25302(matrices, x, y, direction.xActive, direction.yActive, 10, j);
                }
            }
        });
    }

    public static Widget createEnergyDisplay(Rectangle bounds, double energy, EntryAnimation animation, Function<TooltipContext, Tooltip> tooltipBuilder) {
        return Widgets.createSlot((Rectangle)bounds).entry(ClientEntryStacks.of((Renderer)new EnergyEntryRenderer(animation, tooltipBuilder))).notFavoritesInteractable();
    }

    public static Widget createFluidDisplay(Rectangle bounds, EntryStack<FluidStack> fluid, EntryAnimation animation) {
        EntryStack copy = fluid.copy();
        ClientEntryStacks.setRenderer((EntryStack)copy, (EntryRenderer)new FluidStackRenderer(animation, (EntryRenderer<FluidStack>)copy.getRenderer()));
        return Widgets.createSlot((Rectangle)bounds).entry(copy);
    }

    @Environment(value=EnvType.CLIENT)
    private static class EnergyEntryRenderer
    extends AbstractRenderer {
        private final EntryAnimation animation;
        private final Function<TooltipContext, Tooltip> tooltipBuilder;

        protected EnergyEntryRenderer(EntryAnimation animation, Function<TooltipContext, Tooltip> tooltipBuilder) {
            this.animation = animation;
            this.tooltipBuilder = tooltipBuilder;
        }

        public void render(class_4587 matrices, Rectangle bounds, int mouseX, int mouseY, float delta) {
            int innerDisplayHeight;
            int width = bounds.width + 2;
            int height = bounds.height + 2;
            int innerHeight = height - 2;
            PowerSystem.EnergySystem displayPower = PowerSystem.getDisplayPower();
            RenderSystem.setShaderTexture((int)0, (class_2960)GuiBuilder.defaultTextureSheet);
            this.method_25302(matrices, bounds.x - 1, bounds.y - 1, displayPower.xBar - 15, displayPower.yBar - 1, width, height);
            if (this.animation.animationType != EntryAnimationType.NONE) {
                innerDisplayHeight = class_3532.method_15386((float)((float)System.currentTimeMillis() / ((float)this.animation.duration / (float)innerHeight) % (float)innerHeight));
                if (this.animation.animationType == EntryAnimationType.DOWNWARDS) {
                    innerDisplayHeight = innerHeight - innerDisplayHeight;
                }
            } else {
                innerDisplayHeight = innerHeight;
            }
            this.method_25302(matrices, bounds.x, bounds.y + innerHeight - innerDisplayHeight, displayPower.xBar, innerHeight + displayPower.yBar - innerDisplayHeight, width - 2, innerDisplayHeight);
        }

        @Nullable
        public Tooltip getTooltip(TooltipContext context) {
            return this.tooltipBuilder.apply(context);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public record EntryAnimation(EntryAnimationType animationType, long duration) {
        public static EntryAnimation upwards(long duration) {
            return new EntryAnimation(EntryAnimationType.UPWARDS, duration);
        }

        public static EntryAnimation downwards(long duration) {
            return new EntryAnimation(EntryAnimationType.DOWNWARDS, duration);
        }

        public static EntryAnimation none() {
            return new EntryAnimation(EntryAnimationType.NONE, 0L);
        }
    }

    @Environment(value=EnvType.CLIENT)
    private static class FluidStackRenderer
    extends AbstractEntryRenderer<FluidStack> {
        private final EntryAnimation animation;
        private final EntryRenderer<FluidStack> parent;

        public FluidStackRenderer(EntryAnimation animation, EntryRenderer<FluidStack> parent) {
            this.animation = animation;
            this.parent = parent;
        }

        public void render(EntryStack<FluidStack> entry, class_4587 matrices, Rectangle bounds, int mouseX, int mouseY, float delta) {
            int innerDisplayHeight;
            int width = bounds.width;
            int height = bounds.height;
            RenderSystem.setShaderTexture((int)0, (class_2960)GuiBuilder.defaultTextureSheet);
            this.method_25302(matrices, bounds.x - 4, bounds.y - 4, 194, 26, width + 8, height + 8);
            this.method_25302(matrices, bounds.x - 1, bounds.y - 1, 194, 82, width + 2, height + 2);
            if (this.animation.animationType != EntryAnimationType.NONE) {
                innerDisplayHeight = class_3532.method_15386((float)((float)System.currentTimeMillis() / ((float)this.animation.duration / (float)height) % (float)height));
                if (this.animation.animationType == EntryAnimationType.DOWNWARDS) {
                    innerDisplayHeight = height - innerDisplayHeight;
                }
            } else {
                innerDisplayHeight = height;
            }
            this.drawFluid(matrices, ((FluidStack)entry.getValue()).getFluid(), innerDisplayHeight, bounds.x, bounds.y, width, height);
        }

        public void drawFluid(class_4587 matrixStack, class_3611 fluid, int drawHeight, int x, int y, int width, int height) {
            int curHeight;
            RenderSystem.setShaderTexture((int)0, (class_2960)class_1723.field_21668);
            y += height;
            FluidRenderHandler handler = FluidRenderHandlerRegistry.INSTANCE.get(fluid);
            if (handler == null) {
                return;
            }
            class_1058 sprite = handler.getFluidSprites((class_1920)class_310.method_1551().field_1687, class_2338.field_10980, fluid.method_15785())[0];
            int color = FluidRenderHandlerRegistry.INSTANCE.get(fluid).getFluidColor((class_1920)class_310.method_1551().field_1687, class_2338.field_10980, fluid.method_15785());
            int iconHeight = sprite.method_4595();
            RenderSystem.setShaderColor((float)((float)(color >> 16 & 0xFF) / 255.0f), (float)((float)(color >> 8 & 0xFF) / 255.0f), (float)((float)(color & 0xFF) / 255.0f), (float)1.0f);
            int iteration = 0;
            for (int offsetHeight = drawHeight; offsetHeight != 0; offsetHeight -= curHeight) {
                curHeight = Math.min(offsetHeight, iconHeight);
                FluidStackRenderer.method_25298((class_4587)matrixStack, (int)x, (int)(y - offsetHeight), (int)0, (int)width, (int)curHeight, (class_1058)sprite);
                if (++iteration <= 50) continue;
                break;
            }
        }

        @Nullable
        public Tooltip getTooltip(EntryStack<FluidStack> entry, TooltipContext context) {
            return this.parent.getTooltip(entry, context);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static enum EntryAnimationType {
        UPWARDS,
        DOWNWARDS,
        NONE;

    }
}

