/*
 * Decompiled with CFR 0.152.
 */
package terrablender.mixin;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import net.minecraft.class_1959;
import net.minecraft.class_2378;
import net.minecraft.class_5455;
import net.minecraft.class_6544;
import net.minecraft.class_6880;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import terrablender.api.Region;
import terrablender.api.RegionType;
import terrablender.api.Regions;
import terrablender.worldgen.IExtendedParameterList;
import terrablender.worldgen.noise.Area;
import terrablender.worldgen.noise.LayeredNoiseUtil;

@Mixin(value={class_6544.class_6547.class})
public abstract class MixinParameterList<T>
implements IExtendedParameterList<T> {
    @Shadow
    @Final
    private List<Pair<class_6544.class_4762, T>> field_34481;
    private boolean initialized = false;
    private boolean treesPopulated = false;
    private Area uniqueness;
    private class_6544.class_6548[] uniqueTrees;

    @Shadow
    public abstract T method_39529(class_6544.class_6553 var1);

    @Override
    public void initializeForTerraBlender(class_5455 registryAccess, RegionType regionType, long seed) {
        if (this.initialized) {
            return;
        }
        this.uniqueness = LayeredNoiseUtil.uniqueness(registryAccess, regionType, seed);
        this.uniqueTrees = new class_6544.class_6548[Regions.getCount(regionType)];
        class_2378 biomeRegistry = registryAccess.method_30530(class_2378.field_25114);
        for (Region region : Regions.get(regionType)) {
            int regionIndex = Regions.getIndex(regionType, region.getName());
            if (regionIndex == 0) {
                this.uniqueTrees[0] = class_6544.class_6548.method_38153(this.field_34481);
                continue;
            }
            ImmutableList.Builder builder = ImmutableList.builder();
            region.addBiomes((class_2378<class_1959>)biomeRegistry, pair -> builder.add((Object)pair.mapSecond(arg_0 -> ((class_2378)biomeRegistry).method_40290(arg_0))));
            ImmutableList uniqueValues = builder.build();
            if (uniqueValues.isEmpty()) continue;
            this.uniqueTrees[regionIndex] = class_6544.class_6548.method_38153((List)uniqueValues);
        }
        this.treesPopulated = true;
        this.initialized = true;
    }

    @Override
    public int getUniqueness(int x, int y, int z) {
        return this.uniqueness.get(x, z);
    }

    @Override
    public class_6544.class_6548 getTree(int uniqueness) {
        return this.uniqueTrees[uniqueness];
    }

    @Override
    public int getTreeCount() {
        return this.uniqueTrees.length;
    }

    @Override
    public boolean isInitialized() {
        return this.initialized && this.treesPopulated;
    }

    @Override
    public T findValuePositional(class_6544.class_6553 target, int x, int y, int z) {
        if (!this.initialized) {
            return this.method_39529(target);
        }
        if (!this.treesPopulated) {
            throw new RuntimeException("Attempted to call findValuePositional whilst trees remain unpopulated!");
        }
        int uniqueness = this.getUniqueness(x, y, z);
        class_6880 biome = (class_6880)this.getTree(uniqueness).method_38151(target, class_6544.class_6548.class_6550::method_38159);
        if (biome.method_40225(Region.DEFERRED_PLACEHOLDER)) {
            return (T)this.uniqueTrees[0].method_38151(target, class_6544.class_6548.class_6550::method_38159);
        }
        return (T)biome;
    }
}

