/*
 * Decompiled with CFR 0.152.
 */
package terrablender.worldgen.noise;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.class_1959;
import net.minecraft.class_2378;
import net.minecraft.class_5455;
import net.minecraft.class_6008;
import net.minecraft.class_6011;
import terrablender.api.Region;
import terrablender.api.RegionType;
import terrablender.api.Regions;
import terrablender.worldgen.noise.AreaContext;
import terrablender.worldgen.noise.AreaTransformer0;

public class InitialLayer
implements AreaTransformer0 {
    private final RegionType regionType;
    private final WeightedRandomList<class_6008.class_6010<Region>> weightedEntries;

    public InitialLayer(class_5455 registryAccess, RegionType type) {
        class_2378 biomeRegistry = registryAccess.method_30530(class_2378.field_25114);
        this.regionType = type;
        this.weightedEntries = WeightedRandomList.create((List)Regions.get(this.regionType).stream().filter(region -> {
            AtomicBoolean biomesAdded = new AtomicBoolean(false);
            region.addBiomes((class_2378<class_1959>)biomeRegistry, pair -> biomesAdded.set(true));
            return region.getType() == type && biomesAdded.get();
        }).map(region -> class_6008.method_34980((Object)region, (int)region.getWeight())).collect(ImmutableList.toImmutableList()));
    }

    @Override
    public int apply(AreaContext context, int x, int y) {
        Optional<class_6008.class_6010<Region>> entry = this.weightedEntries.getRandom(context);
        return entry.isPresent() ? Regions.getIndex(this.regionType, ((Region)entry.get().method_34983()).getName()) : 0;
    }

    private static class WeightedRandomList<E extends class_6008> {
        private final int totalWeight;
        private final ImmutableList<E> items;

        WeightedRandomList(List<? extends E> items) {
            this.items = ImmutableList.copyOf(items);
            this.totalWeight = class_6011.method_34984(items);
        }

        public static <E extends class_6008> WeightedRandomList<E> create() {
            return new WeightedRandomList<E>(ImmutableList.of());
        }

        @SafeVarargs
        public static <E extends class_6008> WeightedRandomList<E> create(E ... entries) {
            return new WeightedRandomList<E>(ImmutableList.copyOf((Object[])entries));
        }

        public static <E extends class_6008> WeightedRandomList<E> create(List<E> entries) {
            return new WeightedRandomList<E>(entries);
        }

        public Optional<E> getRandom(AreaContext context) {
            if (this.totalWeight == 0) {
                return Optional.empty();
            }
            int i = context.nextRandom(this.totalWeight);
            return class_6011.method_34985(this.items, (int)i);
        }
    }
}

