/*
 * Decompiled with CFR 0.152.
 */
package dev.banzetta.toastmanager;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.banzetta.toastmanager.ControlledDeque;
import dev.banzetta.toastmanager.ToastManager;
import dev.banzetta.toastmanager.ToastManagerConfig;
import java.util.ArrayDeque;
import java.util.BitSet;
import java.util.Deque;
import java.util.Iterator;
import net.minecraft.class_156;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_368;
import net.minecraft.class_374;
import net.minecraft.class_4587;

public class ManagedToastComponent
extends class_374 {
    private Deque<class_374.class_375<?>> topDownList = new ArrayDeque();

    public ManagedToastComponent() {
        super(class_310.method_1551());
        this.field_2240 = new ControlledDeque();
        this.field_39931 = new BitSet((Integer)ToastManagerConfig.INSTANCE.toastCount.get());
    }

    public void method_1996(class_4587 poseStack) {
        class_310 minecraft = class_310.method_1551();
        if (minecraft.field_1690.field_1842) {
            return;
        }
        int width = minecraft.method_22683().method_4486();
        this.field_2239.removeIf(toastInstance -> {
            if (toastInstance != null && toastInstance.method_2002(width, poseStack)) {
                this.field_39931.clear(toastInstance.field_39932, toastInstance.field_39932 + toastInstance.field_39933);
                return true;
            }
            return false;
        });
        if (!this.field_2240.isEmpty() && this.freeSlots() > 0) {
            this.field_2240.removeIf(toast -> {
                int slotCount = toast.method_45072();
                int index = this.findFreeIndex(slotCount);
                if (index != -1) {
                    this.field_2239.add(new ManagedToastInstance(this, toast, index, slotCount));
                    this.field_39931.set(index, index + slotCount);
                    return true;
                }
                return false;
            });
        }
    }

    private int findFreeIndex(int i) {
        if (this.freeSlots() >= i) {
            int j = 0;
            for (int k = 0; k < (Integer)ToastManagerConfig.INSTANCE.toastCount.get(); ++k) {
                if (this.field_39931.get(k)) {
                    j = 0;
                    continue;
                }
                if (++j != i) continue;
                return k + 1 - j;
            }
        }
        return -1;
    }

    private int freeSlots() {
        return (Integer)ToastManagerConfig.INSTANCE.toastCount.get() - this.field_39931.cardinality();
    }

    public class ManagedToastInstance<T extends class_368>
    extends class_374.class_375<T> {
        protected final int index;
        protected int forcedShowTime;
        final /* synthetic */ ManagedToastComponent this$0;

        /*
         * WARNING - Possible parameter corruption
         */
        protected ManagedToastInstance(T toast, int index, int slotCount) {
            this.this$0 = (ManagedToastComponent)this$0;
            super((class_374)this$0, toast, index, slotCount);
            this.forcedShowTime = 0;
            ToastManager.tracker.add(this);
            this.index = index;
        }

        public void tick() {
            ++this.forcedShowTime;
        }

        protected float getVisibility(long sysTime) {
            float f = class_3532.method_15363((float)((float)(sysTime - this.field_2243) / 600.0f), (float)0.0f, (float)1.0f);
            f *= f;
            if (((Boolean)ToastManagerConfig.INSTANCE.noSlide.get()).booleanValue()) {
                return 1.0f;
            }
            return this.forcedShowTime > (Integer)ToastManagerConfig.INSTANCE.forceTime.get() && this.field_2244 == class_368.class_369.field_2209 ? 1.0f - f : f;
        }

        public boolean method_2002(int scaledWidth, class_4587 poseStack) {
            long i = class_156.method_658();
            if (this.field_2243 == -1L) {
                this.field_2243 = i;
                this.field_2244.method_1988(class_310.method_1551().method_1483());
            }
            if (this.field_2244 == class_368.class_369.field_2210 && i - this.field_2243 <= 600L) {
                this.field_2242 = i;
            }
            class_4587 stack = RenderSystem.getModelViewStack();
            stack.method_22903();
            if (((Boolean)ToastManagerConfig.INSTANCE.topDown.get()).booleanValue()) {
                int trueIdx = 0;
                Iterator<class_374.class_375<?>> it = this.this$0.topDownList.iterator();
                while (it.hasNext() && it.next() != this) {
                    ++trueIdx;
                }
                int x = (Boolean)ToastManagerConfig.INSTANCE.startLeft.get() != false ? 0 : scaledWidth - this.field_2241.method_29049();
                stack.method_22904((double)x, (double)((float)((trueIdx - 1) * this.field_2241.method_29050()) + (float)this.field_2241.method_29050() * this.getVisibility(i)), (double)(800 + this.index));
            } else if (((Boolean)ToastManagerConfig.INSTANCE.startLeft.get()).booleanValue()) {
                stack.method_22904((double)((float)(-this.field_2241.method_29049()) + (float)this.field_2241.method_29049() * this.getVisibility(i)), (double)(this.index * this.field_2241.method_29050()), (double)(800 + this.index));
            } else {
                stack.method_22904((double)((float)scaledWidth - (float)this.field_2241.method_29049() * this.getVisibility(i)), (double)(this.index * this.field_2241.method_29050()), (double)(800 + this.index));
            }
            stack.method_22904((double)((Integer)ToastManagerConfig.INSTANCE.offsetX.get()).intValue(), (double)((Integer)ToastManagerConfig.INSTANCE.offsetY.get()).intValue(), 0.0);
            RenderSystem.applyModelViewMatrix();
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            class_368.class_369 itoast$visibility = this.field_2241.method_1986(poseStack, (class_374)this.this$0, i - this.field_2242);
            stack.method_22909();
            RenderSystem.applyModelViewMatrix();
            if (this.forcedShowTime > (Integer)ToastManagerConfig.INSTANCE.forceTime.get() && itoast$visibility != this.field_2244) {
                this.field_2243 = i - (long)((1.0f - this.getVisibility(i)) * 600.0f);
                this.field_2244 = itoast$visibility;
                this.field_2244.method_1988(class_310.method_1551().method_1483());
                if (((Boolean)ToastManagerConfig.INSTANCE.topDown.get()).booleanValue()) {
                    ToastManager.tracker.remove((Object)this);
                    return true;
                }
            }
            if (this.forcedShowTime > (Integer)ToastManagerConfig.INSTANCE.forceTime.get()) {
                ToastManager.tracker.remove((Object)this);
            }
            return this.forcedShowTime > (Integer)ToastManagerConfig.INSTANCE.forceTime.get() && this.field_2244 == class_368.class_369.field_2209 && i - this.field_2243 > 600L;
        }
    }
}

