/*
 * Decompiled with CFR 0.152.
 */
package dev.banzetta.toastmanager;

import com.google.common.base.Predicates;
import dev.banzetta.toastmanager.ToastManager;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.class_310;
import net.minecraftforge.api.fml.event.config.ModConfigEvent;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.tuple.Pair;

public class ToastManagerConfig {
    public static final ForgeConfigSpec SPEC;
    public static final ToastManagerConfig INSTANCE;
    public final ForgeConfigSpec.BooleanValue advancements;
    public final ForgeConfigSpec.BooleanValue recipes;
    public final ForgeConfigSpec.BooleanValue system;
    public final ForgeConfigSpec.BooleanValue tutorial;
    public final ForgeConfigSpec.BooleanValue globalVanilla;
    public final ForgeConfigSpec.BooleanValue globalModded;
    public final ForgeConfigSpec.BooleanValue global;
    public final ForgeConfigSpec.ConfigValue<List<? extends String>> blockedClasses;
    public final ForgeConfigSpec.IntValue forceTime;
    public final ForgeConfigSpec.BooleanValue translucent;
    public final ForgeConfigSpec.BooleanValue transparent;
    public final ForgeConfigSpec.IntValue toastCount;
    public final ForgeConfigSpec.IntValue offsetX;
    public final ForgeConfigSpec.IntValue offsetY;
    public final ForgeConfigSpec.BooleanValue noSlide;
    public final ForgeConfigSpec.BooleanValue startLeft;
    public final ForgeConfigSpec.BooleanValue topDown;
    public final ForgeConfigSpec.BooleanValue printClasses;

    public ToastManagerConfig(ForgeConfigSpec.Builder build) {
        build.comment("Client Configuration").push("client");
        build.push("blocked_toasts");
        this.advancements = build.comment(" If advancement toasts are blocked.").define("advancements", false);
        this.recipes = build.comment(" If recipe toasts are blocked.").define("recipes", true);
        this.system = build.comment(" If system toasts are blocked.").define("system", false);
        this.tutorial = build.comment(" If tutorial toasts are blocked.").define("tutorial", true);
        this.globalVanilla = build.comment(" If all vanilla toasts are blocked.").define("global_vanilla", false);
        this.globalModded = build.comment(" If all non-vanilla toasts are blocked.").define("global_modded", false);
        this.global = build.comment(" If all toasts are blocked.").define("global", false);
        this.blockedClasses = build.comment(" Toast classes that are blocked from being shown.").defineList("blocked_classes", new ArrayList(), (Predicate)Predicates.alwaysTrue());
        build.pop();
        build.push("visual_options");
        this.forceTime = build.comment(" How long a toast must be on the screen for, in ticks.  Use 0 to use the default time.").defineInRange("force_time", 0, 0, 4000);
        this.translucent = build.comment(" If toasts are translucent.  (Must restart Minecraft to apply changes.)").define("translucent", true);
        this.transparent = build.comment(" If toasts are transparent.  Overrides translucency.  (Must restart Minecraft to apply changes.)").define("transparent", false);
        this.toastCount = build.comment(" How many toasts will be displayed on screen at once.").defineInRange("toast_count", 3, 1, 7);
        this.offsetX = build.comment(" The X offset for toasts to be drawn at.").defineInRange("x_offset", 0, -8192, 8192);
        this.offsetY = build.comment(" The Y offset for toasts to be drawn at.").defineInRange("y_offset", 0, -8192, 8192);
        this.noSlide = build.comment(" If toasts automatically pop into the screen without animations.").define("no_slide", false);
        this.startLeft = build.comment(" If toasts show on the left of the screen.").define("start_left", false);
        this.topDown = build.comment(" If toasts will come in from the top of the screen, rather than the side.").define("top_down", false);
        build.pop();
        build.push("debug");
        this.printClasses = build.comment(" If toast class names are printed to the log file when they are shown.").define("print_classes", false);
        build.pop();
        build.pop();
    }

    public static void onLoading(ModConfig config) {
        if (config.getModId().equals("toastmanager")) {
            class_310 minecraft = class_310.method_1551();
            ToastManager.handleToastReloc();
            ToastManager.handleBlockedClasses();
            minecraft.field_1702.method_2000();
            minecraft.field_1702.field_39931 = new BitSet((Integer)ToastManagerConfig.INSTANCE.toastCount.get());
        }
    }

    static {
        ModConfigEvent.LOADING.register(ToastManagerConfig::onLoading);
        Pair specPair = new ForgeConfigSpec.Builder().configure(ToastManagerConfig::new);
        SPEC = (ForgeConfigSpec)specPair.getRight();
        INSTANCE = (ToastManagerConfig)specPair.getLeft();
    }
}

