/*
 * Decompiled with CFR 0.152.
 */
package fuzs.visualworkbench.client.renderer.blockentity;

import fuzs.visualworkbench.VisualWorkbench;
import fuzs.visualworkbench.config.ClientConfig;
import fuzs.visualworkbench.world.level.block.entity.CraftingTableBlockEntity;
import net.minecraft.class_1087;
import net.minecraft.class_1160;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5614;
import net.minecraft.class_809;
import net.minecraft.class_827;
import net.minecraft.class_918;
import org.jetbrains.annotations.Nullable;

public class WorkbenchBlockEntityRenderer
implements class_827<CraftingTableBlockEntity> {
    private final class_918 itemRenderer;

    public WorkbenchBlockEntityRenderer(class_5614.class_5615 context) {
        this.itemRenderer = context.method_43335();
    }

    public void render(CraftingTableBlockEntity blockEntity, float partialTicks, class_4587 poseStack, class_4597 bufferIn, int combinedLightIn, int combinedOverlayIn) {
        combinedLightIn = blockEntity.combinedLight;
        for (int i = 0; i < blockEntity.method_5439(); ++i) {
            class_1799 itemStack = blockEntity.method_5438(i);
            if (itemStack.method_7960()) continue;
            this.renderIngredientItem(blockEntity, partialTicks, poseStack, bufferIn, combinedLightIn, combinedOverlayIn, i, itemStack);
        }
        if (((ClientConfig)VisualWorkbench.CONFIG.get(ClientConfig.class)).renderResult && !blockEntity.getLastResult().method_7960()) {
            this.renderResultItem(blockEntity.getLastResult(), blockEntity.method_10997(), (float)blockEntity.ticks + partialTicks, poseStack, bufferIn, combinedLightIn);
        }
    }

    private void renderIngredientItem(CraftingTableBlockEntity blockEntity, float partialTicks, class_4587 poseStack, class_4597 bufferIn, int combinedLightIn, int combinedOverlayIn, int i, class_1799 itemStack) {
        poseStack.method_22903();
        if (((ClientConfig)VisualWorkbench.CONFIG.get(ClientConfig.class)).flatRendering) {
            this.setupLayingRenderer(blockEntity, partialTicks, poseStack, itemStack, i);
        } else {
            this.setupFloatingRenderer(blockEntity, partialTicks, poseStack, itemStack, i);
        }
        class_310.method_1551().method_1480().method_23178(itemStack, class_809.class_811.field_4319, combinedLightIn, combinedOverlayIn, poseStack, bufferIn, (int)blockEntity.method_11016().method_10063() + i);
        poseStack.method_22909();
    }

    private void setupFloatingRenderer(CraftingTableBlockEntity blockEntity, float partialTicks, class_4587 poseStack, class_1799 itemStack, int index) {
        float shift = (float)Math.abs(((double)((float)blockEntity.ticks + partialTicks) * 50.0 + (double)((long)index * 1000L)) % 5000.0 - 2500.0) / 200000.0f;
        class_1087 model = this.itemRenderer.method_4019(itemStack, null, null, 0);
        boolean blockItem = model.method_4712();
        poseStack.method_22904(0.5, (double)shift, 0.5);
        poseStack.method_22907(class_1160.field_20705.method_23214(class_3532.method_16439((float)partialTicks, (float)blockEntity.currentAngle, (float)blockEntity.nextAngle)));
        poseStack.method_22904((double)(index % 3) * 3.0 / 16.0 + 0.3125 - 0.5, 1.09375, (double)(index / 3) * 3.0 / 16.0 + 0.3125 - 0.5);
        float scale = blockItem ? 0.24f : 0.18f;
        poseStack.method_22905(scale, scale, scale);
    }

    private void setupLayingRenderer(CraftingTableBlockEntity blockEntity, float partialTicks, class_4587 poseStack, class_1799 itemStack, int index) {
        class_1087 model = this.itemRenderer.method_4019(itemStack, null, null, 0);
        boolean blockItem = model.method_4712();
        poseStack.method_22904(0.5, 0.0, 0.5);
        poseStack.method_22907(class_1160.field_20705.method_23214(class_3532.method_16439((float)partialTicks, (float)blockEntity.currentAngle, (float)blockEntity.nextAngle)));
        poseStack.method_22904((double)(index % 3) * 3.0 / 16.0 + 0.3125 - 0.5, blockItem ? 1.0625 : 1.005, (double)(index / 3) * 3.0 / 16.0 + 0.3125 - 0.5);
        poseStack.method_22907(class_1160.field_20703.method_23214(90.0f));
        poseStack.method_22907(class_1160.field_20707.method_23214(180.0f));
        float scale = blockItem ? 0.25f : 0.175f;
        poseStack.method_22905(scale, scale, scale);
    }

    private void renderResultItem(class_1799 stack, @Nullable class_1937 worldIn, float time, class_4587 poseStack, class_4597 bufferIn, int combinedLightIn) {
        poseStack.method_22903();
        poseStack.method_22904(0.5, (double)1.15f, 0.5);
        class_1087 model = class_310.method_1551().method_1480().method_4019(stack, worldIn, null, 0);
        float hoverOffset = class_3532.method_15374((float)(time / 10.0f)) * 0.04f + 0.1f;
        float modelYScale = model.method_4709().method_3503((class_809.class_811)class_809.class_811.field_4318).field_4285.method_4945();
        poseStack.method_22904(0.0, (double)(hoverOffset + 0.25f * modelYScale), 0.0);
        poseStack.method_22907(class_1160.field_20705.method_23626(time / 20.0f));
        if (!model.method_4712()) {
            poseStack.method_22905(0.75f, 0.75f, 0.75f);
        }
        class_310.method_1551().method_1480().method_23179(stack, class_809.class_811.field_4318, false, poseStack, bufferIn, combinedLightIn, class_4608.field_21444, model);
        poseStack.method_22909();
    }
}

