/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.yungsapi.world.jigsaw.piece;

import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.yungnickyoung.minecraft.yungsapi.module.StructurePoolElementTypeModule;
import com.yungnickyoung.minecraft.yungsapi.world.condition.StructureCondition;
import com.yungnickyoung.minecraft.yungsapi.world.condition.StructureConditionType;
import com.yungnickyoung.minecraft.yungsapi.world.structure.context.StructureContext;
import com.yungnickyoung.minecraft.yungsapi.world.structure.terrainadaptation.EnhancedTerrainAdaptation;
import com.yungnickyoung.minecraft.yungsapi.world.structure.terrainadaptation.EnhancedTerrainAdaptationType;
import java.util.Optional;
import net.minecraft.class_3784;
import net.minecraft.class_3785;
import net.minecraft.class_3816;
import net.minecraft.class_5699;

public abstract class YungJigsawPoolElement
extends class_3784 {
    public final Optional<String> name;
    public final Optional<Integer> maxCount;
    @Deprecated
    public final Optional<Integer> minRequiredDepth;
    @Deprecated
    public final Optional<Integer> maxPossibleDepth;
    public final boolean isPriority;
    public final boolean ignoreBounds;
    public final StructureCondition condition;
    public final Optional<EnhancedTerrainAdaptation> enhancedTerrainAdaptation;

    public YungJigsawPoolElement(class_3785.class_3786 projection, Optional<String> name, Optional<Integer> maxCount, Optional<Integer> minRequiredDepth, Optional<Integer> maxPossibleDepth, boolean isPriority, boolean ignoreBounds, StructureCondition condition, Optional<EnhancedTerrainAdaptation> enhancedTerrainAdaptation) {
        super(projection);
        this.name = name;
        this.maxCount = maxCount;
        this.minRequiredDepth = minRequiredDepth;
        this.maxPossibleDepth = maxPossibleDepth;
        this.isPriority = isPriority;
        this.ignoreBounds = ignoreBounds;
        this.condition = condition;
        this.enhancedTerrainAdaptation = enhancedTerrainAdaptation;
    }

    public Optional<String> getName() {
        return this.name;
    }

    public Optional<Integer> getMaxCount() {
        return this.maxCount;
    }

    @Deprecated
    public Optional<Integer> getMinRequiredDepth() {
        return this.minRequiredDepth;
    }

    @Deprecated
    public Optional<Integer> getMaxPossibleDepth() {
        return this.maxPossibleDepth;
    }

    public boolean isPriorityPiece() {
        return this.isPriority;
    }

    public boolean ignoresBounds() {
        return this.ignoreBounds;
    }

    public StructureCondition getCondition() {
        return this.condition;
    }

    public Optional<EnhancedTerrainAdaptation> getEnhancedTerrainAdaptation() {
        return this.enhancedTerrainAdaptation;
    }

    public class_3816<?> method_16757() {
        return StructurePoolElementTypeModule.YUNG_SINGLE_ELEMENT;
    }

    public boolean isAtValidDepth(int depth) {
        boolean isAtMinRequiredDepth = this.minRequiredDepth.isEmpty() || this.minRequiredDepth.get() <= depth;
        boolean isAtMaxAllowableDepth = this.maxPossibleDepth.isEmpty() || this.maxPossibleDepth.get() >= depth;
        return isAtMinRequiredDepth && isAtMaxAllowableDepth;
    }

    public boolean passesConditions(StructureContext ctx) {
        return this.condition.passes(ctx);
    }

    public static <E extends YungJigsawPoolElement> RecordCodecBuilder<E, Optional<String>> nameCodec() {
        return Codec.STRING.optionalFieldOf("name").forGetter(YungJigsawPoolElement::getName);
    }

    public static <E extends YungJigsawPoolElement> RecordCodecBuilder<E, Optional<Integer>> maxCountCodec() {
        return class_5699.field_33441.optionalFieldOf("max_count").forGetter(YungJigsawPoolElement::getMaxCount);
    }

    public static <E extends YungJigsawPoolElement> RecordCodecBuilder<E, Optional<Integer>> minRequiredDepthCodec() {
        return class_5699.field_33441.optionalFieldOf("min_required_depth").forGetter(YungJigsawPoolElement::getMinRequiredDepth);
    }

    public static <E extends YungJigsawPoolElement> RecordCodecBuilder<E, Optional<Integer>> maxPossibleDepthCodec() {
        return class_5699.field_33441.optionalFieldOf("max_possible_depth").forGetter(YungJigsawPoolElement::getMaxPossibleDepth);
    }

    public static <E extends YungJigsawPoolElement> RecordCodecBuilder<E, Boolean> isPriorityCodec() {
        return Codec.BOOL.optionalFieldOf("is_priority", (Object)false).forGetter(YungJigsawPoolElement::isPriorityPiece);
    }

    public static <E extends YungJigsawPoolElement> RecordCodecBuilder<E, Boolean> ignoreBoundsCodec() {
        return Codec.BOOL.optionalFieldOf("ignore_bounds", (Object)false).forGetter(YungJigsawPoolElement::ignoresBounds);
    }

    public static <E extends YungJigsawPoolElement> RecordCodecBuilder<E, StructureCondition> conditionCodec() {
        return StructureConditionType.CONDITION_CODEC.optionalFieldOf("condition", (Object)StructureCondition.ALWAYS_TRUE).forGetter(YungJigsawPoolElement::getCondition);
    }

    public static <E extends YungJigsawPoolElement> RecordCodecBuilder<E, Optional<EnhancedTerrainAdaptation>> enhancedTerrainAdaptationCodec() {
        return EnhancedTerrainAdaptationType.ADAPTATION_CODEC.optionalFieldOf("enhanced_terrain_adaptation").forGetter(YungJigsawPoolElement::getEnhancedTerrainAdaptation);
    }
}

