/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.betterdungeons.world.structure.spider_dungeon.piece;

import com.yungnickyoung.minecraft.betterdungeons.BetterDungeonsCommon;
import com.yungnickyoung.minecraft.betterdungeons.mixin.accessor.BoundingBoxAccessor;
import com.yungnickyoung.minecraft.betterdungeons.module.StructurePieceTypeModule;
import com.yungnickyoung.minecraft.betterdungeons.world.structure.spider_dungeon.piece.SpiderDungeonPiece;
import com.yungnickyoung.minecraft.yungsapi.world.BlockStateRandomizer;
import java.util.BitSet;
import net.minecraft.class_1299;
import net.minecraft.class_1922;
import net.minecraft.class_1923;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2636;
import net.minecraft.class_2680;
import net.minecraft.class_2794;
import net.minecraft.class_2902;
import net.minecraft.class_2919;
import net.minecraft.class_3341;
import net.minecraft.class_3443;
import net.minecraft.class_3532;
import net.minecraft.class_3612;
import net.minecraft.class_3614;
import net.minecraft.class_5138;
import net.minecraft.class_5281;
import net.minecraft.class_5819;
import net.minecraft.class_5820;
import net.minecraft.class_6130;
import net.minecraft.class_6625;

public class SpiderDungeonNestPiece
extends SpiderDungeonPiece {
    private final class_2338 startPos;
    private float xRadius = 0.0f;
    private float yRadius = 0.0f;
    private float zRadius = 0.0f;
    private static final float X_MINRADIUS = 6.0f;
    private static final float X_MAXRADIUS = 10.0f;
    private static final float Y_MINRADIUS = 4.0f;
    private static final float Y_MAXRADIUS = 6.0f;
    private static final float Z_MINRADIUS = 6.0f;
    private static final float Z_MAXRADIUS = 10.0f;
    private static final BlockStateRandomizer COBWEB_SELECTOR = BlockStateRandomizer.from((class_2680[])new class_2680[]{class_2246.field_10343.method_9564()});
    private static final BlockStateRandomizer WOOL_SELECTOR = BlockStateRandomizer.from((class_2680[])new class_2680[]{class_2246.field_10446.method_9564()});

    public SpiderDungeonNestPiece(class_2338 startPos, int pieceChainLength) {
        super(StructurePieceTypeModule.NEST, pieceChainLength, SpiderDungeonNestPiece.getInitialBoundingBox(startPos));
        this.startPos = new class_2338(startPos.method_10263(), startPos.method_10264(), startPos.method_10260());
    }

    public SpiderDungeonNestPiece(class_2487 compoundTag) {
        super(StructurePieceTypeModule.NEST, compoundTag);
        int[] start = compoundTag.method_10561("startPos");
        this.startPos = new class_2338(start[0], start[1], start[2]);
        this.xRadius = compoundTag.method_10583("xRadius");
        this.yRadius = compoundTag.method_10583("yRadius");
        this.zRadius = compoundTag.method_10583("zRadius");
    }

    protected void method_14943(class_6625 structurePieceSerializationContext, class_2487 compoundTag) {
        compoundTag.method_10539("startPos", new int[]{this.startPos.method_10263(), this.startPos.method_10264(), this.startPos.method_10260()});
        compoundTag.method_10548("xRadius", this.xRadius);
        compoundTag.method_10548("yRadius", this.yRadius);
        compoundTag.method_10548("zRadius", this.zRadius);
    }

    public void method_14918(class_3443 structurePiece, class_6130 structurePieceAccessor, class_5819 randomSource) {
        this.xRadius = randomSource.method_43057() * 4.0f + 6.0f;
        this.yRadius = randomSource.method_43057() * 2.0f + 4.0f;
        this.zRadius = randomSource.method_43057() * 4.0f + 6.0f;
        ((BoundingBoxAccessor)this.field_15315).setMinX(this.startPos.method_10263() - (int)this.xRadius - 4);
        ((BoundingBoxAccessor)this.field_15315).setMaxX(this.startPos.method_10263() + (int)this.xRadius + 4);
        ((BoundingBoxAccessor)this.field_15315).setMinY(this.startPos.method_10264() - (int)this.yRadius - 4);
        ((BoundingBoxAccessor)this.field_15315).setMaxY(this.startPos.method_10264() + (int)this.yRadius + 4);
        ((BoundingBoxAccessor)this.field_15315).setMinZ(this.startPos.method_10260() - (int)this.zRadius - 4);
        ((BoundingBoxAccessor)this.field_15315).setMaxZ(this.startPos.method_10260() + (int)this.zRadius + 4);
    }

    public void method_14931(class_5281 world, class_5138 structureManager, class_2794 chunkGenerator, class_5819 randomSource, class_3341 box, class_1923 chunkPos, class_2338 blockPos) {
        class_2338.class_2339 mutable = new class_2338.class_2339();
        class_2919 decoRand = new class_2919((class_5819)new class_5820(0L));
        decoRand.method_12663(world.method_8412(), this.startPos.method_10263(), this.startPos.method_10260());
        int xBits = 4;
        int zBits = 4;
        int yBits = class_3532.method_15342((int)(world.method_31600() - world.method_31607()));
        BitSet carvingMask = new BitSet((int)Math.pow(2.0, xBits + zBits + yBits));
        BlockStateRandomizer shellSelector = new BlockStateRandomizer(class_2246.field_10445.method_9564());
        int[] surface = new int[256];
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                mutable.method_10103(chunkPos.method_8326() + x, 1, chunkPos.method_8328() + z);
                surface[x * 16 + z] = world.method_8624(class_2902.class_2903.field_13194, mutable.method_10263(), mutable.method_10260());
            }
        }
        float caveStartX = this.startPos.method_10263();
        float caveStartY = this.startPos.method_10264();
        float caveStartZ = this.startPos.method_10260();
        int minX = class_3532.method_15375((float)(caveStartX - this.xRadius)) - chunkPos.field_9181 * 16 - 1;
        int maxX = class_3532.method_15375((float)(caveStartX + this.xRadius)) - chunkPos.field_9181 * 16 + 1;
        int minY = class_3532.method_15340((int)(class_3532.method_15375((float)(caveStartY - this.yRadius)) - 1), (int)world.method_31607(), (int)world.method_31600());
        int maxY = class_3532.method_15340((int)(class_3532.method_15375((float)(caveStartY + this.yRadius)) + 1), (int)world.method_31607(), (int)world.method_31600());
        int minZ = class_3532.method_15375((float)(caveStartZ - this.zRadius)) - chunkPos.field_9180 * 16 - 1;
        int maxZ = class_3532.method_15375((float)(caveStartZ + this.zRadius)) - chunkPos.field_9180 * 16 + 1;
        minX = class_3532.method_15340((int)minX, (int)0, (int)15);
        maxX = class_3532.method_15340((int)maxX, (int)0, (int)15);
        minZ = class_3532.method_15340((int)minZ, (int)0, (int)15);
        maxZ = class_3532.method_15340((int)maxZ, (int)0, (int)15);
        for (float x = (float)minX; x <= (float)maxX; x += 1.0f) {
            int globalX = (int)x + chunkPos.field_9181 * 16;
            if (globalX < chunkPos.method_8326() || globalX > chunkPos.method_8327()) continue;
            float radialXDist = ((float)globalX - caveStartX + 0.5f) / this.xRadius;
            for (float z = (float)minZ; z <= (float)maxZ; z += 1.0f) {
                int globalY;
                int globalZ = (int)z + chunkPos.field_9180 * 16;
                if (globalZ < chunkPos.method_8328() || globalZ > chunkPos.method_8329()) continue;
                float radialZDist = ((float)globalZ - caveStartZ + 0.5f) / this.zRadius;
                for (float y = (float)minY; y <= (float)maxY && (globalY = (int)y) <= surface[(int)x % 16 * 16 + (int)z % 16]; y += 1.0f) {
                    class_2680 state;
                    float radialYDist = (y - caveStartY - 0.5f) / this.yRadius;
                    int mask = (int)x | (int)z << 4 | (int)(y - (float)world.method_31607()) << 8;
                    float radialDist = radialXDist * radialXDist + radialYDist * radialYDist + radialZDist * radialZDist;
                    if ((double)radialDist < 1.0) {
                        if ((float)globalX == caveStartX && (float)globalZ == caveStartZ && (float)globalY > caveStartY) {
                            this.method_14917(world, class_2246.field_10446.method_9564(), globalX, globalY, globalZ, box);
                            continue;
                        }
                        if (carvingMask.get(mask) || BLOCK_BLACKLIST.contains(this.method_14929((class_1922)world, globalX, globalY, globalZ, box).method_26204())) continue;
                        this.method_14917(world, class_2246.field_10543.method_9564(), globalX, globalY, globalZ, box);
                        carvingMask.set(mask);
                        continue;
                    }
                    float radialXDistShell = ((float)globalX - caveStartX + 0.5f) / (this.xRadius + 1.2f);
                    float radialYDistShell = (y - caveStartY - 0.5f) / (this.yRadius + 1.2f);
                    float radialZDistShell = ((float)globalZ - caveStartZ + 0.5f) / (this.zRadius + 1.2f);
                    float radialDistShell = radialXDistShell * radialXDistShell + radialYDistShell * radialYDistShell + radialZDistShell * radialZDistShell;
                    if (!((double)radialDistShell < 1.0)) continue;
                    if ((float)globalX == caveStartX && (float)globalZ == caveStartZ && (float)globalY > caveStartY) {
                        this.method_14917(world, class_2246.field_10446.method_9564(), globalX, globalY, globalZ, box);
                        continue;
                    }
                    if (carvingMask.get(mask) || BLOCK_BLACKLIST.contains((state = this.method_14929((class_1922)world, globalX, globalY, globalZ, box)).method_26204()) || state.method_26207() == class_3614.field_15959 || state.method_26227().method_15772() == class_3612.field_15906 && !(decoRand.method_43057() < 0.8f)) continue;
                    this.method_14917(world, shellSelector.get((class_5819)decoRand), globalX, globalY, globalZ, box);
                }
            }
        }
        this.placeSphereRandomized(world, box, (int)caveStartX, (int)caveStartY + 1, (int)caveStartZ, 2.0f, (class_5819)decoRand, 0.5f, WOOL_SELECTOR, true);
        this.method_14917(world, class_2246.field_10446.method_9564(), (int)caveStartX + 1, (int)caveStartY + 1, (int)caveStartZ, box);
        this.method_14917(world, class_2246.field_10446.method_9564(), (int)caveStartX - 1, (int)caveStartY + 1, (int)caveStartZ, box);
        this.method_14917(world, class_2246.field_10446.method_9564(), (int)caveStartX, (int)caveStartY + 1, (int)caveStartZ + 1, box);
        this.method_14917(world, class_2246.field_10446.method_9564(), (int)caveStartX, (int)caveStartY + 1, (int)caveStartZ - 1, box);
        this.method_14917(world, class_2246.field_10446.method_9564(), (int)caveStartX, (int)caveStartY, (int)caveStartZ, box);
        this.placeSphereRandomized(world, box, (int)caveStartX, (int)caveStartY + 1, (int)caveStartZ, 3.0f, (class_5819)decoRand, 0.5f, COBWEB_SELECTOR, true);
        this.method_14917(world, class_2246.field_10260.method_9564(), (int)caveStartX, (int)caveStartY + 1, (int)caveStartZ, box);
        if (box.method_14662((class_2382)this.startPos)) {
            class_2586 spawnerTileEntity = world.method_8321(this.startPos.method_10093(class_2350.field_11036));
            if (spawnerTileEntity instanceof class_2636) {
                ((class_2636)spawnerTileEntity).method_11390().method_8274(class_1299.field_6084);
            } else {
                BetterDungeonsCommon.LOGGER.warn("Expected cave spider spawner entity at {}, but found none!", (Object)this.startPos.method_10093(class_2350.field_11036));
            }
        }
        this.decorateCave(world, (class_5819)decoRand, chunkPos, box, carvingMask);
    }
}

