/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.betterstrongholds.world.placement;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.yungnickyoung.minecraft.betterstrongholds.module.StructurePlacementTypeModule;
import java.util.Optional;
import net.minecraft.class_1923;
import net.minecraft.class_2382;
import net.minecraft.class_2794;
import net.minecraft.class_5699;
import net.minecraft.class_6872;
import net.minecraft.class_6873;
import net.minecraft.class_6874;
import net.minecraft.class_6875;
import net.minecraft.class_7138;

public class BetterStrongholdsPlacement
extends class_6872 {
    public static final Codec<BetterStrongholdsPlacement> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_2382.method_39677((int)16).optionalFieldOf("locate_offset", (Object)class_2382.field_11176).forGetter(rec$ -> ((BetterStrongholdsPlacement)((Object)((Object)((Object)rec$)))).method_41642()), (App)class_6874.class_7154.field_37786.optionalFieldOf("frequency_reduction_method", (Object)class_6874.class_7154.field_37782).forGetter(rec$ -> ((BetterStrongholdsPlacement)((Object)((Object)((Object)rec$)))).method_41643()), (App)Codec.floatRange((float)0.0f, (float)1.0f).optionalFieldOf("frequency", (Object)Float.valueOf(1.0f)).forGetter(rec$ -> Float.valueOf(((BetterStrongholdsPlacement)((Object)((Object)((Object)rec$)))).method_41644())), (App)class_5699.field_33441.fieldOf("salt").forGetter(rec$ -> ((BetterStrongholdsPlacement)((Object)((Object)((Object)rec$)))).method_41645()), (App)class_6874.class_7152.field_37781.optionalFieldOf("exclusion_zone").forGetter(rec$ -> ((BetterStrongholdsPlacement)((Object)((Object)((Object)rec$)))).method_41646()), (App)class_5699.field_33441.fieldOf("spacing").forGetter(class_6872::method_41632), (App)class_5699.field_33441.fieldOf("separation").forGetter(class_6872::method_41633), (App)class_6873.field_36423.optionalFieldOf("spread_type", (Object)class_6873.field_36421).forGetter(class_6872::method_41634), (App)class_5699.field_33441.fieldOf("chunk_distance_to_first_ring").forGetter(BetterStrongholdsPlacement::chunkDistanceToFirstRing), (App)class_5699.field_33441.fieldOf("ring_chunk_thickness").forGetter(BetterStrongholdsPlacement::ringChunkThickness), (App)class_5699.field_33441.optionalFieldOf("max_ring_section").forGetter(BetterStrongholdsPlacement::maxRingSection)).apply((Applicative)instance, instance.stable(BetterStrongholdsPlacement::new)));
    private final int chunkDistanceToFirstRing;
    private final int ringChunkThickness;
    private final Optional<Integer> maxRingSection;

    public BetterStrongholdsPlacement(class_2382 locateOffset, class_6874.class_7154 frequencyReductionMethod, Float frequency, Integer salt, Optional<class_6874.class_7152> exclusionZone, Integer spacing, Integer separation, class_6873 randomSpreadType, Integer chunkDistanceToFirstRing, Integer ringChunkThickness, Optional<Integer> maxRingSection) {
        super(locateOffset, frequencyReductionMethod, frequency.floatValue(), salt.intValue(), exclusionZone, spacing.intValue(), separation.intValue(), randomSpreadType);
        this.chunkDistanceToFirstRing = chunkDistanceToFirstRing;
        this.ringChunkThickness = ringChunkThickness;
        this.maxRingSection = maxRingSection;
    }

    protected boolean method_40168(class_2794 chunkGenerator, class_7138 randomState, long seed, int chunkX, int chunkZ) {
        class_1923 chunkPos = this.method_40169(seed, chunkX, chunkZ);
        if (chunkPos.field_9181 == chunkX && chunkPos.field_9180 == chunkZ) {
            int chunkDistance = (int)Math.sqrt(chunkX * chunkX + chunkZ * chunkZ);
            int shiftedChunkDistance = chunkDistance + (this.ringChunkThickness - this.chunkDistanceToFirstRing);
            int ringSection = shiftedChunkDistance / this.ringChunkThickness;
            if (this.maxRingSection.isPresent() && ringSection > this.maxRingSection.get()) {
                return false;
            }
            return ringSection % 2 == 1;
        }
        return false;
    }

    public class_6875<?> method_40166() {
        return StructurePlacementTypeModule.BETTER_STRONGHOLD_PLACEMENT;
    }

    public int chunkDistanceToFirstRing() {
        return this.chunkDistanceToFirstRing;
    }

    public int ringChunkThickness() {
        return this.ringChunkThickness;
    }

    public Optional<Integer> maxRingSection() {
        return this.maxRingSection;
    }
}

