/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.yungsextras.module;

import com.yungnickyoung.minecraft.yungsapi.io.JSON;
import com.yungnickyoung.minecraft.yungsextras.YungsExtrasCommon;
import com.yungnickyoung.minecraft.yungsextras.config.YEConfigFabric;
import com.yungnickyoung.minecraft.yungsextras.world.WishingWellChances;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.ConfigHolder;
import me.shedaniel.autoconfig.serializer.Toml4jConfigSerializer;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1269;

public class ConfigModuleFabric {
    public static final String CUSTOM_CONFIG_PATH = "YungsExtras";
    public static final String VERSION_PATH = "fabric-1_19";

    public static void init() {
        ConfigModuleFabric.initCustomFiles();
        AutoConfig.register(YEConfigFabric.class, Toml4jConfigSerializer::new);
        AutoConfig.getConfigHolder(YEConfigFabric.class).registerSaveListener(ConfigModuleFabric::bakeConfig);
        AutoConfig.getConfigHolder(YEConfigFabric.class).registerLoadListener(ConfigModuleFabric::bakeConfig);
        ConfigModuleFabric.bakeConfig((YEConfigFabric)AutoConfig.getConfigHolder(YEConfigFabric.class).get());
    }

    private static class_1269 bakeConfig(ConfigHolder<YEConfigFabric> configHolder, YEConfigFabric configFabric) {
        ConfigModuleFabric.bakeConfig(configFabric);
        return class_1269.field_5812;
    }

    private static void initCustomFiles() {
        ConfigModuleFabric.createDirectory();
        ConfigModuleFabric.createBaseReadMe();
        ConfigModuleFabric.createJsonReadMe();
        ConfigModuleFabric.loadJSON();
    }

    private static void loadJSON() {
        ConfigModuleFabric.loadWishingWellsJSON();
    }

    private static void createDirectory() {
        File parentDir = new File(FabricLoader.getInstance().getConfigDir().toString(), CUSTOM_CONFIG_PATH);
        File customConfigDir = new File(parentDir, VERSION_PATH);
        try {
            String filePath = customConfigDir.getCanonicalPath();
            if (customConfigDir.mkdirs()) {
                YungsExtrasCommon.LOGGER.info("Creating directory for additional YUNG's Extras configuration at {}", (Object)filePath);
            }
        }
        catch (IOException e) {
            YungsExtrasCommon.LOGGER.error("ERROR creating YUNG's Extras config directory: {}", (Object)e.toString());
        }
    }

    private static void createBaseReadMe() {
        Path path = Paths.get(FabricLoader.getInstance().getConfigDir().toString(), CUSTOM_CONFIG_PATH, "README.txt");
        File readme = new File(path.toString());
        if (!readme.exists()) {
            String readmeText = "This directory is for a few additional options for YUNG's Extras.\nOptions provided may vary by version.\nThis directory contains subdirectories for supported versions. The first time you run YUNG's Extras, a version subdirectory will be created if that version supports advanced options.\nFor example, the first time you use YUNG's Extras for MC 1.16 on Forge, the 'forge-1_16' subdirectory will be created in this folder.\nIf no subdirectory for your version is created, then that version probably does not support the additional options.\n\nNOTE -- AS OF 1.19, ALL SPAWN RATE RELATED OPTIONS MUST NOW BE MODIFIED VIA DATA PACK.\n";
            try {
                Files.write(path, readmeText.getBytes(), new OpenOption[0]);
            }
            catch (IOException e) {
                YungsExtrasCommon.LOGGER.error("Unable to create README file!");
            }
        }
    }

    private static void createJsonReadMe() {
        Path path = Paths.get(FabricLoader.getInstance().getConfigDir().toString(), CUSTOM_CONFIG_PATH, VERSION_PATH, "README.txt");
        File readme = new File(path.toString());
        if (!readme.exists()) {
            String readmeText = "######################################\n#        wishing_wells.json          #\n######################################\n\nThis file contains a BlockStateRandomizer (see below) describing the probability of a given block being chosen.\nThese probabilities are used for Wishing Wells, which have \nloot deposits at the bottom of them.\n\n######################################\n#       BlockStateRandomizer         #\n######################################\n\nDescribes a set of blockstates and the probability of each blockstate being chosen.\n - entries: An object where each entry's key is a blockstate, and each value is that blockstate's probability of being chosen.\n      The total sum of all probabilities SHOULD NOT exceed 1.0!\n - defaultBlock: The blockstate used for any leftover probability ranges.\n      For example, if the total sum of all the probabilities of the entries is 0.6, then\n      there is a 0.4 chance of the defaultBlock being selected.\n\nHere's an example randomizer:\n\"entries\": {\n  \"minecraft:cobblestone\": 0.25,\n  \"minecraft:air\": 0.2,\n  \"minecraft:stone_bricks\": 0.1\n},\n\"defaultBlock\": \"minecraft:oak_planks\"\n\nFor each block, this randomizer has a 25% chance of returning cobblestone, 20% chance of choosing air,\n10% chance of choosing stone bricks, and a 100 - (25 + 20 + 10) = 45% chance of choosing oak planks (since it's the default block).\n";
            try {
                Files.write(path, readmeText.getBytes(), new OpenOption[0]);
            }
            catch (IOException e) {
                YungsExtrasCommon.LOGGER.error("Unable to create wishing wells README file!");
            }
        }
    }

    private static void loadWishingWellsJSON() {
        Path jsonPath = Paths.get(FabricLoader.getInstance().getConfigDir().toString(), CUSTOM_CONFIG_PATH, VERSION_PATH, "wishing_wells.json");
        File jsonFile = new File(jsonPath.toString());
        if (!jsonFile.exists()) {
            try {
                JSON.createJsonFileFromObject((Path)jsonPath, (Object)WishingWellChances.get());
            }
            catch (IOException e) {
                YungsExtrasCommon.LOGGER.error("Unable to create wishing_wells.json file: {}", (Object)e.toString());
            }
        } else {
            if (!jsonFile.canRead()) {
                YungsExtrasCommon.LOGGER.error("YUNG's Extras wishing_wells.json file not readable! Using default configuration...");
                return;
            }
            try {
                WishingWellChances.instance = (WishingWellChances)JSON.loadObjectFromJsonFile((Path)jsonPath, WishingWellChances.class);
            }
            catch (IOException e) {
                YungsExtrasCommon.LOGGER.error("Error loading YUNG's Extras wishing_wells.json file: {}", (Object)e.toString());
                YungsExtrasCommon.LOGGER.error("Using default configuration...");
            }
        }
    }

    private static void bakeConfig(YEConfigFabric configFabric) {
    }
}

