/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.yungsextras.world.feature;

import com.mojang.serialization.Codec;
import com.yungnickyoung.minecraft.yungsextras.YungsExtrasCommon;
import com.yungnickyoung.minecraft.yungsextras.world.processor.INbtFeatureProcessor;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_2338;
import net.minecraft.class_2960;
import net.minecraft.class_3031;
import net.minecraft.class_3037;
import net.minecraft.class_3492;
import net.minecraft.class_3499;
import net.minecraft.class_5281;
import net.minecraft.class_5425;
import net.minecraft.class_5819;

public abstract class AbstractNbtFeature<C extends class_3037>
extends class_3031<C> {
    protected List<INbtFeatureProcessor> processors = this.useProcessors();

    public AbstractNbtFeature(Codec<C> codec) {
        super(codec);
    }

    protected class_3499 createTemplateFromCenter(class_2960 id, class_5281 level, class_5819 rand, class_2338 centerPos) {
        return this.createTemplateFromCenterWithPlacement(id, level, rand, centerPos, new class_3492());
    }

    protected class_3499 createTemplateFromCenterWithPlacement(class_2960 id, class_5281 level, class_5819 randomSource, class_2338 centerPos, class_3492 placement) {
        Optional templateOptional = level.method_8410().method_14183().method_15094(id);
        if (templateOptional.isEmpty()) {
            YungsExtrasCommon.LOGGER.warn("Failed to create invalid feature {}", (Object)id);
            return null;
        }
        class_3499 template = (class_3499)templateOptional.get();
        class_2338 cornerPos = centerPos.method_10069(-template.method_15160().method_10263() / 2, 0, -template.method_15160().method_10260() / 2);
        template.method_15172((class_5425)level, cornerPos, centerPos, placement, randomSource, 2);
        this.processors.forEach(processor -> processor.processTemplate(template, level, randomSource, cornerPos, centerPos, placement));
        return template;
    }

    protected class_3499 createTemplateFromCorner(class_2960 id, class_5281 level, class_5819 randomSource, class_2338 cornerPos) {
        return this.createTemplateFromCornerWithPlacement(id, level, randomSource, cornerPos, new class_3492());
    }

    protected class_3499 createTemplateFromCornerWithPlacement(class_2960 id, class_5281 level, class_5819 randomSource, class_2338 cornerPos, class_3492 placement) {
        Optional templateOptional = level.method_8410().method_14183().method_15094(id);
        if (templateOptional.isEmpty()) {
            YungsExtrasCommon.LOGGER.warn("Failed to create invalid feature {}", (Object)id);
            return null;
        }
        class_3499 template = (class_3499)templateOptional.get();
        class_2338 centerPos = cornerPos.method_10069(template.method_15160().method_10263() / 2, 0, template.method_15160().method_10260() / 2);
        template.method_15172((class_5425)level, cornerPos, centerPos, placement, randomSource, 2);
        this.processors.forEach(processor -> processor.processTemplate(template, level, randomSource, cornerPos, centerPos, placement));
        return template;
    }

    protected List<INbtFeatureProcessor> useProcessors() {
        return new ArrayList<INbtFeatureProcessor>();
    }
}

