/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.ad_astra.client.screen;

import com.teamresourceful.resourcefulconfig.common.config.ResourcefulConfig;
import com.teamresourceful.resourcefulconfig.common.config.ResourcefulConfigEntry;
import earth.terrarium.ad_astra.AdAstra;
import earth.terrarium.ad_astra.client.screen.PlayerOverlayScreen;
import earth.terrarium.ad_astra.common.config.AdAstraConfig;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_241;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5250;
import net.minecraft.class_768;

public class OverlayConfigScreen
extends class_437 {
    private final class_437 parent;
    private List<Overlay> overlays;
    private double clickedX;
    private double clickedY;
    private double pivotX;
    private double pivotY;
    private boolean dragging;
    private Overlay selectdOverlay;

    public OverlayConfigScreen(class_437 parent) {
        super((class_2561)class_2561.method_43473());
        this.parent = parent;
        this.overlays = new ArrayList<Overlay>();
        this.overlays.add(new OxygenTankOverlay());
        this.overlays.add(new EnergyBarOverlay());
    }

    protected void method_25426() {
        super.method_25426();
        for (Overlay overlay : this.overlays) {
            overlay.load(this.field_22787);
        }
        int buttonCount = 3;
        int buttonWidth = 80;
        int buttonHeight = 20;
        int buttonMargin = 5;
        int totalWidth = buttonCount * buttonWidth + (buttonCount - 1) * buttonMargin;
        int buttonOffset = buttonWidth + buttonMargin;
        int x = (this.field_22789 - totalWidth) / 2;
        int y = this.field_22790 - 27;
        this.method_37063((class_364)new class_4185(x + buttonOffset * 0, y, buttonWidth, buttonHeight, (class_2561)class_2561.method_43471((String)"gui.ad_astra.text.save"), button -> {
            for (Overlay overlay : this.overlays) {
                overlay.save(this.field_22787);
            }
            AdAstra.CONFIGURATOR.saveConfig(AdAstraConfig.class);
            this.method_25419();
        }));
        this.method_37063((class_364)new class_4185(x + buttonOffset * 1, y, buttonWidth, buttonHeight, (class_2561)class_2561.method_43471((String)"gui.ad_astra.text.reset"), button -> {
            for (Overlay overlay : this.overlays) {
                overlay.reset(this.field_22787);
            }
        }));
        this.method_37063((class_364)new class_4185(x + buttonOffset * 2, y, buttonWidth, buttonHeight, (class_2561)class_2561.method_43471((String)"gui.ad_astra.text.back"), button -> this.method_25419()));
    }

    public void method_25419() {
        this.field_22787.method_1507(this.getParent());
        for (Overlay overlay : this.overlays) {
            overlay.revert(this.field_22787);
        }
    }

    public void method_25394(class_4587 poseStack, int mouseX, int mouseY, float delta) {
        this.method_25420(poseStack);
        this.drag(mouseX, mouseY);
        for (Overlay overlay : this.overlays) {
            overlay.apply(this.field_22787);
            overlay.render(poseStack, this.field_22787);
        }
        super.method_25394(poseStack, mouseX, mouseY, delta);
        int x = 10;
        int y = 10;
        class_332.method_27535((class_4587)poseStack, (class_327)this.field_22793, (class_2561)class_2561.method_43471((String)"gui.ad_astra.text.overlay_config1"), (int)x, (int)y, (int)0xFFFFFF);
        class_5250 class_52502 = class_2561.method_43471((String)"gui.ad_astra.text.overlay_config2");
        Objects.requireNonNull(this.field_22793);
        class_332.method_27535((class_4587)poseStack, (class_327)this.field_22793, (class_2561)class_52502, (int)x, (int)(y + 9), (int)0xFFFFFF);
    }

    private void drag(int mouseX, int mouseY) {
        Overlay overlay = this.selectdOverlay;
        if (overlay == null) {
            return;
        }
        if (!this.dragging) {
            int dragThreashold = 3;
            double movementX = (double)mouseX - this.clickedX;
            double movementY = (double)mouseY - this.clickedY;
            boolean bl = this.dragging = Math.abs(movementX) >= (double)dragThreashold || Math.abs(movementY) >= (double)dragThreashold;
        }
        if (!this.dragging) {
            return;
        }
        float scale = overlay.getScale();
        double unscaledMouseX = (float)mouseX / scale;
        double unscaledMouseY = (float)mouseY / scale;
        class_768 renderRect = overlay.getUnscaledRenderRect(this.field_22787);
        class_241 prevPosition = overlay.getUnscaledPosition();
        double offsetX = (double)((float)renderRect.method_3321() - prevPosition.field_1343) + class_3532.method_16436((double)this.pivotX, (double)0.0, (double)renderRect.method_3319());
        double offsetY = (double)((float)renderRect.method_3322() - prevPosition.field_1342) + class_3532.method_16436((double)this.pivotY, (double)0.0, (double)renderRect.method_3320());
        class_241 position = new class_241((float)((int)(unscaledMouseX - offsetX)), (float)((int)(unscaledMouseY - offsetY)));
        overlay.setUnscaledPosition(position);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        Overlay overlay = this.getOverlay(mouseX, mouseY);
        if (overlay != null) {
            this.select(overlay, mouseX, mouseY);
            return true;
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    private Overlay getOverlay(double mouseX, double mouseY) {
        for (Overlay overlay : this.overlays) {
            float scale = overlay.getScale();
            double unscaledMouseX = mouseX / (double)scale;
            double unscaledMouseY = mouseY / (double)scale;
            class_768 renderRect = overlay.getUnscaledRenderRect(this.field_22787);
            if (!renderRect.method_3318((int)unscaledMouseX, (int)unscaledMouseY)) continue;
            return overlay;
        }
        return null;
    }

    public boolean method_25401(double mouseX, double mouseY, double delta) {
        Overlay overlay = this.getOverlay(mouseX, mouseY);
        if (overlay != null) {
            float scale = overlay.getScale();
            double prevUnscaledMouseX = mouseX / (double)scale;
            double prevUnscaledMouseY = mouseY / (double)scale;
            class_768 prevRenderRect = overlay.getUnscaledRenderRect(this.field_22787);
            class_241 prevPosition = overlay.getUnscaledPosition();
            double pivotX = class_3532.method_15370((double)(prevUnscaledMouseX - (double)prevRenderRect.method_3321()), (double)0.0, (double)prevRenderRect.method_3319());
            double pivotY = class_3532.method_15370((double)(prevUnscaledMouseY - (double)prevRenderRect.method_3322()), (double)0.0, (double)prevRenderRect.method_3320());
            float factor = 1.1f;
            scale = delta > 0.0 ? (scale *= factor) : (scale /= factor);
            overlay.setScale(scale);
            double nextUnscaledMouseX = mouseX / (double)scale;
            double nextUnscaledMouseY = mouseY / (double)scale;
            class_768 nextRenderRect = overlay.getUnscaledRenderRect(this.field_22787);
            double errorX = (double)nextRenderRect.method_3321() + class_3532.method_16436((double)pivotX, (double)0.0, (double)nextRenderRect.method_3319()) - nextUnscaledMouseX;
            double errorY = (double)nextRenderRect.method_3322() + class_3532.method_16436((double)pivotY, (double)0.0, (double)nextRenderRect.method_3320()) - nextUnscaledMouseY;
            class_241 position = new class_241((float)((double)prevPosition.field_1343 - errorX), (float)((double)prevPosition.field_1342 - errorY));
            overlay.setUnscaledPosition(position);
            return true;
        }
        return super.method_25401(mouseX, mouseY, delta);
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        this.deselect();
        return super.method_25406(mouseX, mouseY, button);
    }

    private void select(Overlay overlay, double clickedX, double clickedY) {
        float scale = overlay.getScale();
        double unscaledClickedX = clickedX / (double)scale;
        double unscaledClickedY = clickedY / (double)scale;
        class_768 renderRect = overlay.getUnscaledRenderRect(this.field_22787);
        this.clickedX = clickedX;
        this.clickedY = clickedY;
        this.pivotX = class_3532.method_15370((double)(unscaledClickedX - (double)renderRect.method_3321()), (double)0.0, (double)renderRect.method_3319());
        this.pivotY = class_3532.method_15370((double)(unscaledClickedY - (double)renderRect.method_3322()), (double)0.0, (double)renderRect.method_3320());
        this.dragging = false;
        this.selectdOverlay = overlay;
    }

    private void deselect() {
        this.dragging = false;
        this.selectdOverlay = null;
    }

    public boolean method_25421() {
        return this.getParent().method_25421();
    }

    public class_437 getParent() {
        return this.parent;
    }

    public class OxygenTankOverlay
    extends Overlay {
        @Override
        protected void onLoad(class_310 minecraft) {
            this.setUnscaledPosition(AdAstraConfig.oxygenBarXOffset, AdAstraConfig.oxygenBarYOffset);
            this.setScale(AdAstraConfig.oxygenBarScale);
        }

        @Override
        public void apply(class_310 minecraft) {
            class_241 position = this.getUnscaledPosition();
            AdAstraConfig.oxygenBarXOffset = (int)position.field_1343;
            AdAstraConfig.oxygenBarYOffset = (int)position.field_1342;
            AdAstraConfig.oxygenBarScale = this.getScale();
        }

        @Override
        protected void onResetConfig(class_310 minecraft) {
            ResourcefulConfig config = AdAstra.CONFIGURATOR.getConfig(AdAstraConfig.class);
            ((ResourcefulConfigEntry)config.getEntry("oxygenBarXOffset").get()).reset();
            ((ResourcefulConfigEntry)config.getEntry("oxygenBarYOffset").get()).reset();
            ((ResourcefulConfigEntry)config.getEntry("oxygenBarScale").get()).reset();
        }

        @Override
        public void render(class_4587 poseStack, class_310 minecraft) {
            PlayerOverlayScreen.renderOxygenTank(poseStack, minecraft);
        }

        @Override
        public class_768 getUnscaledRenderRect(class_310 minecraft) {
            return PlayerOverlayScreen.getOxygenTankUnscaledRect(minecraft);
        }
    }

    public class EnergyBarOverlay
    extends Overlay {
        @Override
        protected void onLoad(class_310 minecraft) {
            int screenWidth = minecraft.method_22683().method_4486();
            this.setUnscaledPosition(screenWidth - AdAstraConfig.energyBarXOffset, AdAstraConfig.energyBarYOffset);
            this.setScale(AdAstraConfig.energyBarScale);
        }

        @Override
        public void apply(class_310 minecraft) {
            int screenWidth = minecraft.method_22683().method_4486();
            class_241 position = this.getUnscaledPosition();
            AdAstraConfig.energyBarXOffset = (int)((float)screenWidth - position.field_1343);
            AdAstraConfig.energyBarYOffset = (int)position.field_1342;
            AdAstraConfig.energyBarScale = this.getScale();
        }

        @Override
        protected void onResetConfig(class_310 minecraft) {
            ResourcefulConfig config = AdAstra.CONFIGURATOR.getConfig(AdAstraConfig.class);
            ((ResourcefulConfigEntry)config.getEntry("energyBarXOffset").get()).reset();
            ((ResourcefulConfigEntry)config.getEntry("energyBarYOffset").get()).reset();
            ((ResourcefulConfigEntry)config.getEntry("energyBarScale").get()).reset();
        }

        @Override
        public void render(class_4587 poseStack, class_310 minecraft) {
            PlayerOverlayScreen.renderEnergyBar(poseStack, minecraft);
        }

        @Override
        public class_768 getUnscaledRenderRect(class_310 minecraft) {
            return PlayerOverlayScreen.getEnergyBarUnscaledRect(minecraft);
        }
    }

    public abstract class Overlay {
        private class_241 unscaledPositionBackup;
        private class_241 unscaledPosition = new class_241(0.0f, 0.0f);
        private float scaleBackup;
        private float scale = 0.0f;

        public void load(class_310 minecraft) {
            this.onLoad(minecraft);
            this.backup();
        }

        public void revert(class_310 minecraft) {
            this.restore();
            this.apply(minecraft);
        }

        public void reset(class_310 minecraft) {
            this.onResetConfig(minecraft);
            this.onLoad(minecraft);
        }

        public void save(class_310 minecraft) {
            this.apply(minecraft);
            this.backup();
        }

        protected void backup() {
            this.unscaledPositionBackup = this.unscaledPosition;
            this.scaleBackup = this.scale;
        }

        protected void restore() {
            this.unscaledPosition = this.unscaledPositionBackup;
            this.scale = this.scaleBackup;
        }

        protected abstract void onLoad(class_310 var1);

        protected abstract void onResetConfig(class_310 var1);

        public abstract void apply(class_310 var1);

        public abstract void render(class_4587 var1, class_310 var2);

        public abstract class_768 getUnscaledRenderRect(class_310 var1);

        public class_241 getUnscaledPosition() {
            return this.unscaledPosition;
        }

        public void setUnscaledPosition(class_241 position) {
            this.setUnscaledPosition(position.field_1343, position.field_1342);
        }

        public void setUnscaledPosition(float x, float y) {
            this.unscaledPosition = new class_241(x, y);
        }

        public float getScale() {
            return this.scale;
        }

        public void setScale(float scale) {
            this.scale = Math.max(scale, 0.0f);
        }
    }
}

