/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.ad_astra.client.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import earth.terrarium.ad_astra.client.screen.GuiUtil;
import earth.terrarium.ad_astra.common.config.AdAstraConfig;
import earth.terrarium.ad_astra.common.config.VehiclesConfig;
import earth.terrarium.ad_astra.common.util.ModUtils;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_5253;
import net.minecraft.class_5321;
import net.minecraft.class_5348;
import net.minecraft.class_746;
import net.minecraft.class_757;
import net.minecraft.class_768;

@Environment(value=EnvType.CLIENT)
public class PlayerOverlayScreen {
    private static final class_2960 OXYGEN_TANK_EMPTY_TEXTURE = new class_2960("ad_astra", "textures/gui/overlay/oxygen_tank_empty.png");
    private static final class_2960 OXYGEN_TANK_FULL_TEXTURE = new class_2960("ad_astra", "textures/gui/overlay/oxygen_tank_full.png");
    private static final class_2960 EARTH_PLANET_BAR_TEXTURE = new class_2960("ad_astra", "textures/gui/planet_bar/earth_planet_bar.png");
    private static final class_2960 MOON_PLANET_BAR_TEXTURE = new class_2960("ad_astra", "textures/gui/planet_bar/moon_planet_bar.png");
    private static final class_2960 MARS_PLANET_BAR_TEXTURE = new class_2960("ad_astra", "textures/gui/planet_bar/mars_planet_bar.png");
    private static final class_2960 VENUS_PLANET_BAR_TEXTURE = new class_2960("ad_astra", "textures/gui/planet_bar/venus_planet_bar.png");
    private static final class_2960 MERCURY_PLANET_BAR_TEXTURE = new class_2960("ad_astra", "textures/gui/planet_bar/mercury_planet_bar.png");
    private static final class_2960 GLACIO_PLANET_BAR_TEXTURE = new class_2960("ad_astra", "textures/gui/planet_bar/glacio_planet_bar.png");
    private static final class_2960 ORBIT_PLANET_BAR_TEXTURE = new class_2960("ad_astra", "textures/gui/planet_bar/orbit_planet_bar.png");
    private static final class_2960 ROCKET_PLANET_BAR_TEXTURE = new class_2960("ad_astra", "textures/gui/planet_bar/rocket.png");
    private static final class_2561 WARNING_TEXT = class_2561.method_43471((String)"gui.ad_astra.text.warning");
    private static final class_2960 BATTERY_TEXTURE = new class_2960("ad_astra", "textures/gui/overlay/battery.png");
    private static final class_2960 BATTERY_EMPTY_TEXTURE = new class_2960("ad_astra", "textures/gui/overlay/battery_empty.png");
    public static boolean shouldRenderOxygen;
    public static double oxygenRatio;
    public static boolean doesNotNeedOxygen;
    public static int countdownSeconds;
    public static boolean shouldRenderBar;
    public static boolean shouldRenderWarning;
    public static double speed;
    public static boolean shouldRenderBattery;
    public static double batteryRatio;

    public static void render(class_4587 poseStack, float delta) {
        class_310 minecraft = class_310.method_1551();
        int screenWidth = minecraft.method_22683().method_4486();
        int screenHeight = minecraft.method_22683().method_4502();
        class_746 player = minecraft.field_1724;
        if (player == null) {
            return;
        }
        if (player.method_7325()) {
            return;
        }
        if (shouldRenderOxygen && !minecraft.field_1690.field_1866) {
            PlayerOverlayScreen.renderOxygenTank(poseStack, minecraft);
        }
        if (shouldRenderBattery && !minecraft.field_1690.field_1866) {
            PlayerOverlayScreen.renderEnergyBar(poseStack, minecraft);
        }
        if (countdownSeconds > 0) {
            poseStack.method_22903();
            poseStack.method_22904((double)((float)screenWidth / 2.0f), (double)((float)screenHeight / 2.0f), 0.0);
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            poseStack.method_22903();
            poseStack.method_22905(4.0f, 4.0f, 4.0f);
            int m = minecraft.field_1772.method_1727("" + countdownSeconds);
            minecraft.field_1772.method_1720(poseStack, "" + countdownSeconds, (float)(-m / 2), -10.0f, 15020627);
            poseStack.method_22909();
            RenderSystem.disableBlend();
            poseStack.method_22909();
        }
        if (shouldRenderBar && !minecraft.field_1690.field_1866) {
            float rocketHeight = (float)(player.method_23318() / (double)((float)VehiclesConfig.RocketConfig.atmosphereLeave / 113.0f));
            rocketHeight = class_3532.method_15363((float)rocketHeight, (float)0.0f, (float)113.0f);
            int x = 0;
            int y = screenHeight / 2 - 64;
            class_5321 currentWorld = player.method_37908().method_27983();
            class_2960 planet = currentWorld.equals(class_1937.field_25179) ? EARTH_PLANET_BAR_TEXTURE : (currentWorld.equals(ModUtils.MOON_KEY) ? MOON_PLANET_BAR_TEXTURE : (currentWorld.equals(ModUtils.MARS_KEY) ? MARS_PLANET_BAR_TEXTURE : (currentWorld.equals(ModUtils.VENUS_KEY) ? VENUS_PLANET_BAR_TEXTURE : (currentWorld.equals(ModUtils.MERCURY_KEY) ? MERCURY_PLANET_BAR_TEXTURE : (currentWorld.equals(ModUtils.GLACIO_KEY) ? GLACIO_PLANET_BAR_TEXTURE : ORBIT_PLANET_BAR_TEXTURE)))));
            RenderSystem.setShaderTexture((int)0, (class_2960)planet);
            class_332.method_25290((class_4587)poseStack, (int)x, (int)y, (float)0.0f, (float)0.0f, (int)16, (int)128, (int)16, (int)128);
            RenderSystem.setShaderTexture((int)0, (class_2960)ROCKET_PLANET_BAR_TEXTURE);
            GuiUtil.FloatGuiComponent.drawTexture(poseStack, 4.0f, (float)screenHeight / 2.0f + 51.5f - rocketHeight, 0.0f, 0.0f, 8, 11, 8, 11);
        }
        if (shouldRenderWarning) {
            poseStack.method_22903();
            RenderSystem.enableBlend();
            RenderSystem.setShader(class_757::method_34542);
            float sine = (float)Math.sin(((float)minecraft.field_1687.method_8510() + (minecraft.method_1493() ? 0.0f : minecraft.method_1488())) / 5.0f);
            sine = class_3532.method_15363((float)sine, (float)0.0f, (float)1.0f);
            RenderSystem.setShaderColor((float)sine, (float)sine, (float)sine, (float)sine);
            poseStack.method_22903();
            poseStack.method_22904((double)((float)screenWidth / 2.0f), (double)((float)screenHeight / 2.0f / 1.5f), 0.0);
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            poseStack.method_22903();
            poseStack.method_22905(4.0f, 4.0f, 4.0f);
            int m = minecraft.field_1772.method_27525((class_5348)WARNING_TEXT);
            minecraft.field_1772.method_30881(poseStack, WARNING_TEXT, (float)(-m / 2), -10.0f, class_5253.class_5254.method_27764((int)((int)(sine * 255.0f)), (int)((int)(sine * 255.0f)), (int)((int)(sine * 255.0f)), (int)((int)(sine * 255.0f))));
            poseStack.method_22909();
            RenderSystem.disableBlend();
            poseStack.method_22909();
        }
    }

    public static class_768 getOxygenTankUnscaledRect(class_310 minecraft) {
        int x = 5 + AdAstraConfig.oxygenBarXOffset;
        int y = 25 + AdAstraConfig.oxygenBarYOffset;
        int textureWidth = 62;
        int textureHeight = 52;
        return new class_768(x, y, textureWidth, textureHeight);
    }

    public static void renderOxygenTank(class_4587 poseStack, class_310 minecraft) {
        poseStack.method_22903();
        poseStack.method_22905(AdAstraConfig.oxygenBarScale, AdAstraConfig.oxygenBarScale, AdAstraConfig.oxygenBarScale);
        class_768 rect = PlayerOverlayScreen.getOxygenTankUnscaledRect(minecraft);
        GuiUtil.drawVerticalReverse(poseStack, rect.method_3321(), rect.method_3322(), rect.method_3319(), rect.method_3320(), OXYGEN_TANK_EMPTY_TEXTURE, oxygenRatio);
        GuiUtil.drawVertical(poseStack, rect.method_3321(), rect.method_3322(), rect.method_3319(), rect.method_3320(), OXYGEN_TANK_FULL_TEXTURE, oxygenRatio);
        double oxygen = (double)Math.round(oxygenRatio * 1000.0) / 10.0;
        class_2561 text = class_2561.method_30163((String)(oxygen + "%"));
        int textWidth = minecraft.field_1772.method_27525((class_5348)text);
        if (doesNotNeedOxygen) {
            minecraft.field_1772.method_30881(poseStack, text, (float)rect.method_3321() + (float)(rect.method_3319() - textWidth) / 2.0f, (float)(rect.method_3322() + rect.method_3320() + 3), 0x7FFF00);
        } else {
            minecraft.field_1772.method_30881(poseStack, text, (float)rect.method_3321() + (float)(rect.method_3319() - textWidth) / 2.0f, (float)(rect.method_3322() + rect.method_3320() + 3), oxygen <= 0.0 ? 14423100 : 0xFFFFFF);
        }
        poseStack.method_22909();
    }

    public static class_768 getEnergyBarUnscaledRect(class_310 minecraft) {
        int screenWidth = minecraft.method_22683().method_4486();
        int x = screenWidth - 75 - AdAstraConfig.energyBarXOffset;
        int y = 25 + AdAstraConfig.energyBarYOffset;
        int textureWidth = 68;
        int textureHeight = 37;
        return new class_768(x, y, textureWidth, textureHeight);
    }

    public static void renderEnergyBar(class_4587 poseStack, class_310 minecraft) {
        poseStack.method_22903();
        poseStack.method_22905(AdAstraConfig.energyBarScale, AdAstraConfig.energyBarScale, AdAstraConfig.energyBarScale);
        class_768 rect = PlayerOverlayScreen.getEnergyBarUnscaledRect(minecraft);
        GuiUtil.drawHorizontal(poseStack, rect.method_3321(), rect.method_3322(), rect.method_3319(), rect.method_3320(), BATTERY_EMPTY_TEXTURE, 1.0);
        GuiUtil.drawHorizontal(poseStack, rect.method_3321(), rect.method_3322(), rect.method_3319(), rect.method_3320(), BATTERY_TEXTURE, batteryRatio);
        double energy = (double)Math.round(batteryRatio * 1000.0) / 10.0;
        class_2561 text = class_2561.method_30163((String)(energy + "%"));
        int textWidth = minecraft.field_1772.method_27525((class_5348)text);
        minecraft.field_1772.method_30881(poseStack, text, (float)rect.method_3321() + (float)(rect.method_3319() - textWidth) / 2.0f, (float)(rect.method_3322() + rect.method_3320() + 3), 6324918);
        poseStack.method_22909();
    }

    public static void disableAllOverlays() {
        shouldRenderOxygen = false;
        shouldRenderBattery = false;
        shouldRenderBar = false;
        shouldRenderWarning = false;
    }

    public static void disableAllVehicleOverlays() {
        shouldRenderBar = false;
        countdownSeconds = 0;
        shouldRenderWarning = false;
    }
}

