/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.ad_astra.common.block.machine.entity;

import earth.terrarium.ad_astra.common.block.machine.entity.AbstractMachineBlockEntity;
import earth.terrarium.ad_astra.common.config.CryoFreezerConfig;
import earth.terrarium.ad_astra.common.recipe.CryoFuelConversionRecipe;
import earth.terrarium.ad_astra.common.registry.ModBlockEntityTypes;
import earth.terrarium.ad_astra.common.screen.menu.CryoFreezerMenu;
import earth.terrarium.ad_astra.common.util.FluidUtils;
import earth.terrarium.botarium.api.Updatable;
import earth.terrarium.botarium.api.energy.EnergyBlock;
import earth.terrarium.botarium.api.energy.InsertOnlyEnergyContainer;
import earth.terrarium.botarium.api.fluid.ExtractOnlyUpdatingFluidContainer;
import earth.terrarium.botarium.api.fluid.FluidContainer;
import earth.terrarium.botarium.api.fluid.FluidHolder;
import earth.terrarium.botarium.api.fluid.FluidHoldingBlock;
import earth.terrarium.botarium.api.fluid.FluidHooks;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3611;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CryoFreezerBlockEntity
extends AbstractMachineBlockEntity
implements FluidHoldingBlock,
EnergyBlock {
    private InsertOnlyEnergyContainer energyContainer;
    protected int cookTime;
    protected int cookTimeTotal;
    protected class_1799 inputStack = class_1799.field_8037;
    @Nullable
    protected class_3611 outputFluid;
    private ExtractOnlyUpdatingFluidContainer tank;

    public CryoFreezerBlockEntity(class_2338 blockPos, class_2680 blockState) {
        super((class_2591)ModBlockEntityTypes.CRYO_FREEZER.get(), blockPos, blockState);
    }

    @Override
    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        this.cookTime = nbt.method_10550("CookTime");
        this.cookTimeTotal = nbt.method_10550("CookTimeTotal");
    }

    @Override
    public void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        nbt.method_10569("CookTime", this.cookTime);
        nbt.method_10569("CookTimeTotal", this.cookTimeTotal);
    }

    public int getCookTime() {
        return this.cookTime;
    }

    public int getCookTimeTotal() {
        return this.cookTimeTotal;
    }

    public void finishCooking() {
        CryoFuelConversionRecipe recipe;
        if (this.outputFluid != null && (recipe = this.createRecipe(this.method_5438(0), false)) != null) {
            FluidHolder outputFluid = FluidHooks.newFluidHolder((class_3611)recipe.getFluidOutput(), (long)((long)((double)FluidHooks.buckets((double)1.0) * recipe.getConversionRatio())), null);
            this.getFluidContainer().internalInsert(outputFluid, false);
        }
        this.stopCooking();
    }

    public void stopCooking() {
        this.cookTime = 0;
        this.cookTimeTotal = 0;
        this.outputFluid = null;
        this.inputStack = class_1799.field_8037;
        this.method_5431();
    }

    @Override
    public int getInventorySize() {
        return 3;
    }

    @Override
    public boolean method_5492(int slot, class_1799 stack, class_2350 dir) {
        return slot == 0;
    }

    @Override
    public boolean method_5493(int slot, class_1799 stack, class_2350 dir) {
        return slot == 2;
    }

    @Override
    @Nullable
    public class_1703 createMenu(int syncId, @NotNull class_1661 inv, @NotNull class_1657 player) {
        return new CryoFreezerMenu(syncId, inv, this);
    }

    public CryoFuelConversionRecipe createRecipe(class_1799 testStack, boolean checkOutput) {
        this.stopCooking();
        CryoFuelConversionRecipe recipe = CryoFuelConversionRecipe.findFirst(this.field_11863, f -> f.test(testStack));
        if (recipe != null) {
            if (checkOutput) {
                class_1799 outputSlot = this.method_5438(1);
                class_1799 output = recipe.method_8110();
                if (!outputSlot.method_7960() && !outputSlot.method_7909().equals(recipe.method_8110().method_7909()) || outputSlot.method_7947() + output.method_7947() > outputSlot.method_7914()) {
                    return null;
                }
            }
            this.outputFluid = recipe.getFluidOutput();
            this.inputStack = testStack;
        }
        return recipe;
    }

    @Override
    public void tick() {
        if (!this.method_10997().field_9236) {
            class_1799 input = this.method_5438(0);
            class_1799 outputInsertSlot = this.method_5438(1);
            class_1799 outputExtractSlot = this.method_5438(2);
            if (!outputInsertSlot.method_7960() && outputExtractSlot.method_7947() < outputExtractSlot.method_7914()) {
                FluidUtils.extractTankFluidToItem((FluidContainer)this.getFluidContainer(), this, 1, 2, 0, f -> true);
            }
            if (this.getEnergyStorage().internalExtract(this.getEnergyPerTick(), true) > 0L) {
                if (!input.method_7960() && (class_1799.method_7984((class_1799)input, (class_1799)this.inputStack) || this.inputStack.method_7960()) && ((FluidHolder)this.getFluidContainer().getFluids().get(0)).getFluidAmount() < this.getFluidContainer().getTankCapacity(0)) {
                    if (this.cookTime < this.cookTimeTotal) {
                        ++this.cookTime;
                        this.getEnergyStorage().internalExtract(this.getEnergyPerTick(), false);
                        this.update();
                        this.setActive(true);
                    } else if (this.outputFluid != null) {
                        this.finishCooking();
                        input.method_7934(1);
                    } else {
                        CryoFuelConversionRecipe recipe = this.createRecipe(input, false);
                        if (recipe != null) {
                            this.cookTimeTotal = 25;
                            this.cookTime = 0;
                        }
                    }
                } else if (this.outputFluid != null) {
                    this.stopCooking();
                    this.setActive(false);
                } else {
                    this.setActive(false);
                }
            }
        }
    }

    public ExtractOnlyUpdatingFluidContainer getFluidContainer() {
        return this.tank == null ? (this.tank = new ExtractOnlyUpdatingFluidContainer((Updatable)this, i -> CryoFreezerConfig.tankSize, 1, (amount, fluid) -> true)) : this.tank;
    }

    public long getEnergyPerTick() {
        return CryoFreezerConfig.energyPerTick;
    }

    public long getMaxCapacity() {
        return this.getEnergyStorage().getMaxCapacity();
    }

    public InsertOnlyEnergyContainer getEnergyStorage() {
        return this.energyContainer == null ? (this.energyContainer = new InsertOnlyEnergyContainer((Updatable)this, (long)((int)CryoFreezerConfig.maxEnergy))) : this.energyContainer;
    }

    public void update() {
        this.method_5431();
        this.method_10997().method_8413(this.method_11016(), this.method_11010(), this.method_11010(), 3);
    }
}

