/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.ad_astra.common.block.machine.entity;

import earth.terrarium.ad_astra.common.block.machine.AbstractMachineBlock;
import earth.terrarium.ad_astra.common.block.machine.entity.AbstractMachineBlockEntity;
import earth.terrarium.ad_astra.common.config.WaterPumpConfig;
import earth.terrarium.ad_astra.common.container.WaterPumpFluidTank;
import earth.terrarium.ad_astra.common.registry.ModBlockEntityTypes;
import earth.terrarium.ad_astra.common.registry.ModParticleTypes;
import earth.terrarium.ad_astra.common.screen.menu.WaterPumpMenu;
import earth.terrarium.ad_astra.common.util.ModUtils;
import earth.terrarium.botarium.api.Updatable;
import earth.terrarium.botarium.api.energy.EnergyBlock;
import earth.terrarium.botarium.api.energy.InsertOnlyEnergyContainer;
import earth.terrarium.botarium.api.fluid.FluidHolder;
import earth.terrarium.botarium.api.fluid.FluidHoldingBlock;
import earth.terrarium.botarium.api.fluid.FluidHooks;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2400;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3621;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WaterPumpBlockEntity
extends AbstractMachineBlockEntity
implements FluidHoldingBlock,
EnergyBlock {
    private InsertOnlyEnergyContainer energyContainer;
    private long waterExtracted;
    private WaterPumpFluidTank tank;

    public WaterPumpBlockEntity(class_2338 blockPos, class_2680 blockState) {
        super((class_2591)ModBlockEntityTypes.WATER_PUMP.get(), blockPos, blockState);
    }

    @Override
    @Nullable
    public class_1703 createMenu(int syncId, @NotNull class_1661 inv, @NotNull class_1657 player) {
        return new WaterPumpMenu(syncId, inv, this);
    }

    @Override
    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        this.waterExtracted = nbt.method_10537("WaterExtracted");
    }

    @Override
    public void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        nbt.method_10544("WaterExtracted", this.waterExtracted);
    }

    @Override
    public void tick() {
        if (this.field_11863 == null) {
            return;
        }
        if (!this.field_11863.method_8608()) {
            class_2338 below = this.method_11016().method_10074();
            class_3610 water = this.field_11863.method_8316(below);
            if (this.getFluidContainer().getFluids().get(0).getFluidAmount() < this.getFluidContainer().getTankCapacity(0)) {
                if (water.method_15772() instanceof class_3621.class_3623) {
                    FluidHolder waterFluid = FluidHooks.newFluidHolder((class_3611)class_3612.field_15910, (long)WaterPumpConfig.transferPerTick, null);
                    if (!((Boolean)this.method_11010().method_11654((class_2769)AbstractMachineBlock.POWERED)).booleanValue() && this.getEnergyStorage().internalExtract(this.getEnergyPerTick(), true) > 0L && this.getFluidContainer().insertInternal(waterFluid, true) > 0L) {
                        this.setActive(true);
                        ModUtils.spawnForcedParticles((class_3218)this.field_11863, (class_2400)ModParticleTypes.OXYGEN_BUBBLE.get(), (double)this.method_11016().method_10263() + 0.5, (double)this.method_11016().method_10264() - 0.5, (double)this.method_11016().method_10260() + 0.5, 1, 0.0, 0.0, 0.0, 0.01);
                        this.getEnergyStorage().internalExtract(this.getEnergyPerTick(), false);
                        this.waterExtracted += WaterPumpConfig.transferPerTick;
                        this.getFluidContainer().insertInternal(waterFluid, false);
                    } else {
                        this.setActive(false);
                    }
                    if (WaterPumpConfig.deleteWaterBelowWaterPump && this.waterExtracted >= FluidHooks.buckets((double)1.0)) {
                        this.waterExtracted = 0L;
                        class_2680 blockState = this.field_11863.method_8320(below);
                        if (blockState.method_28498((class_2769)class_2741.field_12508)) {
                            this.field_11863.method_8501(below, (class_2680)blockState.method_11657((class_2769)class_2741.field_12508, (Comparable)Boolean.valueOf(false)));
                        } else {
                            this.field_11863.method_8501(below, class_2246.field_10124.method_9564());
                        }
                    }
                }
            } else {
                this.setActive(false);
            }
            if (this.getEnergyStorage().internalExtract(this.getEnergyPerTick(), true) > 0L && !this.getFluidContainer().isEmpty()) {
                FluidHolder fluid = FluidHooks.newFluidHolder((class_3611)this.getFluidContainer().getFluids().get(0).getFluid(), (long)(WaterPumpConfig.transferPerTick * 2L), (class_2487)this.getFluidContainer().getFluids().get(0).getCompound());
                for (class_2350 direction : class_2350.values()) {
                    if (FluidHooks.moveBlockToBlockFluid((class_2586)this, (class_2350)direction.method_10153(), (class_2586)this.field_11863.method_8321(this.field_11867.method_10093(direction)), (class_2350)direction, (FluidHolder)fluid) <= 0L) continue;
                    this.getEnergyStorage().internalExtract(this.getEnergyPerTick(), false);
                    break;
                }
            }
        }
    }

    public WaterPumpFluidTank getFluidContainer() {
        return this.tank == null ? (this.tank = new WaterPumpFluidTank((Updatable)this)) : this.tank;
    }

    public long getEnergyPerTick() {
        return WaterPumpConfig.energyPerTick;
    }

    public long getMaxCapacity() {
        return this.getEnergyStorage().getMaxCapacity();
    }

    public InsertOnlyEnergyContainer getEnergyStorage() {
        return this.energyContainer == null ? (this.energyContainer = new InsertOnlyEnergyContainer((Updatable)this, (long)((int)WaterPumpConfig.maxEnergy))) : this.energyContainer;
    }

    public void update() {
        this.method_5431();
        this.method_10997().method_8413(this.method_11016(), this.method_11010(), this.method_11010(), 3);
    }
}

