/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.ad_astra.common.block.pipe;

import earth.terrarium.ad_astra.common.block.BasicEntityBlock;
import earth.terrarium.ad_astra.common.block.Wrenchable;
import earth.terrarium.ad_astra.common.block.pipe.InteractablePipe;
import earth.terrarium.ad_astra.common.block.pipe.Pipe;
import earth.terrarium.ad_astra.common.block.pipe.PipeDuctBlock;
import earth.terrarium.ad_astra.common.block.pipe.PipeState;
import earth.terrarium.ad_astra.common.registry.ModBlocks;
import earth.terrarium.ad_astra.common.registry.ModItems;
import earth.terrarium.ad_astra.common.registry.ModSoundEvents;
import earth.terrarium.botarium.api.energy.EnergyHooks;
import earth.terrarium.botarium.api.fluid.FluidHooks;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1309;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3726;
import net.minecraft.class_3737;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5558;

public class PipeBlock
extends BasicEntityBlock
implements class_3737,
Pipe,
Wrenchable {
    public static final class_2746 WATERLOGGED = class_2741.field_12508;
    public static final class_2754<PipeState> UP = class_2754.method_11850((String)"up", PipeState.class);
    public static final class_2754<PipeState> DOWN = class_2754.method_11850((String)"down", PipeState.class);
    public static final class_2754<PipeState> NORTH = class_2754.method_11850((String)"north", PipeState.class);
    public static final class_2754<PipeState> EAST = class_2754.method_11850((String)"east", PipeState.class);
    public static final class_2754<PipeState> SOUTH = class_2754.method_11850((String)"south", PipeState.class);
    public static final class_2754<PipeState> WEST = class_2754.method_11850((String)"west", PipeState.class);
    public static final Map<class_2350, class_2754<PipeState>> DIRECTIONS = (Map)class_156.method_654(new HashMap(), map -> {
        map.put(class_2350.field_11036, UP);
        map.put(class_2350.field_11033, DOWN);
        map.put(class_2350.field_11043, NORTH);
        map.put(class_2350.field_11034, EAST);
        map.put(class_2350.field_11035, SOUTH);
        map.put(class_2350.field_11039, WEST);
    });
    private final Map<class_2680, class_265> shapes = new HashMap<class_2680, class_265>();
    private final long transferRate;
    private final PipeType type;

    public PipeBlock(long transferRate, double size, PipeType type, class_4970.class_2251 properties) {
        super(properties);
        this.method_9590((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)this.method_9564().method_11657(UP, (Comparable)((Object)PipeState.NONE))).method_11657(DOWN, (Comparable)((Object)PipeState.NONE))).method_11657(NORTH, (Comparable)((Object)PipeState.NONE))).method_11657(EAST, (Comparable)((Object)PipeState.NONE))).method_11657(SOUTH, (Comparable)((Object)PipeState.NONE))).method_11657(WEST, (Comparable)((Object)PipeState.NONE))).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        this.field_10647.method_11662().forEach(state -> this.shapes.put((class_2680)state, PipeBlock.createVoxelShape(state, size)));
        this.transferRate = transferRate;
        this.type = type;
    }

    public class_1269 method_9534(class_2680 state, class_1937 level, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        class_1799 item = player.method_5998(hand);
        if (item.method_31574((class_1792)ModItems.WRENCH.get())) {
            this.handleWrench(level, pos, state, hit.method_17780(), player, hit.method_17784());
            return class_1269.field_5812;
        }
        return super.method_9534(state, level, pos, player, hand, hit);
    }

    private boolean checkCompat(class_1937 level, class_2338 offset) {
        class_2248 class_22482 = level.method_8320(offset).method_26204();
        if (class_22482 instanceof PipeBlock) {
            PipeBlock pipe = (PipeBlock)class_22482;
            if (this.getType() == PipeType.FLUID_PIPE) {
                return pipe.getType() == PipeType.FLUID_PIPE;
            }
            if (this.getType() == PipeType.CABLE) {
                return pipe.getType() == PipeType.CABLE;
            }
        } else {
            class_22482 = level.method_8320(offset).method_26204();
            if (class_22482 instanceof PipeDuctBlock) {
                PipeDuctBlock pipe = (PipeDuctBlock)class_22482;
                if (this.getType() == PipeType.FLUID_PIPE) {
                    return pipe.equals(ModBlocks.FLUID_PIPE_DUCT.get());
                }
                if (this.getType() == PipeType.CABLE) {
                    return pipe.equals(ModBlocks.CABLE_DUCT.get());
                }
            }
        }
        return false;
    }

    protected void updatePipeState(class_1937 level, class_2338 pos, class_2350 direction) {
        if (!level.field_9236) {
            class_2338 offset = pos.method_10093(direction);
            class_2586 entity = level.method_8321(offset);
            class_2680 blockState = level.method_8320(pos);
            Optional value = blockState.method_28500((class_2769)DIRECTIONS.get(direction));
            if (value.isEmpty()) {
                return;
            }
            if (entity != null && (this.checkCompat(level, offset) || (this.type == PipeType.FLUID_PIPE ? FluidHooks.safeGetBlockFluidManager((class_2586)entity, (class_2350)direction).orElse(null) : EnergyHooks.safeGetBlockEnergyManager((class_2586)entity, (class_2350)direction).orElse(null)) != null)) {
                if (value.get() == PipeState.NONE) {
                    level.method_8652(pos, (class_2680)blockState.method_11657((class_2769)DIRECTIONS.get(direction), (Comparable)((Object)PipeState.NORMAL)), 3);
                }
                if (level.method_8320(offset).method_26204().equals(this)) {
                    level.method_8652(offset, (class_2680)level.method_8320(offset).method_11657((class_2769)DIRECTIONS.get(direction.method_10153()), (Comparable)((Object)PipeState.NORMAL)), 3);
                }
            } else if (value.get() == PipeState.NORMAL) {
                level.method_8652(pos, (class_2680)blockState.method_11657((class_2769)DIRECTIONS.get(direction), (Comparable)((Object)PipeState.NONE)), 3);
            }
        }
    }

    public void updatePipeState(class_1937 level, class_2338 pos) {
        if (!level.field_9236) {
            for (class_2350 direction : class_2350.values()) {
                this.updatePipeState(level, pos, direction);
            }
        }
    }

    @Override
    public long getTransferRate() {
        return this.transferRate;
    }

    public PipeType getType() {
        return this.type;
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{UP, DOWN, NORTH, EAST, SOUTH, WEST, WATERLOGGED});
    }

    public class_2680 method_9605(class_1750 context) {
        return (class_2680)this.method_9564().method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(context.method_8045().method_8316(context.method_8037()).method_15772().equals(class_3612.field_15910)));
    }

    public class_3610 method_9545(class_2680 state) {
        return (Boolean)state.method_11654((class_2769)WATERLOGGED) != false ? class_3612.field_15910.method_15729(false) : super.method_9545(state);
    }

    public class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 neighborState, class_1936 level, class_2338 pos, class_2338 neighborPos) {
        if (((Boolean)state.method_11654((class_2769)WATERLOGGED)).booleanValue()) {
            level.method_39281(pos, (class_3611)class_3612.field_15910, class_3612.field_15910.method_15789((class_4538)level));
        }
        this.updatePipeState((class_1937)level, pos, direction);
        return super.method_9559(state, direction, neighborState, level, pos, neighborPos);
    }

    public <T extends class_2586> class_5558<T> method_31645(class_1937 level, class_2680 state, class_2591<T> type) {
        return (entityLevel, blockPos, blockState, blockEntity) -> {
            if (blockEntity instanceof InteractablePipe) {
                InteractablePipe pipe = (InteractablePipe)blockEntity;
                pipe.pipeTick();
            }
        };
    }

    public void method_9567(class_1937 level, class_2338 pos, class_2680 state, class_1309 placer, class_1799 itemStack) {
        super.method_9567(level, pos, state, placer, itemStack);
        this.updatePipeState(level, pos);
    }

    public class_265 method_9530(class_2680 state, class_1922 level, class_2338 pos, class_3726 context) {
        return this.shapes.getOrDefault(state, class_259.method_1077());
    }

    public void method_9568(class_1799 stack, class_1922 level, List<class_2561> tooltip, class_1836 flag) {
        tooltip.add((class_2561)(this.type == PipeType.FLUID_PIPE ? class_2561.method_43469((String)"item.ad_astra.fluid_transfer_rate.tooltip", (Object[])new Object[]{FluidHooks.toMillibuckets((long)this.getTransferRate())}) : class_2561.method_43469((String)"item.ad_astra.energy_transfer_rate.tooltip", (Object[])new Object[]{this.getTransferRate()})));
    }

    public class_2680 togglePipeState(class_2680 state, class_2754<PipeState> property, class_1657 user) {
        state = (class_2680)state.method_28493(property);
        switch ((PipeState)((Object)state.method_11654(property))) {
            case NORMAL: {
                user.method_7353((class_2561)class_2561.method_43471((String)"info.ad_astra.normal"), true);
                break;
            }
            case INSERT: {
                user.method_7353((class_2561)class_2561.method_43471((String)"info.ad_astra.insert"), true);
                break;
            }
            case EXTRACT: {
                user.method_7353((class_2561)class_2561.method_43471((String)"info.ad_astra.extract"), true);
                break;
            }
            case NONE: {
                user.method_7353((class_2561)class_2561.method_43471((String)"info.ad_astra.none"), true);
            }
        }
        return state;
    }

    public static Optional<class_2350> getDirectionByVec(class_243 hit, class_2338 pos) {
        class_243 relativePos = hit.method_1031((double)(-pos.method_10263()), (double)(-pos.method_10264()), (double)(-pos.method_10260()));
        if (relativePos.field_1352 < 0.125) {
            return Optional.of(class_2350.field_11039);
        }
        if (relativePos.field_1352 > 0.875) {
            return Optional.of(class_2350.field_11034);
        }
        if (relativePos.field_1350 < 0.125) {
            return Optional.of(class_2350.field_11043);
        }
        if (relativePos.field_1350 > 0.875) {
            return Optional.of(class_2350.field_11035);
        }
        if (relativePos.field_1351 < 0.125) {
            return Optional.of(class_2350.field_11033);
        }
        if (relativePos.field_1351 > 0.875) {
            return Optional.of(class_2350.field_11036);
        }
        return Optional.empty();
    }

    @Override
    public void handleWrench(class_1937 level, class_2338 pos, class_2680 state, class_2350 side, class_1657 user, class_243 hitPos) {
        if (!level.field_9236) {
            class_2754<PipeState> property = DIRECTIONS.get(PipeBlock.getDirectionByVec(hitPos, pos).orElse(user.method_5715() ? side.method_10153() : side));
            level.method_30092(pos, this.togglePipeState(state, property, user), 3, 0);
            level.method_8396(null, pos, (class_3414)ModSoundEvents.WRENCH.get(), class_3419.field_15245, 1.0f, 1.0f);
        }
    }

    public static class_265 createVoxelShape(class_2680 state, double size) {
        class_265 shape = class_259.method_1081((double)size, (double)size, (double)size, (double)(1.0 - size), (double)(1.0 - size), (double)(1.0 - size));
        if (state.method_11654(UP) != PipeState.NONE) {
            shape = class_259.method_1084((class_265)shape, (class_265)class_259.method_1081((double)size, (double)size, (double)size, (double)(1.0 - size), (double)1.0, (double)(1.0 - size)));
        }
        if (state.method_11654(DOWN) != PipeState.NONE) {
            shape = class_259.method_1084((class_265)shape, (class_265)class_259.method_1081((double)size, (double)0.0, (double)size, (double)(1.0 - size), (double)(1.0 - size), (double)(1.0 - size)));
        }
        if (state.method_11654(NORTH) != PipeState.NONE) {
            shape = class_259.method_1084((class_265)shape, (class_265)class_259.method_1081((double)size, (double)size, (double)0.0, (double)(1.0 - size), (double)(1.0 - size), (double)(1.0 - size)));
        }
        if (state.method_11654(EAST) != PipeState.NONE) {
            shape = class_259.method_1084((class_265)shape, (class_265)class_259.method_1081((double)size, (double)size, (double)size, (double)1.0, (double)(1.0 - size), (double)(1.0 - size)));
        }
        if (state.method_11654(SOUTH) != PipeState.NONE) {
            shape = class_259.method_1084((class_265)shape, (class_265)class_259.method_1081((double)size, (double)size, (double)size, (double)(1.0 - size), (double)(1.0 - size), (double)1.0));
        }
        if (state.method_11654(WEST) != PipeState.NONE) {
            shape = class_259.method_1084((class_265)shape, (class_265)class_259.method_1081((double)0.0, (double)size, (double)size, (double)(1.0 - size), (double)(1.0 - size), (double)(1.0 - size)));
        }
        return shape;
    }

    public static enum PipeType {
        CABLE,
        FLUID_PIPE;

    }
}

