/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.ad_astra.common.level;

import earth.terrarium.ad_astra.common.config.SpawnConfig;
import earth.terrarium.ad_astra.common.registry.ModEntityTypes;
import earth.terrarium.ad_astra.common.util.ModUtils;
import java.util.Optional;
import java.util.Random;
import net.minecraft.class_1299;
import net.minecraft.class_1317;
import net.minecraft.class_1922;
import net.minecraft.class_1928;
import net.minecraft.class_1937;
import net.minecraft.class_1948;
import net.minecraft.class_2338;
import net.minecraft.class_2902;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_3730;
import net.minecraft.class_3989;
import net.minecraft.class_4153;
import net.minecraft.class_4538;
import net.minecraft.class_5268;
import net.minecraft.class_5304;
import net.minecraft.class_6908;
import net.minecraft.class_7477;
import org.jetbrains.annotations.Nullable;

public class LunarianWanderingTraderManager
implements class_5304 {
    public static final int DEFAULT_SPAWN_DELAY = 24000;
    private static final int DEFAULT_SPAWN_TIMER = 1200;
    private final Random random = new Random();
    private final class_5268 properties;
    private int spawnTimer;
    private int spawnDelay;
    private int spawnChance;

    public LunarianWanderingTraderManager(class_5268 properties) {
        this.properties = properties;
        this.spawnTimer = 1200;
        this.spawnDelay = properties.method_18038();
        this.spawnChance = properties.method_18039();
        if (this.spawnDelay == 0 && this.spawnChance == 0) {
            this.spawnDelay = 24000;
            properties.method_18041(this.spawnDelay);
            this.spawnChance = 25;
            properties.method_18042(this.spawnChance);
        }
    }

    public int method_6445(class_3218 level, boolean spawnMonsters, boolean spawnAnimals) {
        if (!SpawnConfig.spawnLunarianWanderingTrader) {
            return 0;
        }
        if (!level.method_8450().method_8355(class_1928.field_21832)) {
            return 0;
        }
        if (--this.spawnTimer > 0) {
            return 0;
        }
        this.spawnTimer = 1200;
        this.spawnDelay -= 1200;
        this.properties.method_18041(this.spawnDelay);
        if (this.spawnDelay > 0) {
            return 0;
        }
        this.spawnDelay = 24000;
        if (!level.method_8450().method_8355(class_1928.field_19390)) {
            return 0;
        }
        int i = this.spawnChance;
        this.spawnChance = class_3532.method_15340((int)(this.spawnChance + 25), (int)25, (int)75);
        this.properties.method_18042(this.spawnChance);
        if (this.random.nextInt(100) > i) {
            return 0;
        }
        if (this.trySpawn(level)) {
            this.spawnChance = 25;
            return 1;
        }
        return 0;
    }

    private boolean trySpawn(class_3218 level) {
        class_3222 playerEntity = level.method_18779();
        if (playerEntity == null) {
            return true;
        }
        if (this.random.nextInt(10) != 0) {
            return false;
        }
        if (!SpawnConfig.spawnCorruptedLunarians) {
            return false;
        }
        if (!ModUtils.isPlanet((class_1937)level)) {
            return false;
        }
        class_2338 blockPos = playerEntity.method_24515();
        class_4153 pointOfInterestStorage = level.method_19494();
        Optional optional = pointOfInterestStorage.method_19127(holder -> holder.method_40225(class_7477.field_39292), pos -> true, blockPos, 48, class_4153.class_4155.field_18489);
        class_2338 blockPos2 = optional.orElse(blockPos);
        class_2338 blockPos3 = this.getNearbySpawnPos((class_4538)level, blockPos2, 48);
        if (blockPos3 != null && this.doesNotSuffocateAt((class_1922)level, blockPos3)) {
            if (level.method_23753(blockPos3).method_40220(class_6908.field_37383)) {
                return false;
            }
            class_3989 wanderingTraderEntity = (class_3989)((class_1299)ModEntityTypes.LUNARIAN_WANDERING_TRADER.get()).method_5899(level, null, null, null, blockPos3, class_3730.field_16467, false, false);
            if (wanderingTraderEntity != null) {
                this.properties.method_18040(wanderingTraderEntity.method_5667());
                wanderingTraderEntity.method_18013(48000);
                wanderingTraderEntity.method_18069(blockPos2);
                wanderingTraderEntity.method_18408(blockPos2, 16);
                return true;
            }
        }
        return false;
    }

    @Nullable
    private class_2338 getNearbySpawnPos(class_4538 level, class_2338 pos, int range) {
        class_2338 blockPos = null;
        for (int i = 0; i < 10; ++i) {
            int k;
            int j = pos.method_10263() + this.random.nextInt(range * 2) - range;
            class_2338 blockPos2 = new class_2338(j, level.method_8624(class_2902.class_2903.field_13202, j, k = pos.method_10260() + this.random.nextInt(range * 2) - range), k);
            if (!class_1948.method_8660((class_1317.class_1319)class_1317.class_1319.field_6317, (class_4538)level, (class_2338)blockPos2, (class_1299)((class_1299)ModEntityTypes.LUNARIAN_WANDERING_TRADER.get()))) continue;
            blockPos = blockPos2;
            break;
        }
        return blockPos;
    }

    private boolean doesNotSuffocateAt(class_1922 level, class_2338 pos) {
        for (class_2338 blockPos : class_2338.method_10097((class_2338)pos, (class_2338)pos.method_10069(1, 2, 1))) {
            if (level.method_8320(blockPos).method_26220(level, blockPos).method_1110()) continue;
            return false;
        }
        return true;
    }
}

