/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.ad_astra.common.level.feature;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Codec;
import earth.terrarium.ad_astra.common.registry.ModBlocks;
import net.minecraft.class_1945;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_3031;
import net.minecraft.class_5156;
import net.minecraft.class_5281;
import net.minecraft.class_5819;
import net.minecraft.class_5821;
import org.jetbrains.annotations.Nullable;

public class InfernalSpireColumn
extends class_3031<class_5156> {
    private static final ImmutableList<class_2248> CANNOT_PLACE_ON = ImmutableList.of((Object)class_2246.field_10164, (Object)class_2246.field_9987, (Object)class_2246.field_10092, (Object)class_2246.field_10114, (Object)class_2246.field_10266, (Object)class_2246.field_10364, (Object)class_2246.field_10159, (Object)class_2246.field_9974, (Object)class_2246.field_10034, (Object)class_2246.field_10260);

    public InfernalSpireColumn(Codec<class_5156> configCodec) {
        super(configCodec);
    }

    @Nullable
    private static class_2338 findSurface(class_5281 level, int seaLevel, class_2338.class_2339 pos, int calculatedDistance) {
        while (pos.method_10264() > level.method_31607() + 1 && calculatedDistance > 0) {
            --calculatedDistance;
            if (InfernalSpireColumn.canPlaceAt(level, seaLevel, pos)) {
                return pos;
            }
            pos.method_10098(class_2350.field_11033);
        }
        return null;
    }

    private static boolean canPlaceAt(class_5281 level, int seaLevel, class_2338.class_2339 pos) {
        if (!InfernalSpireColumn.isAirOrLavaOcean(level, seaLevel, (class_2338)pos)) {
            return false;
        }
        class_2680 blockstate = level.method_8320((class_2338)pos.method_10098(class_2350.field_11033));
        pos.method_10098(class_2350.field_11036);
        return !blockstate.method_26215() && !CANNOT_PLACE_ON.contains((Object)blockstate.method_26204());
    }

    @Nullable
    private static class_2338 findAir(class_5281 level, class_2338.class_2339 pos, int i) {
        while (pos.method_10264() < level.method_31600() && i > 0) {
            --i;
            class_2680 blockstate = level.method_8320((class_2338)pos);
            if (CANNOT_PLACE_ON.contains((Object)blockstate.method_26204())) {
                return null;
            }
            if (blockstate.method_26215()) {
                return pos;
            }
            pos.method_10098(class_2350.field_11036);
        }
        return null;
    }

    private static boolean isAirOrLavaOcean(class_5281 level, int seaLevel, class_2338 pos) {
        class_2680 blockstate = level.method_8320(pos);
        return blockstate.method_26215() || blockstate.method_27852(class_2246.field_10164) && pos.method_10264() <= seaLevel;
    }

    public boolean method_13151(class_5821<class_5156> context) {
        int seaLevel = context.method_33653().method_16398();
        class_2338 blockpos = context.method_33655();
        class_5819 random = context.method_33654();
        class_5156 config = (class_5156)context.method_33656();
        if (!InfernalSpireColumn.canPlaceAt(context.method_33652(), seaLevel, blockpos.method_25503())) {
            return false;
        }
        int height = config.method_30394().method_35008(random);
        boolean flag = random.method_43057() < 0.9f;
        int k = Math.min(height, flag ? 5 : 8);
        int l = flag ? 50 : 15;
        boolean flag1 = false;
        for (class_2338 randomPos : class_2338.method_27156((class_5819)random, (int)l, (int)(blockpos.method_10263() - k), (int)blockpos.method_10264(), (int)(blockpos.method_10260() - k), (int)(blockpos.method_10263() + k), (int)blockpos.method_10264(), (int)(blockpos.method_10260() + k))) {
            int calculatedDistance = height - randomPos.method_19455((class_2382)blockpos);
            if (calculatedDistance < 0) continue;
            flag1 |= this.placeColumn(context.method_33652(), seaLevel, randomPos, calculatedDistance, config.method_30391().method_35008(random));
        }
        return flag1;
    }

    private boolean placeColumn(class_5281 level, int seaLevel, class_2338 randomPos, int calculatedDistance, int reach) {
        boolean flag = false;
        block0: for (class_2338 blockpos : class_2338.method_10094((int)(randomPos.method_10263() - reach), (int)randomPos.method_10264(), (int)(randomPos.method_10260() - reach), (int)(randomPos.method_10263() + reach), (int)randomPos.method_10264(), (int)(randomPos.method_10260() + reach))) {
            int calculatedDistance2 = blockpos.method_19455((class_2382)randomPos);
            class_2338 blockpos1 = InfernalSpireColumn.isAirOrLavaOcean(level, seaLevel, blockpos) ? InfernalSpireColumn.findSurface(level, seaLevel, blockpos.method_25503(), calculatedDistance2) : InfernalSpireColumn.findAir(level, blockpos.method_25503(), calculatedDistance2);
            if (blockpos1 == null) continue;
            class_2338.class_2339 pos = blockpos1.method_25503();
            for (int j = calculatedDistance - calculatedDistance2 / 2; j >= 0; --j) {
                if (InfernalSpireColumn.isAirOrLavaOcean(level, seaLevel, (class_2338)pos)) {
                    this.method_13153((class_1945)level, (class_2338)pos, ((class_2248)ModBlocks.INFERNAL_SPIRE_BLOCK.get()).method_9564());
                    pos.method_10098(class_2350.field_11036);
                    flag = true;
                    continue;
                }
                if (!level.method_8320((class_2338)pos).method_27852((class_2248)ModBlocks.INFERNAL_SPIRE_BLOCK.get())) continue block0;
                pos.method_10084();
            }
        }
        return flag;
    }
}

