/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.ad_astra.common.recipe.lunarian;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.teamresourceful.resourcefullib.common.codecs.recipes.ItemStackCodec;
import earth.terrarium.ad_astra.common.recipe.ModRecipe;
import earth.terrarium.ad_astra.common.recipe.ModRecipeBuilder;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.class_1799;
import net.minecraft.class_1865;
import net.minecraft.class_2378;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_3852;
import net.minecraft.class_3853;

public abstract class LunarianTradeRecipe
extends ModRecipe {
    private boolean wandering;
    private class_3852 profession;
    private int level;
    private class_1799 buyA;
    private class_1799 buyB;
    private class_1799 sell;
    private int maxUses;
    private int experience;
    private float multiplier;

    protected LunarianTradeRecipe(class_2960 id) {
        super(id);
    }

    protected LunarianTradeRecipe(class_2960 id, Builder<? extends LunarianTradeRecipe> builder) {
        super(id);
        this.wandering = builder.wandering;
        this.profession = builder.profession;
        this.level = builder.level;
        this.buyA = builder.buyA;
        this.buyB = builder.buyB;
        this.sell = builder.sell;
        this.maxUses = builder.maxUses;
        this.experience = builder.experience;
        this.multiplier = builder.multiplier;
    }

    protected void fromJson(JsonObject json) {
        this.wandering = class_3518.method_15258((JsonObject)json, (String)"wandering", (boolean)false);
        this.profession = (class_3852)class_2378.field_17167.method_10223(class_2960.method_12829((String)class_3518.method_15253((JsonObject)json, (String)"profession", (String)"")));
        this.level = class_3518.method_15260((JsonObject)json, (String)"level");
        this.buyA = ItemStackCodec.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)json.get("buyA")).result().orElse(this.getDefaultBuyA());
        this.buyB = ItemStackCodec.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)json.get("buyB")).result().orElse(this.getDefaultBuyB());
        this.sell = ItemStackCodec.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)json.get("sell")).result().orElse(this.getDefaultSell());
        this.maxUses = class_3518.method_15282((JsonObject)json, (String)"maxUses", (int)this.getDefaultMaxUses());
        this.experience = class_3518.method_15282((JsonObject)json, (String)"experience", (int)this.getDefaultExperience());
        this.multiplier = class_3518.method_15277((JsonObject)json, (String)"multiplier", (float)this.getDefaultMultiplier());
    }

    protected void toJson(JsonObject json) {
        if (this.wandering) {
            json.addProperty("wandering", Boolean.valueOf(this.wandering));
        } else {
            json.addProperty("profession", class_2378.field_17167.method_10221((Object)this.profession).toString());
        }
        json.addProperty("level", (Number)this.level);
        if (!this.buyA.method_7960()) {
            json.add("buyA", (JsonElement)ItemStackCodec.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)this.buyA).result().get());
        }
        if (!this.buyB.method_7960()) {
            json.add("buyB", (JsonElement)ItemStackCodec.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)this.buyB).result().get());
        }
        if (!this.sell.method_7960()) {
            json.add("sell", (JsonElement)ItemStackCodec.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)this.sell).result().get());
        }
        if (this.maxUses != this.getDefaultMaxUses()) {
            json.addProperty("maxUses", (Number)this.maxUses);
        }
        if (this.experience != this.getDefaultExperience()) {
            json.addProperty("experience", (Number)this.experience);
        }
        if (this.multiplier != this.getDefaultMultiplier()) {
            json.addProperty("multiplier", (Number)Float.valueOf(this.multiplier));
        }
    }

    protected class_1799 getDefaultBuyA() {
        return class_1799.field_8037;
    }

    protected class_1799 getDefaultBuyB() {
        return class_1799.field_8037;
    }

    protected class_1799 getDefaultSell() {
        return class_1799.field_8037;
    }

    protected int getDefaultMaxUses() {
        return 12;
    }

    protected int getDefaultExperience() {
        return 0;
    }

    protected float getDefaultMultiplier() {
        return 0.05f;
    }

    protected void fromNetwork(class_2540 buffer) {
        this.wandering = buffer.readBoolean();
        this.profession = (class_3852)class_2378.field_17167.method_10223(buffer.method_10810());
        this.level = buffer.readInt();
        this.buyA = buffer.method_10819();
        this.buyB = buffer.method_10819();
        this.sell = buffer.method_10819();
        this.maxUses = buffer.readInt();
        this.experience = buffer.readInt();
        this.multiplier = buffer.readFloat();
    }

    protected void toNetwork(class_2540 buffer) {
        buffer.writeBoolean(this.wandering);
        buffer.method_10812(class_2378.field_17167.method_10221((Object)this.profession));
        buffer.writeInt(this.level);
        buffer.method_10793(this.buyA);
        buffer.method_10793(this.buyB);
        buffer.method_10793(this.sell);
        buffer.writeInt(this.maxUses);
        buffer.writeInt(this.experience);
        buffer.writeFloat(this.multiplier);
    }

    public boolean isWandering() {
        return this.wandering;
    }

    public class_3852 getProfession() {
        return this.profession;
    }

    public int getLevel() {
        return this.level;
    }

    public class_1799 getBuyA() {
        return this.buyA.method_7972();
    }

    public class_1799 getBuyB() {
        return this.buyB.method_7972();
    }

    public class_1799 getSell() {
        return this.sell.method_7972();
    }

    public int getMaxUses() {
        return this.maxUses;
    }

    public int getExperience() {
        return this.experience;
    }

    public float getMultiplier() {
        return this.multiplier;
    }

    public abstract class_3853.class_1652 toItemListing();

    public static class Builder<RECIPE extends LunarianTradeRecipe>
    extends ModRecipeBuilder<RECIPE> {
        private final BiFunction<class_2960, Builder<RECIPE>, RECIPE> function;
        private boolean wandering = false;
        private class_3852 profession = class_3852.field_17051;
        private int level = 0;
        private class_1799 buyA = class_1799.field_8037;
        private class_1799 buyB = class_1799.field_8037;
        private class_1799 sell = class_1799.field_8037;
        private int maxUses = 0;
        private int experience = 0;
        private float multiplier = 0.0f;

        public Builder(BiFunction<class_2960, ? extends Builder<RECIPE>, RECIPE> function) {
            this.function = function;
        }

        public Builder<RECIPE> wandring() {
            this.wandering = true;
            this.profession = null;
            return this;
        }

        public Builder<RECIPE> profession(class_3852 profession) {
            this.wandering = false;
            this.profession = profession;
            return this;
        }

        public Builder<RECIPE> level(int level) {
            this.level = level;
            return this;
        }

        public Builder<RECIPE> buy(class_1799 buyA) {
            return this.buy(buyA, class_1799.field_8037);
        }

        public Builder<RECIPE> buy(class_1799 buyA, class_1799 buyB) {
            this.buyA = buyA;
            this.buyB = buyB;
            return this;
        }

        public Builder<RECIPE> sell(class_1799 sell) {
            this.sell = sell;
            return this;
        }

        public Builder<RECIPE> maxUses(int maxUses) {
            this.maxUses = maxUses;
            return this;
        }

        public Builder<RECIPE> experience(int experience) {
            this.experience = experience;
            return this;
        }

        public Builder<RECIPE> multiplier(float multiplier) {
            this.multiplier = multiplier;
            return this;
        }

        public boolean isWandering() {
            return this.wandering;
        }

        public class_3852 getProfession() {
            return this.profession;
        }

        public int getLevel() {
            return this.level;
        }

        public class_1799 getBuyA() {
            return this.buyA;
        }

        public class_1799 getBuyB() {
            return this.buyB;
        }

        public class_1799 getSell() {
            return this.sell;
        }

        public int getMaxUses() {
            return this.maxUses;
        }

        public int getExperience() {
            return this.experience;
        }

        public float getMultiplier() {
            return this.multiplier;
        }

        public ModRecipeBuilder.ModFinishedRecipe build(class_2960 id) {
            final LunarianTradeRecipe recipe = (LunarianTradeRecipe)this.function.apply(id, this);
            return new ModRecipeBuilder.ModFinishedRecipe(this, id){

                @Override
                public void method_10416(JsonObject json) {
                    super.method_10416(json);
                    recipe.toJson(json);
                }

                public class_1865<?> method_17800() {
                    return recipe.method_8119();
                }
            };
        }
    }

    public static class Serializer<RECIPE extends LunarianTradeRecipe>
    implements class_1865<RECIPE> {
        private final Function<class_2960, RECIPE> function;

        public Serializer(Function<class_2960, RECIPE> function) {
            this.function = function;
        }

        public RECIPE fromJson(class_2960 id, JsonObject json) {
            LunarianTradeRecipe recipe = (LunarianTradeRecipe)this.function.apply(id);
            recipe.fromJson(json);
            return (RECIPE)recipe;
        }

        public RECIPE fromNetwork(class_2960 id, class_2540 buffer) {
            LunarianTradeRecipe recipe = (LunarianTradeRecipe)this.function.apply(id);
            recipe.fromNetwork(buffer);
            return (RECIPE)recipe;
        }

        public void toNetwork(class_2540 buffer, RECIPE recipe) {
            ((LunarianTradeRecipe)recipe).toNetwork(buffer);
        }
    }
}

