/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.ad_astra.common.util;

import earth.terrarium.ad_astra.common.container.DoubleFluidTank;
import earth.terrarium.ad_astra.common.recipe.ConversionRecipe;
import earth.terrarium.botarium.api.fluid.FluidContainer;
import earth.terrarium.botarium.api.fluid.FluidHolder;
import earth.terrarium.botarium.api.fluid.FluidHooks;
import earth.terrarium.botarium.api.fluid.PlatformFluidItemHandler;
import earth.terrarium.botarium.api.item.ItemStackHolder;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.class_1263;
import net.minecraft.class_1799;
import net.minecraft.class_3611;

public class FluidUtils {
    public static <T extends ConversionRecipe> boolean convertFluid(DoubleFluidTank tanks, List<T> recipes, long transferPerTick) {
        FluidHolder inputHolder = (FluidHolder)tanks.getInput().getFluids().get(0);
        FluidHolder fluidToTransfer = FluidHooks.newFluidHolder((class_3611)inputHolder.getFluid(), (long)transferPerTick, null);
        for (ConversionRecipe recipe : recipes) {
            long outputAmount;
            FluidHolder convertedFluid;
            long extracted;
            double conversionRatio = recipe.getConversionRatio();
            class_3611 recipeOutputFluid = recipe.getFluidOutput();
            if (!recipe.matches(inputHolder.getFluid()) || (extracted = tanks.getInput().extractFluid(fluidToTransfer, true).getFluidAmount()) <= 0L || (convertedFluid = FluidHooks.newFluidHolder((class_3611)recipeOutputFluid, (long)(outputAmount = (long)((double)extracted * conversionRatio)), null)).isEmpty() || fluidToTransfer.isEmpty() || tanks.getOutput().insertFluid(convertedFluid, true) <= 0L) continue;
            tanks.getInput().extractFluid(fluidToTransfer, false);
            tanks.getOutput().insertFluid(convertedFluid, false);
            return true;
        }
        return false;
    }

    public static boolean insertItemFluidToTank(FluidContainer tank, class_1263 inventory, int inputSlot, int outputSlot, int container, Predicate<class_3611> filter) {
        PlatformFluidItemHandler itemFluidHandler;
        FluidHolder itemHolder;
        class_1799 stack = inventory.method_5438(inputSlot).method_7972();
        if (stack.method_7960()) {
            return false;
        }
        int originalCount = stack.method_7947();
        stack.method_7939(1);
        Optional possibleItemFluidContainer = FluidHooks.safeGetItemFluidManager((class_1799)stack);
        if (possibleItemFluidContainer.isPresent() && filter.test((itemHolder = (itemFluidHandler = (PlatformFluidItemHandler)possibleItemFluidContainer.get()).getFluidInTank(container)).getFluid())) {
            FluidHolder fluidToTransfer = FluidHooks.newFluidHolder((class_3611)itemHolder.getFluid(), (long)itemHolder.getFluidAmount(), null);
            if (fluidToTransfer.isEmpty()) {
                return false;
            }
            ItemStackHolder item = new ItemStackHolder(inventory.method_5438(inputSlot).method_7972());
            FluidHolder extracted = itemFluidHandler.extractFluid(item, fluidToTransfer, true);
            if (extracted.isEmpty()) {
                return false;
            }
            long l = tank.insertFluid(extracted, true);
            extracted.setAmount(l);
            if (l == itemFluidHandler.extractFluid(item, fluidToTransfer, true).getFluidAmount()) {
                fluidToTransfer.setAmount(l);
                itemFluidHandler.extractFluid(item, fluidToTransfer, false);
                tank.insertFluid(fluidToTransfer, false);
                if (item.isDirty()) {
                    class_1799 copy = item.getStack().method_7972();
                    class_1799 stack1 = inventory.method_5438(outputSlot);
                    if (stack1.method_7960() && (!copy.method_7985() || !class_1799.method_7975((class_1799)copy, (class_1799)inventory.method_5438(inputSlot))) || class_1799.method_7975((class_1799)copy, (class_1799)stack1) && class_1799.method_7987((class_1799)copy, (class_1799)stack1) && copy.method_7947() + stack1.method_7947() <= copy.method_7914()) {
                        copy.method_7939(copy.method_7947() + stack1.method_7947());
                        inventory.method_5447(outputSlot, copy);
                        inventory.method_5438(inputSlot).method_7939(originalCount - 1);
                    } else {
                        itemFluidHandler.insertFluid(item, fluidToTransfer, false);
                        tank.extractFluid(fluidToTransfer, false);
                    }
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean extractTankFluidToItem(FluidContainer tank, class_1263 inventory, int inputSlot, int outputSlot, int container, Predicate<class_3611> filter) {
        class_1799 stack = inventory.method_5438(inputSlot).method_7972();
        if (stack.method_7960()) {
            return false;
        }
        int originalCount = stack.method_7947();
        stack.method_7939(1);
        Optional possibleItemFluidContainer = FluidHooks.safeGetItemFluidManager((class_1799)stack);
        if (possibleItemFluidContainer.isPresent()) {
            PlatformFluidItemHandler itemFluidHandler = (PlatformFluidItemHandler)possibleItemFluidContainer.get();
            FluidHolder tankHolder = (FluidHolder)tank.getFluids().get(container);
            if (filter.test(tankHolder.getFluid())) {
                FluidHolder fluidToTransfer = FluidHooks.newFluidHolder((class_3611)tankHolder.getFluid(), (long)tankHolder.getFluidAmount(), null);
                if (fluidToTransfer.isEmpty()) {
                    return false;
                }
                ItemStackHolder item = new ItemStackHolder(inventory.method_5438(inputSlot).method_7972());
                FluidHolder extracted = tank.extractFluid(fluidToTransfer, true);
                if (extracted.isEmpty()) {
                    return false;
                }
                long l = itemFluidHandler.insertFluid(item, extracted, true);
                extracted.setAmount(l);
                if (l > 0L && tank.extractFluid(extracted, true).getFluidAmount() == itemFluidHandler.insertFluid(item, fluidToTransfer, true)) {
                    fluidToTransfer.setAmount(l);
                    tank.extractFluid(fluidToTransfer, false);
                    itemFluidHandler.insertFluid(item, fluidToTransfer, false);
                    if (item.isDirty()) {
                        class_1799 copy = item.getStack().method_7972();
                        class_1799 stack1 = inventory.method_5438(outputSlot);
                        if (stack1.method_7960() && (!copy.method_7985() || !class_1799.method_7975((class_1799)copy, (class_1799)inventory.method_5438(inputSlot))) || class_1799.method_7975((class_1799)copy, (class_1799)stack1) && class_1799.method_7987((class_1799)copy, (class_1799)stack1) && copy.method_7947() + stack1.method_7947() <= copy.method_7914()) {
                            copy.method_7939(copy.method_7947() + stack1.method_7947());
                            inventory.method_5447(outputSlot, copy);
                            inventory.method_5438(inputSlot).method_7939(originalCount - 1);
                        } else {
                            itemFluidHandler.extractFluid(item, fluidToTransfer, false);
                            tank.insertFluid(fluidToTransfer, false);
                        }
                        return true;
                    }
                }
            }
        }
        return false;
    }
}

