/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.unified.recipe;

import com.almostreliable.unified.api.recipe.RecipeContext;
import com.almostreliable.unified.utils.JsonUtils;
import com.almostreliable.unified.utils.ReplacementMap;
import com.almostreliable.unified.utils.UnifyTag;
import com.almostreliable.unified.utils.Utils;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.class_1792;
import net.minecraft.class_2960;

public class RecipeContextImpl
implements RecipeContext {
    private final ReplacementMap replacementMap;
    private final JsonObject originalRecipe;

    public RecipeContextImpl(JsonObject json, ReplacementMap replacementMap) {
        this.originalRecipe = json;
        this.replacementMap = replacementMap;
    }

    @Override
    @Nullable
    public class_2960 getReplacementForItem(@Nullable class_2960 item) {
        if (item == null) {
            return null;
        }
        return this.replacementMap.getReplacementForItem(item);
    }

    @Override
    @Nullable
    public class_2960 getPreferredItemForTag(@Nullable UnifyTag<class_1792> tag, Predicate<class_2960> filter) {
        if (tag == null) {
            return null;
        }
        return this.replacementMap.getPreferredItemForTag(tag, filter);
    }

    @Override
    @Nullable
    public UnifyTag<class_1792> getPreferredTagForItem(@Nullable class_2960 item) {
        if (item == null) {
            return null;
        }
        return this.replacementMap.getPreferredTagForItem(item);
    }

    @Override
    @Nullable
    public JsonElement createIngredientReplacement(@Nullable JsonElement element) {
        if (element == null) {
            return null;
        }
        JsonElement copy = element.deepCopy();
        this.tryCreateIngredientReplacement(copy);
        return element.equals(copy) ? null : copy;
    }

    private void tryCreateIngredientReplacement(@Nullable JsonElement element) {
        if (element instanceof JsonArray) {
            JsonArray array = (JsonArray)element;
            for (JsonElement e : array) {
                this.tryCreateIngredientReplacement(e);
            }
        }
        if (element instanceof JsonObject) {
            class_2960 item;
            UnifyTag<class_1792> tag;
            Object tag2;
            JsonPrimitive primitive;
            JsonElement e;
            JsonObject object = (JsonObject)element;
            this.tryCreateIngredientReplacement(object.get("value"));
            this.tryCreateIngredientReplacement(object.get("base"));
            this.tryCreateIngredientReplacement(object.get("ingredient"));
            e = object.get("tag");
            if (e instanceof JsonPrimitive) {
                primitive = (JsonPrimitive)e;
                tag2 = Utils.toItemTag(primitive.getAsString());
                UnifyTag<class_1792> ownerTag = this.replacementMap.getTagOwnerships().getOwnerByTag((UnifyTag<class_1792>)tag2);
                if (ownerTag != null) {
                    object.addProperty("tag", ownerTag.location().toString());
                }
            }
            if ((tag2 = object.get("item")) instanceof JsonPrimitive && (tag = this.getPreferredTagForItem(item = class_2960.method_12829((String)(primitive = (JsonPrimitive)tag2).getAsString()))) != null) {
                object.remove("item");
                object.addProperty("tag", tag.location().toString());
            }
        }
    }

    @Override
    @Nullable
    public JsonElement createResultReplacement(@Nullable JsonElement element) {
        return this.createResultReplacement(element, true, "item");
    }

    @Override
    @Nullable
    public JsonElement createResultReplacement(@Nullable JsonElement element, boolean tagLookup, String ... lookupKeys) {
        if (element == null) {
            return null;
        }
        JsonElement copy = element.deepCopy();
        JsonElement result = this.tryCreateResultReplacement(copy, tagLookup, lookupKeys);
        return element.equals(result) ? null : result;
    }

    @Nullable
    private JsonElement tryCreateResultReplacement(JsonElement element, boolean tagLookup, String ... lookupKeys) {
        JsonArray array;
        if (element instanceof JsonPrimitive) {
            JsonPrimitive primitive = (JsonPrimitive)element;
            class_2960 item = class_2960.method_12829((String)primitive.getAsString());
            class_2960 replacement = this.getReplacementForItem(item);
            if (replacement != null) {
                return new JsonPrimitive(replacement.toString());
            }
            return null;
        }
        if (element instanceof JsonArray && JsonUtils.replaceOn(array = (JsonArray)element, j -> this.tryCreateResultReplacement((JsonElement)j, tagLookup, lookupKeys))) {
            return element;
        }
        if (element instanceof JsonObject) {
            JsonElement replacement;
            JsonObject object = (JsonObject)element;
            for (String key : lookupKeys) {
                if (!JsonUtils.replaceOn(object, key, j -> this.tryCreateResultReplacement((JsonElement)j, tagLookup, lookupKeys))) continue;
                return element;
            }
            if (tagLookup && (replacement = object.get("tag")) instanceof JsonPrimitive) {
                JsonPrimitive primitive = (JsonPrimitive)replacement;
                class_2960 item = this.getPreferredItemForTag(Utils.toItemTag(primitive.getAsString()), $ -> true);
                if (item != null) {
                    object.remove("tag");
                    object.addProperty("item", item.toString());
                }
                return element;
            }
        }
        return null;
    }

    @Override
    public class_2960 getType() {
        String type = this.originalRecipe.get("type").getAsString();
        return new class_2960(type);
    }

    @Override
    public boolean hasProperty(String property) {
        return this.originalRecipe.has(property);
    }
}

