/*
 * Decompiled with CFR 0.152.
 */
package appeng.api.implementations.blockentities;

import appeng.api.implementations.blockentities.ICraftingMachine;
import appeng.api.inventories.InternalInventory;
import appeng.api.inventories.ItemTransfer;
import appeng.api.parts.IPart;
import appeng.api.parts.IPartHost;
import appeng.api.stacks.AEItemKey;
import appeng.core.localization.GuiText;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1275;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import org.jetbrains.annotations.Nullable;

public record PatternContainerGroup(@Nullable AEItemKey icon, class_2561 name, List<class_2561> tooltip) {
    private static final PatternContainerGroup NOTHING = new PatternContainerGroup(AEItemKey.of((class_1935)class_1802.field_8162), (class_2561)GuiText.Nothing.text(), List.of());

    public static PatternContainerGroup nothing() {
        return NOTHING;
    }

    public void writeToPacket(class_2540 buffer) {
        buffer.writeBoolean(this.icon != null);
        if (this.icon != null) {
            this.icon.writeToPacket(buffer);
        }
        buffer.method_10805(this.name);
        buffer.method_10804(this.tooltip.size());
        for (class_2561 component : this.tooltip) {
            buffer.method_10805(component);
        }
    }

    public static PatternContainerGroup readFromPacket(class_2540 buffer) {
        AEItemKey icon = buffer.readBoolean() ? AEItemKey.fromPacket(buffer) : null;
        class_2561 name = buffer.method_10808();
        int lineCount = buffer.method_10816();
        ArrayList<class_2561> lines = new ArrayList<class_2561>(lineCount);
        for (int i = 0; i < lineCount; ++i) {
            lines.add(buffer.method_10808());
        }
        return new PatternContainerGroup(icon, name, lines);
    }

    @Nullable
    public static PatternContainerGroup fromMachine(class_1937 level, class_2338 pos, class_2350 side) {
        class_2561 name;
        AEItemKey icon;
        PatternContainerGroup info;
        class_2586 target = level.method_8321(pos);
        ICraftingMachine craftingMachine = ICraftingMachine.of(level, pos, side, target);
        if (craftingMachine != null && (info = craftingMachine.getCraftingMachineInfo()) != null) {
            return info;
        }
        if (target == null) {
            return null;
        }
        ItemTransfer adaptor = InternalInventory.wrapExternal(target, side);
        if (adaptor == null || !adaptor.mayAllowInsertion()) {
            return null;
        }
        List<class_2561> tooltip = List.of();
        if (target instanceof IPartHost) {
            class_1275 nameable;
            IPartHost partHost = (IPartHost)target;
            IPart part = partHost.getPart(side);
            if (part == null) {
                return null;
            }
            icon = AEItemKey.of(part.getPartItem());
            name = part instanceof class_1275 && (nameable = (class_1275)part).method_16914() ? nameable.method_5797() : icon.getDisplayName();
        } else {
            class_1275 nameable;
            class_2248 targetBlock = target.method_11010().method_26204();
            class_1799 targetItem = new class_1799((class_1935)targetBlock);
            icon = AEItemKey.of(targetItem);
            if (target instanceof class_1275 && (nameable = (class_1275)target).method_16914()) {
                name = nameable.method_5797();
            } else {
                if (targetItem.method_7960()) {
                    return null;
                }
                name = targetItem.method_7964();
            }
        }
        return new PatternContainerGroup(icon, name, tooltip);
    }
}

