/*
 * Decompiled with CFR 0.152.
 */
package appeng.api.networking;

import appeng.api.exceptions.FailedConnectionException;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridConnection;
import appeng.api.networking.IGridNode;
import appeng.api.networking.IGridNodeListener;
import appeng.api.networking.IGridService;
import appeng.api.networking.IInWorldGridNodeHost;
import appeng.api.networking.IManagedGridNode;
import appeng.api.networking.events.GridEvent;
import appeng.hooks.ticking.TickHandler;
import appeng.me.GridConnection;
import appeng.me.GridEventBus;
import appeng.me.ManagedGridNode;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;

public final class GridHelper {
    private GridHelper() {
    }

    public static <T extends class_2586> void onFirstTick(T blockEntity, Consumer<? super T> callback) {
        TickHandler.instance().addInit(blockEntity, callback);
    }

    public static <T extends GridEvent> void addEventHandler(Class<T> eventClass, BiConsumer<IGrid, T> handler) {
        GridEventBus.subscribe(eventClass, handler);
    }

    public static <T extends GridEvent, C extends IGridService> void addGridServiceEventHandler(Class<T> eventClass, Class<C> cacheClass, BiConsumer<C, T> eventHandler) {
        GridHelper.addEventHandler(eventClass, (grid, event) -> eventHandler.accept(grid.getService(cacheClass), event));
    }

    public static <T extends GridEvent, C> void addNodeOwnerEventHandler(Class<T> eventClass, Class<C> nodeOwnerClass, BiConsumer<C, T> eventHandler) {
        GridHelper.addEventHandler(eventClass, (grid, event) -> {
            for (Object machine : grid.getMachines(nodeOwnerClass)) {
                eventHandler.accept(machine, event);
            }
        });
    }

    public static <T extends GridEvent, C> void addNodeOwnerEventHandler(Class<T> eventClass, Class<C> nodeOwnerClass, Consumer<C> eventHandler) {
        GridHelper.addEventHandler(eventClass, (grid, event) -> {
            for (Object machine : grid.getMachines(nodeOwnerClass)) {
                eventHandler.accept(machine);
            }
        });
    }

    @Nullable
    public static IInWorldGridNodeHost getNodeHost(class_1937 level, class_2338 pos) {
        class_2586 be = level.method_8321(pos);
        if (be instanceof IInWorldGridNodeHost) {
            IInWorldGridNodeHost host = (IInWorldGridNodeHost)be;
            return host;
        }
        return (IInWorldGridNodeHost)IInWorldGridNodeHost.LOOKUP.find(level, pos, null, be, null);
    }

    @Nullable
    public static IGridNode getExposedNode(class_1937 level, class_2338 pos, class_2350 side) {
        IInWorldGridNodeHost host = GridHelper.getNodeHost(level, pos);
        if (host == null) {
            return null;
        }
        IGridNode node = host.getGridNode(side);
        if (node == null || !node.isExposedOnSide(side)) {
            return null;
        }
        return node;
    }

    public static <T> IManagedGridNode createManagedNode(T owner, IGridNodeListener<T> listener) {
        return new ManagedGridNode(owner, listener);
    }

    public static IGridConnection createGridConnection(IGridNode a, IGridNode b) throws FailedConnectionException {
        Objects.requireNonNull(a);
        Objects.requireNonNull(b);
        return GridConnection.create(a, b, null);
    }
}

