/*
 * Decompiled with CFR 0.152.
 */
package appeng.api.stacks;

import appeng.api.stacks.AEKey;
import appeng.api.stacks.AEKeyType;
import appeng.api.stacks.GenericStack;
import appeng.api.storage.AEKeyFilter;
import appeng.core.AELog;
import appeng.util.Platform;
import java.util.List;
import java.util.Objects;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3611;
import net.minecraft.class_6862;
import org.jetbrains.annotations.Nullable;

public final class AEFluidKey
extends AEKey {
    public static final int AMOUNT_BUCKET = 81000;
    public static final int AMOUNT_BLOCK = 81000;
    private final class_3611 fluid;
    @Nullable
    private final class_2487 tag;
    private final int hashCode;

    private AEFluidKey(class_3611 fluid, @Nullable class_2487 tag) {
        this.fluid = fluid;
        this.tag = tag;
        this.hashCode = Objects.hash(fluid, tag);
    }

    public static AEFluidKey of(class_3611 fluid, @Nullable class_2487 tag) {
        return new AEFluidKey(fluid, tag != null ? tag.method_10553() : null);
    }

    public static AEFluidKey of(class_3611 fluid) {
        return AEFluidKey.of(fluid, null);
    }

    @Nullable
    public static AEFluidKey of(FluidVariant fluidVariant) {
        if (fluidVariant.isBlank()) {
            return null;
        }
        return AEFluidKey.of(fluidVariant.getFluid(), fluidVariant.getNbt());
    }

    public static boolean matches(AEKey what, FluidVariant fluid) {
        AEFluidKey fluidKey;
        return what instanceof AEFluidKey && (fluidKey = (AEFluidKey)what).matches(fluid);
    }

    public static boolean is(AEKey what) {
        return what instanceof AEFluidKey;
    }

    public static AEKeyFilter filter() {
        return AEFluidKey::is;
    }

    public boolean matches(FluidVariant variant) {
        return !variant.isBlank() && this.fluid.method_15780(variant.getFluid()) && variant.nbtMatches(this.tag);
    }

    @Override
    public AEKeyType getType() {
        return AEKeyType.fluids();
    }

    @Override
    public AEFluidKey dropSecondary() {
        return AEFluidKey.of(this.fluid, null);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AEFluidKey aeFluidKey = (AEFluidKey)o;
        return this.hashCode == aeFluidKey.hashCode && this.fluid == aeFluidKey.fluid && Objects.equals(this.tag, aeFluidKey.tag);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public static AEFluidKey fromTag(class_2487 tag) {
        try {
            class_3611 fluid = (class_3611)class_2378.field_11154.method_17966(new class_2960(tag.method_10558("id"))).orElseThrow(() -> new IllegalArgumentException("Unknown fluid id."));
            class_2487 extraTag = tag.method_10545("tag") ? tag.method_10562("tag") : null;
            return AEFluidKey.of(fluid, extraTag);
        }
        catch (Exception e) {
            AELog.debug("Tried to load an invalid fluid key from NBT: %s", tag, e);
            return null;
        }
    }

    @Override
    public class_2487 toTag() {
        class_2487 result = new class_2487();
        result.method_10582("id", class_2378.field_11154.method_10221((Object)this.fluid).toString());
        if (this.tag != null) {
            result.method_10566("tag", (class_2520)this.tag.method_10553());
        }
        return result;
    }

    @Override
    public Object getPrimaryKey() {
        return this.fluid;
    }

    @Override
    public class_2960 getId() {
        return class_2378.field_11154.method_10221((Object)this.fluid);
    }

    @Override
    public void addDrops(long amount, List<class_1799> drops, class_1937 level, class_2338 pos) {
    }

    @Override
    protected class_2561 computeDisplayName() {
        return Platform.getFluidDisplayName(this.fluid, this.tag);
    }

    @Override
    public boolean isTagged(class_6862<?> tag) {
        return this.fluid.method_40178().method_40220(tag);
    }

    public FluidVariant toVariant() {
        return FluidVariant.of((class_3611)this.fluid, (class_2487)this.tag);
    }

    public class_3611 getFluid() {
        return this.fluid;
    }

    @Nullable
    public class_2487 getTag() {
        return this.tag;
    }

    @Nullable
    public class_2487 copyTag() {
        return this.tag != null ? this.tag.method_10553() : null;
    }

    public boolean hasTag() {
        return this.tag != null;
    }

    @Override
    public void writeToPacket(class_2540 data) {
        data.method_10804(class_2378.field_11154.method_10206((Object)this.fluid));
        data.method_10794(this.tag);
    }

    public static AEFluidKey fromPacket(class_2540 data) {
        class_3611 fluid = (class_3611)class_2378.field_11154.method_10200(data.method_10816());
        class_2487 tag = data.method_10798();
        return new AEFluidKey(fluid, tag);
    }

    public static boolean is(@Nullable GenericStack stack) {
        return stack != null && stack.what() instanceof AEFluidKey;
    }

    public String toString() {
        class_2960 id = class_2378.field_11154.method_10221((Object)this.fluid);
        String idString = id != class_2378.field_11154.method_10137() ? id.toString() : this.fluid.getClass().getName() + "(unregistered)";
        return this.tag == null ? idString : idString + " (+tag)";
    }
}

