/*
 * Decompiled with CFR 0.152.
 */
package appeng.block.networking;

import appeng.api.parts.IFacadeContainer;
import appeng.api.parts.IFacadePart;
import appeng.api.parts.SelectedPart;
import appeng.api.util.AEColor;
import appeng.block.AEBaseEntityBlock;
import appeng.blockentity.networking.CableBusBlockEntity;
import appeng.client.render.cablebus.CableBusBakedModel;
import appeng.client.render.cablebus.CableBusBreakingParticle;
import appeng.client.render.cablebus.CableBusRenderState;
import appeng.client.render.cablebus.FacadeRenderState;
import appeng.helpers.AEMaterials;
import appeng.hooks.ICustomBlockDestroyEffect;
import appeng.hooks.ICustomBlockHitEffect;
import appeng.hooks.ICustomPickBlock;
import appeng.hooks.IDynamicLadder;
import appeng.hooks.INeighborChangeSensitive;
import appeng.integration.abstraction.IAEFacade;
import appeng.parts.CableBusContainer;
import appeng.parts.ICableBusContainer;
import appeng.parts.NullCableBusContainer;
import appeng.util.Platform;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import javax.annotation.Nullable;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.rendering.data.v1.RenderAttachedBlockView;
import net.minecraft.class_1058;
import net.minecraft.class_1087;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1761;
import net.minecraft.class_1767;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_1920;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_310;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3726;
import net.minecraft.class_3737;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_47;
import net.minecraft.class_5819;
import net.minecraft.class_638;
import net.minecraft.class_702;
import net.minecraft.class_703;

public class CableBusBlock
extends AEBaseEntityBlock<CableBusBlockEntity>
implements IAEFacade,
class_3737,
ICustomBlockHitEffect,
ICustomBlockDestroyEffect,
INeighborChangeSensitive,
IDynamicLadder,
ICustomPickBlock {
    private static final ICableBusContainer NULL_CABLE_BUS = new NullCableBusContainer();
    private static final class_2758 LIGHT_LEVEL = class_2758.method_11867((String)"light_level", (int)0, (int)15);
    private static final class_2746 WATERLOGGED = class_2741.field_12508;
    public static ThreadLocal<class_2350> RENDERING_FACADE_DIRECTION = new ThreadLocal();

    public CableBusBlock() {
        super(CableBusBlock.defaultProps(AEMaterials.GLASS).method_22488().method_42327().method_9624().method_9631(state -> (Integer)state.method_11654((class_2769)LIGHT_LEVEL)));
        this.method_9590((class_2680)((class_2680)this.method_9564().method_11657((class_2769)LIGHT_LEVEL, (Comparable)Integer.valueOf(0))).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public boolean method_9579(class_2680 state, class_1922 reader, class_2338 pos) {
        return true;
    }

    @Override
    public List<class_1799> method_9560(class_2680 state, class_47.class_48 builder) {
        Object object = builder.method_305(class_181.field_1228);
        if (object instanceof CableBusBlockEntity) {
            CableBusBlockEntity bus = (CableBusBlockEntity)object;
            ArrayList<class_1799> drops = new ArrayList<class_1799>();
            bus.getCableBus().addPartDrops(drops);
            return drops;
        }
        return List.of();
    }

    public void method_9496(class_2680 state, class_1937 level, class_2338 pos, class_5819 rand) {
        this.cb((class_1922)level, pos).animateTick(level, pos, rand);
    }

    @Override
    public void onNeighborChange(class_2680 state, class_4538 level, class_2338 pos, class_2338 neighbor) {
        this.cb((class_1922)level, pos).onNeighborChanged((class_1922)level, pos, neighbor);
    }

    public int method_9524(class_2680 state, class_1922 level, class_2338 pos, class_2350 side) {
        return this.cb(level, pos).isProvidingWeakPower(side.method_10153());
    }

    public boolean method_9506(class_2680 state) {
        return true;
    }

    public void method_9548(class_2680 state, class_1937 level, class_2338 pos, class_1297 entityIn) {
        this.cb((class_1922)level, pos).onEntityCollision(entityIn);
    }

    public int method_9603(class_2680 state, class_1922 level, class_2338 pos, class_2350 side) {
        return this.cb(level, pos).isProvidingStrongPower(side.method_10153());
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(new class_2769[]{LIGHT_LEVEL, WATERLOGGED});
    }

    @Override
    public boolean isLadder(class_2680 state, class_4538 level, class_2338 pos, class_1309 entity) {
        return this.cb((class_1922)level, pos).isLadder(entity);
    }

    public boolean method_9616(class_2680 state, class_1750 useContext) {
        return super.method_9616(state, useContext) && this.cb((class_1922)useContext.method_8045(), useContext.method_8037()).isEmpty();
    }

    public boolean canConnectRedstone(class_1922 level, class_2338 pos, class_2350 side) {
        if (side == null) {
            return false;
        }
        return this.cb(level, pos).canConnectRedstone(side.method_10153());
    }

    @Override
    public class_1799 getPickBlock(class_2680 state, class_239 target, class_1922 level, class_2338 pos, class_1657 player) {
        class_243 v3 = target.method_17784().method_1023((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260());
        SelectedPart sp = this.cb(level, pos).selectPartLocal(v3);
        if (sp.part != null) {
            return new class_1799(sp.part.getPartItem());
        }
        if (sp.facade != null) {
            return sp.facade.getItemStack();
        }
        return class_1799.field_8037;
    }

    public void method_9612(class_2680 state, class_1937 level, class_2338 pos, class_2248 blockIn, class_2338 fromPos, boolean isMoving) {
        if (!level.method_8608()) {
            this.cb((class_1922)level, pos).onNeighborChanged((class_1922)level, pos, fromPos);
        }
    }

    private ICableBusContainer cb(class_1922 level, class_2338 pos) {
        class_2586 te = level.method_8321(pos);
        CableBusContainer out = null;
        if (te instanceof CableBusBlockEntity) {
            out = ((CableBusBlockEntity)te).getCableBus();
        }
        return out == null ? NULL_CABLE_BUS : out;
    }

    @Nullable
    private IFacadeContainer fc(class_1922 level, class_2338 pos) {
        class_2586 te = level.method_8321(pos);
        IFacadeContainer out = null;
        if (te instanceof CableBusBlockEntity) {
            out = ((CableBusBlockEntity)te).getCableBus().getFacadeContainer();
        }
        return out;
    }

    @Override
    public class_1269 onActivated(class_1937 level, class_2338 pos, class_1657 player, class_1268 hand, @Nullable class_1799 heldItem, class_3965 hit) {
        class_243 hitVec = hit.method_17784();
        class_243 hitInBlock = new class_243(hitVec.field_1352 - (double)pos.method_10263(), hitVec.field_1351 - (double)pos.method_10264(), hitVec.field_1350 - (double)pos.method_10260());
        return this.cb((class_1922)level, pos).activate(player, hand, hitInBlock) ? class_1269.method_29236((boolean)level.method_8608()) : class_1269.field_5811;
    }

    public boolean recolorBlock(class_1922 level, class_2338 pos, class_2350 side, class_1767 color, class_1657 who) {
        try {
            return this.cb(level, pos).recolourBlock(side, AEColor.values()[color.ordinal()], who);
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    @Environment(value=EnvType.CLIENT)
    public void method_9578(class_1761 group, class_2371<class_1799> itemStacks) {
    }

    @Override
    public class_2680 getFacadeState(class_1922 level, class_2338 pos, class_2350 side) {
        IFacadePart facade;
        IFacadeContainer container;
        if (side != null && (container = this.fc(level, pos)) != null && (facade = container.getFacade(side)) != null) {
            return facade.getBlockState();
        }
        return level.method_8320(pos);
    }

    public class_265 method_9530(class_2680 state, class_1922 level, class_2338 pos, class_3726 context) {
        CableBusBlockEntity te = (CableBusBlockEntity)this.getBlockEntity(level, pos);
        if (te == null) {
            return class_259.method_1073();
        }
        return te.getCableBus().getShape();
    }

    public class_265 method_9549(class_2680 state, class_1922 level, class_2338 pos, class_3726 context) {
        CableBusBlockEntity te = (CableBusBlockEntity)this.getBlockEntity(level, pos);
        if (te == null) {
            return class_259.method_1073();
        }
        return te.getCableBus().getCollisionShape(context);
    }

    @Override
    protected class_2680 updateBlockStateFromBlockEntity(class_2680 currentState, CableBusBlockEntity be) {
        if (currentState.method_26204() != this) {
            return currentState;
        }
        int lightLevel = be.getCableBus().getLightValue();
        return (class_2680)super.updateBlockStateFromBlockEntity(currentState, be).method_11657((class_2769)LIGHT_LEVEL, (Comparable)Integer.valueOf(lightLevel));
    }

    @Nullable
    public class_2680 method_9605(class_1750 context) {
        return this.getStateForPlacement(context.method_8045(), context.method_8037());
    }

    public class_2680 getStateForPlacement(class_1937 level, class_2338 pos) {
        class_3610 fluidState = level.method_8316(pos);
        return (class_2680)this.method_9564().method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.method_15772() == class_3612.field_15910));
    }

    public class_3610 method_9545(class_2680 blockState) {
        return (Boolean)blockState.method_11654((class_2769)WATERLOGGED) != false ? class_3612.field_15910.method_15729(false) : super.method_9545(blockState);
    }

    public class_2680 method_9559(class_2680 blockState, class_2350 facing, class_2680 facingState, class_1936 level, class_2338 currentPos, class_2338 facingPos) {
        if (((Boolean)blockState.method_11654((class_2769)WATERLOGGED)).booleanValue()) {
            level.method_39281(currentPos, (class_3611)class_3612.field_15910, class_3612.field_15910.method_15789((class_4538)level));
        }
        return super.method_9559(blockState, facing, facingState, level, currentPos, facingPos);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public boolean addHitEffects(class_2680 state, class_1937 level, class_239 target, class_702 effectRenderer) {
        if (Platform.getRandom().method_43056()) {
            return true;
        }
        if (target.method_17783() != class_239.class_240.field_1332) {
            return false;
        }
        class_2338 blockPos = new class_2338(target.method_17784().field_1352, target.method_17784().field_1351, target.method_17784().field_1350);
        ICableBusContainer cb = this.cb((class_1922)level, blockPos);
        class_1087 model = class_310.method_1551().method_1541().method_3349(this.method_9564());
        if (!(model instanceof CableBusBakedModel)) {
            return true;
        }
        CableBusBakedModel cableBusModel = (CableBusBakedModel)model;
        CableBusRenderState renderState = cb.getRenderState();
        class_1058 texture = Platform.pickRandom(cableBusModel.getParticleTextures(renderState));
        if (texture != null) {
            double x = target.method_17784().field_1352;
            double y = target.method_17784().field_1351;
            double z = target.method_17784().field_1350;
            effectRenderer.method_3058(new CableBusBreakingParticle((class_638)level, x, y, z, texture).method_3087(0.8f));
        }
        return true;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public boolean addDestroyEffects(class_2680 state, class_1937 level, class_2338 pos, class_702 effectRenderer) {
        ICableBusContainer cb = this.cb((class_1922)level, pos);
        class_1087 model = class_310.method_1551().method_1541().method_3349(this.method_9564());
        if (!(model instanceof CableBusBakedModel)) {
            return true;
        }
        CableBusBakedModel cableBusModel = (CableBusBakedModel)model;
        CableBusRenderState renderState = cb.getRenderState();
        List<class_1058> textures = cableBusModel.getParticleTextures(renderState);
        if (!textures.isEmpty()) {
            for (int j = 0; j < 4; ++j) {
                for (int k = 0; k < 4; ++k) {
                    for (int l = 0; l < 4; ++l) {
                        class_1058 texture = Platform.pickRandom(textures);
                        double x = (double)pos.method_10263() + ((double)j + 0.5) / 4.0;
                        double y = (double)pos.method_10264() + ((double)k + 0.5) / 4.0;
                        double z = (double)pos.method_10260() + ((double)l + 0.5) / 4.0;
                        CableBusBreakingParticle effect = new CableBusBreakingParticle((class_638)level, x, y, z, x - (double)pos.method_10263() - 0.5, y - (double)pos.method_10264() - 0.5, z - (double)pos.method_10260() - 0.5, texture);
                        effectRenderer.method_3058((class_703)effect);
                    }
                }
            }
        }
        return true;
    }

    public class_2680 getAppearance(class_2680 state, class_1920 renderView, class_2338 pos, class_2350 side, @Nullable class_2680 sourceState, @Nullable class_2338 sourcePos) {
        Object object = ((RenderAttachedBlockView)renderView).getBlockEntityRenderAttachment(pos);
        if (object instanceof CableBusRenderState) {
            FacadeRenderState facadeState;
            CableBusRenderState cableBusRenderState = (CableBusRenderState)object;
            class_2350 renderingFacadeDir = RENDERING_FACADE_DIRECTION.get();
            EnumMap<class_2350, FacadeRenderState> facades = cableBusRenderState.getFacades();
            if (side.method_10153() != renderingFacadeDir && (facadeState = facades.get(side)) != null) {
                return facadeState.getSourceBlock();
            }
            if (renderingFacadeDir != null && facades.containsKey(renderingFacadeDir)) {
                return facades.get(renderingFacadeDir).getSourceBlock();
            }
        }
        return state;
    }
}

