/*
 * Decompiled with CFR 0.152.
 */
package appeng.block.networking;

import appeng.block.AEBaseEntityBlock;
import appeng.blockentity.networking.ControllerBlockEntity;
import appeng.core.definitions.AEBlocks;
import appeng.menu.MenuOpener;
import appeng.menu.locator.MenuLocators;
import appeng.menu.me.networktool.NetworkStatusMenu;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_3542;
import net.minecraft.class_3614;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import org.jetbrains.annotations.Nullable;

public class ControllerBlock
extends AEBaseEntityBlock<ControllerBlockEntity> {
    public static final class_2754<ControllerBlockState> CONTROLLER_STATE = class_2754.method_11850((String)"state", ControllerBlockState.class);
    public static final class_2754<ControllerRenderType> CONTROLLER_TYPE = class_2754.method_11850((String)"type", ControllerRenderType.class);

    public ControllerBlock() {
        super((class_4970.class_2251)ControllerBlock.defaultProps(class_3614.field_15953).strength(6.0f));
        this.method_9590((class_2680)((class_2680)this.method_9564().method_11657(CONTROLLER_STATE, (Comparable)((Object)ControllerBlockState.offline))).method_11657(CONTROLLER_TYPE, (Comparable)((Object)ControllerRenderType.block)));
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(new class_2769[]{CONTROLLER_STATE});
        builder.method_11667(new class_2769[]{CONTROLLER_TYPE});
    }

    @javax.annotation.Nullable
    public class_2680 method_9605(class_1750 context) {
        return this.getControllerType(this.method_9564(), (class_1936)context.method_8045(), context.method_8037());
    }

    public class_2680 method_9559(class_2680 state, class_2350 facing, class_2680 facingState, class_1936 level, class_2338 pos, class_2338 facingPos) {
        return this.getControllerType(state, level, pos);
    }

    private class_2680 getControllerType(class_2680 baseState, class_1936 level, class_2338 pos) {
        boolean zz;
        int z;
        int y;
        ControllerRenderType type = ControllerRenderType.block;
        int x = pos.method_10263();
        boolean xx = ControllerBlock.isController(level, x - 1, y = pos.method_10264(), z = pos.method_10260()) && ControllerBlock.isController(level, x + 1, y, z);
        boolean yy = ControllerBlock.isController(level, x, y - 1, z) && ControllerBlock.isController(level, x, y + 1, z);
        boolean bl = zz = ControllerBlock.isController(level, x, y, z - 1) && ControllerBlock.isController(level, x, y, z + 1);
        if (xx && !yy && !zz) {
            type = ControllerRenderType.column_x;
        } else if (!xx && yy && !zz) {
            type = ControllerRenderType.column_y;
        } else if (!xx && !yy && zz) {
            type = ControllerRenderType.column_z;
        } else if ((xx ? 1 : 0) + (yy ? 1 : 0) + (zz ? 1 : 0) >= 2) {
            int v = (Math.abs(x) + Math.abs(y) + Math.abs(z)) % 2;
            type = v == 0 ? ControllerRenderType.inside_a : ControllerRenderType.inside_b;
        }
        return (class_2680)baseState.method_11657(CONTROLLER_TYPE, (Comparable)((Object)type));
    }

    private static boolean isController(class_1936 level, int x, int y, int z) {
        return level.method_8320(new class_2338(x, y, z)).method_27852((class_2248)AEBlocks.CONTROLLER.block());
    }

    @Override
    public class_1269 onActivated(class_1937 level, class_2338 pos, class_1657 player, class_1268 hand, @Nullable class_1799 heldItem, class_3965 hit) {
        ControllerBlockEntity controller = (ControllerBlockEntity)this.getBlockEntity((class_1922)level, pos);
        if (controller != null) {
            if (!level.field_9236) {
                MenuOpener.open(NetworkStatusMenu.CONTROLLER_TYPE, player, MenuLocators.forBlockEntity(controller));
            }
            return class_1269.method_29236((boolean)level.field_9236);
        }
        return class_1269.field_5814;
    }

    public static enum ControllerBlockState implements class_3542
    {
        offline,
        online,
        conflicted;


        public String method_15434() {
            return this.name();
        }
    }

    public static enum ControllerRenderType implements class_3542
    {
        block,
        column_x,
        column_y,
        column_z,
        inside_a,
        inside_b;


        public String method_15434() {
            return this.name();
        }
    }
}

