/*
 * Decompiled with CFR 0.152.
 */
package appeng.blockentity.qnb;

import appeng.api.inventories.InternalInventory;
import appeng.api.networking.GridFlags;
import appeng.api.networking.IGridNode;
import appeng.api.networking.IGridNodeListener;
import appeng.api.util.AECableType;
import appeng.block.qnb.QnbFormedState;
import appeng.block.qnb.QuantumRingBlock;
import appeng.blockentity.ServerTickingBlockEntity;
import appeng.blockentity.grid.AENetworkInvBlockEntity;
import appeng.core.definitions.AEBlocks;
import appeng.core.definitions.BlockDefinition;
import appeng.me.cluster.IAEMultiBlock;
import appeng.me.cluster.implementations.QuantumCalculator;
import appeng.me.cluster.implementations.QuantumCluster;
import appeng.util.inv.AppEngInternalInventory;
import java.util.EnumSet;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3218;

public class QuantumBridgeBlockEntity
extends AENetworkInvBlockEntity
implements IAEMultiBlock<QuantumCluster>,
ServerTickingBlockEntity {
    private final byte corner = (byte)16;
    private final AppEngInternalInventory internalInventory = new AppEngInternalInventory(this, 1, 1);
    private final byte hasSingularity = (byte)32;
    private final byte powered = (byte)64;
    private final QuantumCalculator calc = new QuantumCalculator(this);
    private byte constructed = (byte)-1;
    private QuantumCluster cluster;
    private boolean updateStatus = false;

    public QuantumBridgeBlockEntity(class_2591<?> blockEntityType, class_2338 pos, class_2680 blockState) {
        super(blockEntityType, pos, blockState);
        this.getMainNode().setExposedOnSides(EnumSet.noneOf(class_2350.class));
        this.getMainNode().setFlags(GridFlags.DENSE_CAPACITY);
        this.getMainNode().setIdlePowerUsage(22.0);
    }

    @Override
    public void serverTick() {
        if (this.updateStatus) {
            this.updateStatus = false;
            if (this.cluster != null) {
                this.cluster.updateStatus(true);
            }
            this.markForUpdate();
        }
    }

    @Override
    protected void writeToStream(class_2540 data) {
        super.writeToStream(data);
        int out = this.constructed;
        if (!this.internalInventory.getStackInSlot(0).method_7960() && this.constructed != -1) {
            out |= this.hasSingularity;
        }
        if (this.getMainNode().isActive() && this.constructed != -1) {
            out |= this.powered;
        }
        data.writeByte((int)((byte)out));
    }

    @Override
    protected boolean readFromStream(class_2540 data) {
        boolean c = super.readFromStream(data);
        byte oldValue = this.constructed;
        this.constructed = data.readByte();
        return this.constructed != oldValue || c;
    }

    @Override
    public InternalInventory getInternalInventory() {
        return this.internalInventory;
    }

    @Override
    public void onChangeInventory(InternalInventory inv, int slot) {
        if (this.cluster != null) {
            this.cluster.updateStatus(true);
        }
    }

    @Override
    public InternalInventory getExposedInventoryForSide(class_2350 side) {
        if (this.isCenter()) {
            return this.internalInventory;
        }
        return InternalInventory.empty();
    }

    private boolean isCenter() {
        return this.method_11010().method_27852((class_2248)AEBlocks.QUANTUM_LINK.block());
    }

    @Override
    public void onMainNodeStateChanged(IGridNodeListener.State reason) {
        this.updateStatus = true;
    }

    @Override
    public void onChunkUnloaded() {
        this.disconnect(false);
        super.onChunkUnloaded();
    }

    @Override
    public void onReady() {
        super.onReady();
        BlockDefinition<QuantumRingBlock> quantumRing = AEBlocks.QUANTUM_RING;
        if (this.method_11010().method_26204() == quantumRing.block()) {
            this.getMainNode().setVisualRepresentation(quantumRing.stack());
        }
        this.updateStatus = true;
    }

    @Override
    public void method_11012() {
        this.disconnect(false);
        super.method_11012();
    }

    @Override
    public void disconnect(boolean affectWorld) {
        if (this.cluster != null) {
            if (!affectWorld) {
                this.cluster.setUpdateStatus(false);
            }
            this.cluster.destroy();
        }
        this.cluster = null;
        if (affectWorld) {
            this.getMainNode().setExposedOnSides(EnumSet.noneOf(class_2350.class));
        }
    }

    @Override
    public QuantumCluster getCluster() {
        return this.cluster;
    }

    @Override
    public boolean isValid() {
        return !this.method_11015();
    }

    public void updateStatus(QuantumCluster c, byte flags, boolean affectWorld) {
        this.cluster = c;
        if (affectWorld) {
            if (this.constructed != flags) {
                this.constructed = flags;
                this.markForUpdate();
            }
            if (this.isCorner() || this.isCenter()) {
                EnumSet<class_2350> sides = EnumSet.copyOf(this.getAdjacentQuantumBridges());
                this.getMainNode().setExposedOnSides(sides);
            } else {
                this.getMainNode().setExposedOnSides(EnumSet.allOf(class_2350.class));
            }
        }
    }

    public boolean isCorner() {
        return (this.constructed & this.getCorner()) == this.getCorner() && this.constructed != -1;
    }

    public EnumSet<class_2350> getAdjacentQuantumBridges() {
        EnumSet<class_2350> set = EnumSet.noneOf(class_2350.class);
        for (class_2350 d : class_2350.values()) {
            class_2586 te = this.field_11863.method_8321(this.field_11867.method_10093(d));
            if (!(te instanceof QuantumBridgeBlockEntity)) continue;
            set.add(d);
        }
        return set;
    }

    public long getQEFrequency() {
        class_2487 c;
        class_1799 is = this.internalInventory.getStackInSlot(0);
        if (!is.method_7960() && (c = is.method_7969()) != null) {
            return c.method_10537("freq");
        }
        return 0L;
    }

    public boolean isPowered() {
        if (this.isClientSide()) {
            return (this.constructed & this.powered) == this.powered && this.constructed != -1;
        }
        IGridNode node = this.getMainNode().getNode();
        return node != null && node.isPowered();
    }

    public boolean isFormed() {
        return this.constructed != -1;
    }

    @Override
    public AECableType getCableConnectionType(class_2350 dir) {
        return AECableType.DENSE_SMART;
    }

    public void neighborUpdate(class_2338 fromPos) {
        class_1937 class_19372 = this.field_11863;
        if (class_19372 instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            this.calc.updateMultiblockAfterNeighborUpdate(serverLevel, this.field_11867, fromPos);
        }
    }

    public boolean hasQES() {
        if (this.constructed == -1) {
            return false;
        }
        return (this.constructed & this.hasSingularity) == this.hasSingularity;
    }

    public void breakClusterOnRemove() {
        if (this.cluster != null) {
            this.field_11865 = true;
            this.cluster.destroy();
        }
    }

    public byte getCorner() {
        return this.corner;
    }

    @Override
    public QnbFormedState getRenderAttachmentData() {
        return new QnbFormedState(this.getAdjacentQuantumBridges(), this.isCorner(), this.isPowered());
    }
}

