/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.gui.implementations;

import appeng.api.config.AccessRestriction;
import appeng.api.config.ActionItems;
import appeng.api.config.FuzzyMode;
import appeng.api.config.Settings;
import appeng.api.config.StorageFilter;
import appeng.api.config.YesNo;
import appeng.client.gui.implementations.UpgradeableScreen;
import appeng.client.gui.style.Color;
import appeng.client.gui.style.PaletteColor;
import appeng.client.gui.style.ScreenStyle;
import appeng.client.gui.widgets.ActionButton;
import appeng.client.gui.widgets.ServerSettingToggleButton;
import appeng.client.gui.widgets.SettingToggleButton;
import appeng.core.localization.GuiText;
import appeng.menu.implementations.StorageBusMenu;
import net.minecraft.class_1661;
import net.minecraft.class_2561;
import net.minecraft.class_4587;

public class StorageBusScreen
extends UpgradeableScreen<StorageBusMenu> {
    private final SettingToggleButton<AccessRestriction> rwMode;
    private final SettingToggleButton<StorageFilter> storageFilter;
    private final SettingToggleButton<YesNo> filterOnExtract;
    private final SettingToggleButton<FuzzyMode> fuzzyMode;

    public StorageBusScreen(StorageBusMenu menu, class_1661 playerInventory, class_2561 title, ScreenStyle style) {
        super(menu, playerInventory, title, style);
        this.widgets.addOpenPriorityButton();
        this.addToLeftToolbar(new ActionButton(ActionItems.CLOSE, btn -> menu.clear()));
        this.addToLeftToolbar(new ActionButton(ActionItems.WRENCH, btn -> menu.partition()));
        this.rwMode = new ServerSettingToggleButton<AccessRestriction>(Settings.ACCESS, AccessRestriction.READ_WRITE);
        this.storageFilter = new ServerSettingToggleButton<StorageFilter>(Settings.STORAGE_FILTER, StorageFilter.EXTRACTABLE_ONLY);
        this.filterOnExtract = new ServerSettingToggleButton<YesNo>(Settings.FILTER_ON_EXTRACT, YesNo.YES);
        this.fuzzyMode = new ServerSettingToggleButton<FuzzyMode>(Settings.FUZZY_MODE, FuzzyMode.IGNORE_ALL);
        this.addToLeftToolbar(this.storageFilter);
        this.addToLeftToolbar(this.filterOnExtract);
        this.addToLeftToolbar(this.fuzzyMode);
        this.addToLeftToolbar(this.rwMode);
    }

    @Override
    protected void updateBeforeRender() {
        super.updateBeforeRender();
        this.storageFilter.set(((StorageBusMenu)this.field_2797).getStorageFilter());
        this.rwMode.set(((StorageBusMenu)this.field_2797).getReadWriteMode());
        this.filterOnExtract.set(((StorageBusMenu)this.field_2797).getFilterOnExtract());
        this.fuzzyMode.set(((StorageBusMenu)this.field_2797).getFuzzyMode());
        this.fuzzyMode.setVisibility(((StorageBusMenu)this.field_2797).supportsFuzzySearch());
    }

    @Override
    public void drawFG(class_4587 poseStack, int offsetX, int offsetY, int mouseX, int mouseY) {
        super.drawFG(poseStack, offsetX, offsetY, mouseX, mouseY);
        poseStack.method_22903();
        poseStack.method_22904(10.0, 17.0, 0.0);
        poseStack.method_22905(0.6f, 0.6f, 1.0f);
        Color color = this.style.getColor(PaletteColor.DEFAULT_TEXT_COLOR);
        if (((StorageBusMenu)this.field_2797).getConnectedTo() != null) {
            this.field_22793.method_30883(poseStack, (class_2561)GuiText.AttachedTo.text(((StorageBusMenu)this.field_2797).getConnectedTo()), 0.0f, 0.0f, color.toARGB());
        } else {
            this.field_22793.method_30883(poseStack, (class_2561)GuiText.Unattached.text(), 0.0f, 0.0f, color.toARGB());
        }
        poseStack.method_22909();
    }
}

