/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.gui.me.common;

import appeng.api.client.AEStackRendering;
import appeng.api.config.ActionItems;
import appeng.api.config.Setting;
import appeng.api.config.Settings;
import appeng.api.config.SortDir;
import appeng.api.config.SortOrder;
import appeng.api.config.TerminalStyle;
import appeng.api.config.TypeFilter;
import appeng.api.config.ViewItems;
import appeng.api.implementations.blockentities.IMEChest;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.AmountFormat;
import appeng.api.storage.AEKeyFilter;
import appeng.api.util.IConfigManager;
import appeng.api.util.IConfigurableObject;
import appeng.client.Point;
import appeng.client.gui.AEBaseScreen;
import appeng.client.gui.AESubScreen;
import appeng.client.gui.Icon;
import appeng.client.gui.me.common.PendingCraftingJobs;
import appeng.client.gui.me.common.PinnedKeys;
import appeng.client.gui.me.common.Repo;
import appeng.client.gui.me.common.RepoSlot;
import appeng.client.gui.me.common.StackSizeRenderer;
import appeng.client.gui.me.common.TerminalSettingsScreen;
import appeng.client.gui.style.Blitter;
import appeng.client.gui.style.ScreenStyle;
import appeng.client.gui.widgets.AETextField;
import appeng.client.gui.widgets.ActionButton;
import appeng.client.gui.widgets.ISortSource;
import appeng.client.gui.widgets.Scrollbar;
import appeng.client.gui.widgets.SettingToggleButton;
import appeng.client.gui.widgets.TabButton;
import appeng.client.gui.widgets.ToolboxPanel;
import appeng.client.gui.widgets.UpgradesPanel;
import appeng.core.AEConfig;
import appeng.core.AELog;
import appeng.core.localization.ButtonToolTips;
import appeng.core.localization.GuiText;
import appeng.core.localization.Tooltips;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.ConfigValuePacket;
import appeng.core.sync.packets.MEInteractionPacket;
import appeng.core.sync.packets.SwitchGuisPacket;
import appeng.helpers.InventoryAction;
import appeng.items.storage.ViewCellItem;
import appeng.menu.AEBaseMenu;
import appeng.menu.SlotSemantics;
import appeng.menu.me.common.GridInventoryEntry;
import appeng.menu.me.common.MEStorageMenu;
import appeng.menu.me.crafting.CraftingStatusMenu;
import appeng.menu.me.interaction.EmptyingAction;
import appeng.menu.me.interaction.StackInteractions;
import appeng.util.ExternalSearch;
import appeng.util.IConfigManagerListener;
import appeng.util.Platform;
import appeng.util.prioritylist.IPartitionList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.class_124;
import net.minecraft.class_1661;
import net.minecraft.class_1713;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2371;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_3675;
import net.minecraft.class_4587;
import net.minecraft.class_5250;

public class MEStorageScreen<C extends MEStorageMenu>
extends AEBaseScreen<C>
implements ISortSource,
IConfigManagerListener {
    private static final String TEXT_ID_ENTRIES_SHOWN = "entriesShown";
    private static final int MIN_ROWS = 2;
    private static String rememberedSearch = "";
    private final appeng.client.gui.style.TerminalStyle style;
    protected final Repo repo;
    private final List<class_1799> currentViewCells = new ArrayList<class_1799>();
    private final IConfigManager configSrc;
    private final boolean supportsViewCells;
    private TabButton craftingStatusBtn;
    private final AETextField searchField;
    private int rows = 0;
    private SettingToggleButton<ViewItems> viewModeToggle;
    private SettingToggleButton<TypeFilter> filterTypesToggle;
    private SettingToggleButton<SortOrder> sortByToggle;
    private final SettingToggleButton<SortDir> sortDirToggle;
    private int currentMouseX = 0;
    private int currentMouseY = 0;
    private final Scrollbar scrollbar;

    public MEStorageScreen(C menu, class_1661 playerInventory, class_2561 title, ScreenStyle style) {
        super(menu, playerInventory, title, style);
        this.style = style.getTerminalStyle();
        if (this.style == null) {
            throw new IllegalStateException("Cannot construct screen " + this.getClass() + " without a terminalStyles setting");
        }
        this.searchField = this.widgets.addTextField("search");
        this.searchField.setPlaceholder((class_2561)GuiText.SearchPlaceholder.text());
        this.scrollbar = this.widgets.addScrollBar("scrollbar");
        this.repo = new Repo(this.scrollbar, this);
        ((MEStorageMenu)menu).setClientRepo(this.repo);
        this.repo.setUpdateViewListener(this::updateScrollbar);
        this.updateScrollbar();
        this.searchField.method_1863(this::setSearchText);
        this.field_2792 = this.style.getScreenWidth();
        this.field_2779 = this.style.getScreenHeight(0);
        this.configSrc = ((IConfigurableObject)this.field_2797).getConfigManager();
        ((MEStorageMenu)this.field_2797).setGui(this);
        List<class_1735> viewCellSlots = ((AEBaseMenu)((Object)menu)).getSlots(SlotSemantics.VIEW_CELL);
        boolean bl = this.supportsViewCells = !viewCellSlots.isEmpty();
        if (this.supportsViewCells) {
            List<class_5250> tooltip = Collections.singletonList(GuiText.TerminalViewCellsTooltip.text());
            this.widgets.add("viewCells", new UpgradesPanel(viewCellSlots, () -> tooltip));
        }
        if (this.style.isSupportsAutoCrafting()) {
            this.craftingStatusBtn = new TabButton(Icon.PERMISSION_CRAFT, (class_2561)GuiText.CraftingStatus.text(), this.field_22788, btn -> this.showCraftingStatus());
            this.craftingStatusBtn.setStyle(TabButton.Style.CORNER);
            this.widgets.add("craftingStatus", (class_339)this.craftingStatusBtn);
        }
        if (this.style.isSortable()) {
            this.sortByToggle = this.addToLeftToolbar(new SettingToggleButton<SortOrder>(Settings.SORT_BY, this.getSortBy(), Platform::isSortOrderAvailable, this::toggleServerSetting));
        }
        if (this.style.isSupportsAutoCrafting()) {
            this.viewModeToggle = this.addToLeftToolbar(new SettingToggleButton<ViewItems>(Settings.VIEW_MODE, this.getSortDisplay(), this::toggleServerSetting));
        }
        if (((MEStorageMenu)this.field_2797).canConfigureTypeFilter()) {
            this.filterTypesToggle = this.addToLeftToolbar(new SettingToggleButton<TypeFilter>(Settings.TYPE_FILTER, this.getTypeFilter(), this::toggleServerSetting));
        }
        this.sortDirToggle = new SettingToggleButton<SortDir>(Settings.SORT_DIRECTION, this.getSortDir(), this::toggleServerSetting);
        this.addToLeftToolbar(this.sortDirToggle);
        this.addToLeftToolbar(new ActionButton(ActionItems.TERMINAL_SETTINGS, this::showSettings));
        TerminalStyle terminalStyle = this.config.getTerminalStyle();
        this.addToLeftToolbar(new SettingToggleButton<TerminalStyle>(Settings.TERMINAL_STYLE, terminalStyle, this::toggleTerminalStyle));
        this.widgets.add("upgrades", new UpgradesPanel(((AEBaseMenu)((Object)menu)).getSlots(SlotSemantics.UPGRADE), ((MEStorageMenu)menu).getHost()));
        if (((MEStorageMenu)menu).getToolbox().isPresent()) {
            this.widgets.add("toolbox", new ToolboxPanel(style, ((MEStorageMenu)menu).getToolbox().getName()));
        }
        if ((((AEBaseMenu)((Object)menu)).isReturnedFromSubScreen() || this.config.isRememberLastSearch()) && rememberedSearch != null && !rememberedSearch.isEmpty()) {
            this.searchField.method_1852(rememberedSearch);
            this.searchField.selectAll();
            this.setSearchText(rememberedSearch);
        }
        if (!((AEBaseMenu)((Object)menu)).isReturnedFromSubScreen() && this.config.isUseExternalSearch() && this.config.isClearExternalSearchOnOpen()) {
            ExternalSearch.clearExternalSearchText();
        }
    }

    private void showSettings() {
        this.switchToScreen(new TerminalSettingsScreen(this));
    }

    @Nullable
    protected IPartitionList createPartitionList(List<class_1799> viewCells) {
        return ViewCellItem.createFilter(AEKeyFilter.none(), viewCells);
    }

    protected void handleGridInventoryEntryMouseClick(@Nullable GridInventoryEntry entry, int mouseButton, class_1713 clickType) {
        EmptyingAction emptyingAction;
        if (entry != null) {
            AELog.debug("Clicked on grid inventory entry serial=%s, key=%s", entry.getSerial(), entry.getWhat());
        }
        if (mouseButton == 1 && clickType == class_1713.field_7790 && !((MEStorageMenu)this.field_2797).method_34255().method_7960() && (emptyingAction = StackInteractions.getEmptyingAction(((MEStorageMenu)this.field_2797).method_34255())) != null && ((MEStorageMenu)this.field_2797).isKeyVisible(emptyingAction.what())) {
            ((MEStorageMenu)this.field_2797).handleInteraction(-1L, InventoryAction.EMPTY_ITEM);
            return;
        }
        if (entry == null) {
            if (clickType == class_1713.field_7790 && !((MEStorageMenu)this.method_17577()).method_34255().method_7960()) {
                InventoryAction action = mouseButton == 1 ? InventoryAction.SPLIT_OR_PLACE_SINGLE : InventoryAction.PICKUP_OR_SET_DOWN;
                ((MEStorageMenu)this.field_2797).handleInteraction(-1L, action);
            }
            return;
        }
        long serial = entry.getSerial();
        if (class_3675.method_15987((long)class_310.method_1551().method_22683().method_4490(), (int)32)) {
            ((MEStorageMenu)this.field_2797).handleInteraction(serial, InventoryAction.MOVE_REGION);
        } else {
            InventoryAction action = null;
            switch (clickType) {
                case field_7790: {
                    InventoryAction inventoryAction = action = mouseButton == 1 ? InventoryAction.SPLIT_OR_PLACE_SINGLE : InventoryAction.PICKUP_OR_SET_DOWN;
                    if (action != InventoryAction.PICKUP_OR_SET_DOWN || !this.shouldCraftOnClick(entry) || !((MEStorageMenu)this.method_17577()).method_34255().method_7960()) break;
                    ((MEStorageMenu)this.field_2797).handleInteraction(serial, InventoryAction.AUTO_CRAFT);
                    return;
                }
                case field_7794: {
                    action = mouseButton == 1 ? InventoryAction.PICKUP_SINGLE : InventoryAction.SHIFT_CLICK;
                    break;
                }
                case field_7796: {
                    if (entry.isCraftable()) {
                        ((MEStorageMenu)this.field_2797).handleInteraction(serial, InventoryAction.AUTO_CRAFT);
                        return;
                    }
                    if (!((MEStorageMenu)this.method_17577()).getPlayer().method_31549().field_7477) break;
                    action = InventoryAction.CREATIVE_DUPLICATE;
                    break;
                }
            }
            if (action != null) {
                ((MEStorageMenu)this.field_2797).handleInteraction(serial, action);
            }
        }
    }

    private boolean shouldCraftOnClick(GridInventoryEntry entry) {
        if (this.isViewOnlyCraftable()) {
            return true;
        }
        return entry.getStoredAmount() == 0L && entry.isCraftable();
    }

    private void updateScrollbar() {
        this.scrollbar.setHeight(this.rows * this.style.getRow().getSrcHeight() - 2);
        int totalRows = (this.repo.size() + this.getSlotsPerRow() - 1) / this.getSlotsPerRow();
        if (this.repo.hasPinnedRow()) {
            ++totalRows;
        }
        this.scrollbar.setRange(0, totalRows - this.rows, Math.max(1, this.rows / 6));
    }

    private void showCraftingStatus() {
        NetworkHandler.instance().sendToServer(SwitchGuisPacket.openSubMenu(CraftingStatusMenu.TYPE));
    }

    private int getSlotsPerRow() {
        return this.style.getSlotsPerRow();
    }

    @Override
    public void method_25426() {
        class_310.method_1551().field_1774.method_1462(true);
        int availableHeight = this.field_22790 - 2 * AEConfig.instance().getTerminalMargin();
        this.rows = Math.max(2, this.config.getTerminalStyle().getRows(this.style.getPossibleRows(availableHeight)));
        this.field_2779 = this.style.getScreenHeight(this.rows);
        class_2371 slots = ((MEStorageMenu)this.field_2797).field_7761;
        slots.removeIf(slot -> slot instanceof RepoSlot);
        int repoIndex = 0;
        for (int row = 0; row < this.rows; ++row) {
            for (int col = 0; col < this.style.getSlotsPerRow(); ++col) {
                Point pos = this.style.getSlotPos(row, col);
                slots.add(new RepoSlot(this.repo, repoIndex++, pos.getX(), pos.getY()));
            }
        }
        super.method_25426();
        if (this.shouldAutoFocus()) {
            this.method_20085((class_364)this.searchField);
        }
        this.updateScrollbar();
    }

    @Override
    protected void updateBeforeRender() {
        super.updateBeforeRender();
        this.repo.setPaused(MEStorageScreen.method_25442());
        this.updateSearch();
        if (!this.field_22785.getString().isEmpty()) {
            this.setTextContent("dialog_title", this.field_22785);
        } else if (((MEStorageMenu)this.field_2797).getTarget() instanceof IMEChest) {
            this.setTextContent("dialog_title", (class_2561)GuiText.Chest.text());
        }
    }

    private void updateSearch() {
        if (this.config.isUseExternalSearch()) {
            int visibleEntries;
            int allEntries;
            this.searchField.method_1862(false);
            String externalSearchText = ExternalSearch.getExternalSearchText();
            if (!Objects.equals(this.repo.getSearchString(), externalSearchText)) {
                this.setSearchText(externalSearchText);
            }
            if ((allEntries = this.repo.getAllEntries().size()) != (visibleEntries = this.repo.size())) {
                this.setTextHidden(TEXT_ID_ENTRIES_SHOWN, false);
                this.setTextContent(TEXT_ID_ENTRIES_SHOWN, (class_2561)GuiText.ShowingOf.text(visibleEntries, allEntries));
            } else {
                this.setTextHidden(TEXT_ID_ENTRIES_SHOWN, true);
            }
        } else {
            this.searchField.method_1862(true);
            this.setTextHidden(TEXT_ID_ENTRIES_SHOWN, true);
            this.searchField.setTooltipMessage(List.of(this.config.isSearchTooltips() ? GuiText.SearchTooltipIncludingTooltips.text() : GuiText.SearchTooltip.text(), GuiText.SearchTooltipModId.text(), GuiText.SearchTooltipItemId.text(), GuiText.SearchTooltipTag.text()));
            if (this.config.isSyncWithExternalSearch()) {
                String externalSearchText;
                if (this.searchField.method_25370()) {
                    ExternalSearch.setExternalSearchText(this.searchField.method_1882());
                } else if (ExternalSearch.isExternalSearchFocused() && !Objects.equals(externalSearchText = ExternalSearch.getExternalSearchText(), this.searchField.method_1882())) {
                    this.searchField.method_1852(externalSearchText);
                }
            }
        }
    }

    @Override
    protected <P extends AEBaseScreen<C>> void onReturnFromSubScreen(AESubScreen<C, P> subScreen) {
        if (subScreen instanceof TerminalSettingsScreen) {
            this.reinitalize();
            if (!this.config.isUseExternalSearch()) {
                this.setSearchText(this.searchField.method_1882());
            }
        }
    }

    @Override
    public void drawFG(class_4587 poseStack, int offsetX, int offsetY, int mouseX, int mouseY) {
        this.currentMouseX = mouseX;
        this.currentMouseY = mouseY;
        if (this.repo.hasPinnedRow()) {
            this.renderPinnedRowDecorations(poseStack);
        }
        if (this.craftingStatusBtn != null && ((MEStorageMenu)this.field_2797).activeCraftingJobs != -1) {
            int x = this.craftingStatusBtn.field_22760 + (this.craftingStatusBtn.method_25368() - 16) / 2;
            int y = this.craftingStatusBtn.field_22761 + (this.craftingStatusBtn.method_25364() - 16) / 2;
            StackSizeRenderer.renderSizeLabel(this.field_22793, x - this.field_2776, y - this.field_2800, String.valueOf(((MEStorageMenu)this.field_2797).activeCraftingJobs));
        }
    }

    private void renderPinnedRowDecorations(class_4587 poseStack) {
        for (class_1735 slot : ((MEStorageMenu)this.field_2797).field_7761) {
            RepoSlot repoSlot;
            GridInventoryEntry entry;
            if (!(slot instanceof RepoSlot) || (entry = (repoSlot = (RepoSlot)slot).getEntry()) == null || !PendingCraftingJobs.hasPendingJob(entry.getWhat())) continue;
            int frames = 12;
            int frame = (int)(System.currentTimeMillis() / 100L % (long)frames);
            Blitter.texture("block/molecular_assembler_lights.png", 16, 192).src(2, 2 + frame * 16, 12, 12).dest(slot.field_7873 - 1, slot.field_7872 - 1, 18, 18).blit(poseStack, this.method_25305());
        }
    }

    @Override
    public boolean method_25402(double xCoord, double yCoord, int btn) {
        RepoSlot repoSlot;
        class_1735 slot;
        if (this.searchField.method_25405(xCoord, yCoord) && btn == 1) {
            this.searchField.method_1852("");
            this.setSearchText("");
        }
        if (class_310.method_1551().field_1690.field_1871.method_1433(btn) && (slot = this.method_2386(xCoord, yCoord)) instanceof RepoSlot && (repoSlot = (RepoSlot)slot).isCraftable()) {
            this.handleGridInventoryEntryMouseClick(repoSlot.getEntry(), btn, class_1713.field_7796);
            return true;
        }
        return super.method_25402(xCoord, yCoord, btn);
    }

    @Override
    public boolean method_25401(double x, double y, double wheelDelta) {
        class_1735 class_17352;
        if (wheelDelta != 0.0 && MEStorageScreen.method_25442() && (class_17352 = this.method_2386(x, y)) instanceof RepoSlot) {
            RepoSlot repoSlot = (RepoSlot)class_17352;
            GridInventoryEntry entry = repoSlot.getEntry();
            long serial = entry != null ? entry.getSerial() : -1L;
            InventoryAction direction = wheelDelta > 0.0 ? InventoryAction.ROLL_DOWN : InventoryAction.ROLL_UP;
            int times = (int)Math.abs(wheelDelta);
            for (int h = 0; h < times; ++h) {
                MEInteractionPacket p = new MEInteractionPacket(((MEStorageMenu)this.field_2797).field_7763, serial, direction);
                NetworkHandler.instance().sendToServer(p);
            }
            return true;
        }
        return super.method_25401(x, y, wheelDelta);
    }

    @Override
    protected void method_2383(class_1735 slot, int slotIdx, int mouseButton, class_1713 clickType) {
        if (slot instanceof RepoSlot) {
            RepoSlot repoSlot = (RepoSlot)slot;
            this.handleGridInventoryEntryMouseClick(repoSlot.getEntry(), mouseButton, clickType);
            return;
        }
        super.method_2383(slot, slotIdx, mouseButton, clickType);
    }

    public void method_25432() {
        super.method_25432();
        class_310.method_1551().field_1774.method_1462(false);
        this.storeState();
        for (GridInventoryEntry entry : this.repo.getPinnedEntries()) {
            PinnedKeys.PinInfo info = PinnedKeys.getPinInfo(entry.getWhat());
            if (info == null || info.reason != PinnedKeys.PinReason.CRAFTING || PendingCraftingJobs.hasPendingJob(entry.getWhat())) continue;
            info.canPrune = true;
        }
    }

    @Override
    public void drawBG(class_4587 poseStack, int offsetX, int offsetY, int mouseX, int mouseY, float partialTicks) {
        this.style.getHeader().dest(offsetX, offsetY).blit(poseStack, this.method_25305());
        int y = offsetY;
        this.style.getHeader().dest(offsetX, y).blit(poseStack, this.method_25305());
        y += this.style.getHeader().getSrcHeight();
        int rowsToDraw = Math.max(2, this.rows);
        for (int x = 0; x < rowsToDraw; ++x) {
            Blitter row = this.style.getRow();
            if (x == 0) {
                row = this.style.getFirstRow();
            } else if (x + 1 == rowsToDraw) {
                row = this.style.getLastRow();
            }
            row.dest(offsetX, y).blit(poseStack, this.method_25305());
            y += this.style.getRow().getSrcHeight();
        }
        this.style.getBottom().dest(offsetX, y).blit(poseStack, this.method_25305());
        if (this.repo.hasPinnedRow()) {
            Blitter.texture("guis/terminal.png").src(0, 204, 162, 18).dest(offsetX + 7, offsetY + this.style.getHeader().getSrcHeight()).blit(poseStack, this.method_25305());
        }
        if (this.searchField != null) {
            this.searchField.method_25394(poseStack, mouseX, mouseY, partialTicks);
        }
    }

    @Override
    public void method_2385(class_4587 poseStack, class_1735 s) {
        if (s instanceof RepoSlot) {
            RepoSlot repoSlot = (RepoSlot)s;
            if (!this.repo.hasPower()) {
                MEStorageScreen.method_25294((class_4587)poseStack, (int)s.field_7873, (int)s.field_7872, (int)(16 + s.field_7873), (int)(16 + s.field_7872), (int)0x66111111);
            } else {
                GridInventoryEntry entry = repoSlot.getEntry();
                if (entry != null) {
                    try {
                        AEStackRendering.drawInGui(this.field_22787, poseStack, s.field_7873, s.field_7872, this.method_25305(), entry.getWhat());
                    }
                    catch (Exception err) {
                        AELog.warn("[AppEng] AE prevented crash while drawing slot: " + err, new Object[0]);
                    }
                    long storedAmount = entry.getStoredAmount();
                    boolean craftable = entry.isCraftable();
                    boolean useLargeFonts = this.config.isUseLargeFonts();
                    if (craftable && (this.isViewOnlyCraftable() || storedAmount <= 0L)) {
                        String craftLabelText = useLargeFonts ? GuiText.LargeFontCraft.getLocal() : GuiText.SmallFontCraft.getLocal();
                        StackSizeRenderer.renderSizeLabel(this.field_22793, s.field_7873, s.field_7872, craftLabelText);
                    } else {
                        AmountFormat format = useLargeFonts ? AmountFormat.SLOT_LARGE_FONT : AmountFormat.SLOT;
                        String text = entry.getWhat().formatAmount(storedAmount, format);
                        StackSizeRenderer.renderSizeLabel(this.field_22793, s.field_7873, s.field_7872, text, useLargeFonts);
                        if (craftable) {
                            StackSizeRenderer.renderSizeLabel(this.field_22793, s.field_7873 - 11, s.field_7872 - 11, "+", false);
                        }
                    }
                }
            }
            return;
        }
        super.method_2385(poseStack, s);
    }

    protected final boolean isViewOnlyCraftable() {
        return this.viewModeToggle != null && this.viewModeToggle.getCurrentValue() == ViewItems.CRAFTABLE;
    }

    protected void method_2380(class_4587 poseStack, int x, int y) {
        class_1735 class_17352 = this.field_2787;
        if (class_17352 instanceof RepoSlot) {
            GridInventoryEntry entry;
            EmptyingAction emptyingAction;
            RepoSlot repoSlot = (RepoSlot)class_17352;
            class_1799 carried = ((MEStorageMenu)this.field_2797).method_34255();
            if (!carried.method_7960() && (emptyingAction = StackInteractions.getEmptyingAction(carried)) != null && ((MEStorageMenu)this.field_2797).isKeyVisible(emptyingAction.what())) {
                this.drawTooltip(poseStack, x, y, Tooltips.getEmptyingTooltip(ButtonToolTips.StoreAction, carried, emptyingAction));
                return;
            }
            if (carried.method_7960() && (entry = repoSlot.getEntry()) != null) {
                this.renderGridInventoryEntryTooltip(poseStack, entry, x, y);
            }
            return;
        }
        super.method_2380(poseStack, x, y);
    }

    protected void renderGridInventoryEntryTooltip(class_4587 poseStack, GridInventoryEntry entry, int x, int y) {
        AEKey aEKey;
        long requestableAmount;
        List<class_2561> currentToolTip = AEStackRendering.getTooltip(entry.getWhat());
        if (Tooltips.shouldShowAmountTooltip(entry.getWhat(), entry.getStoredAmount())) {
            currentToolTip.add(Tooltips.getAmountTooltip(ButtonToolTips.StoredAmount, entry.getWhat(), entry.getStoredAmount()));
        }
        if ((requestableAmount = entry.getRequestableAmount()) > 0L) {
            String formattedAmount = entry.getWhat().formatAmount(requestableAmount, AmountFormat.FULL);
            currentToolTip.add((class_2561)ButtonToolTips.RequestableAmount.text(formattedAmount));
        }
        if (entry.isCraftable() && !this.isViewOnlyCraftable() && entry.getStoredAmount() > 0L) {
            currentToolTip.add((class_2561)ButtonToolTips.Craftable.text().method_27661().method_27692(class_124.field_1063));
        }
        if (class_310.method_1551().field_1690.field_1827) {
            currentToolTip.add((class_2561)ButtonToolTips.Serial.text(entry.getSerial()).method_27692(class_124.field_1063));
        }
        if ((aEKey = entry.getWhat()) instanceof AEItemKey) {
            AEItemKey itemKey = (AEItemKey)aEKey;
            class_1799 stack = itemKey.toStack();
            this.method_32634(poseStack, currentToolTip, stack.method_32347(), x, y);
        } else {
            this.method_30901(poseStack, currentToolTip, x, y);
        }
    }

    public boolean method_25400(char character, int modifiers) {
        if (character == ' ' && this.searchField.method_1882().isEmpty()) {
            return true;
        }
        if (this.shouldAutoFocus() && !this.searchField.method_25370() && this.isHovered()) {
            this.method_20085((class_364)this.searchField);
        }
        return super.method_25400(character, modifiers);
    }

    private boolean shouldAutoFocus() {
        return this.config.isAutoFocusSearch() && !this.config.isUseExternalSearch();
    }

    public boolean method_25404(int keyCode, int scanCode, int p_keyPressed_3_) {
        class_3675.class_306 input = class_3675.method_15985((int)keyCode, (int)scanCode);
        if (this.checkHotbarKeys(input)) {
            return true;
        }
        if (this.searchField.method_25370() && keyCode == 257) {
            this.searchField.method_1876(false);
            this.method_25395(null);
            return true;
        }
        return super.method_25404(keyCode, scanCode, p_keyPressed_3_);
    }

    private boolean isHovered() {
        return this.method_2378(0, 0, this.field_2792, this.field_2779, this.currentMouseX, this.currentMouseY);
    }

    @Override
    public void method_37432() {
        List<class_1799> viewCells;
        this.repo.setPower(((MEStorageMenu)this.field_2797).isPowered());
        if (this.supportsViewCells && !this.currentViewCells.equals(viewCells = ((MEStorageMenu)this.field_2797).getViewCells())) {
            this.currentViewCells.clear();
            this.currentViewCells.addAll(viewCells);
            this.repo.setPartitionList(this.createPartitionList(viewCells));
        }
        super.method_37432();
    }

    @Override
    public SortOrder getSortBy() {
        return this.configSrc.getSetting(Settings.SORT_BY);
    }

    @Override
    public SortDir getSortDir() {
        return this.configSrc.getSetting(Settings.SORT_DIRECTION);
    }

    @Override
    public ViewItems getSortDisplay() {
        return this.configSrc.getSetting(Settings.VIEW_MODE);
    }

    @Override
    public TypeFilter getTypeFilter() {
        return this.configSrc.getSetting(Settings.TYPE_FILTER);
    }

    @Override
    public void onSettingChanged(IConfigManager manager, Setting<?> setting) {
        if (this.sortByToggle != null) {
            this.sortByToggle.set(this.getSortBy());
        }
        if (this.sortDirToggle != null) {
            this.sortDirToggle.set(this.getSortDir());
        }
        if (this.viewModeToggle != null) {
            this.viewModeToggle.set(this.getSortDisplay());
        }
        if (this.filterTypesToggle != null) {
            this.filterTypesToggle.set(this.getTypeFilter());
        }
        this.repo.updateView();
    }

    private void toggleTerminalStyle(SettingToggleButton<TerminalStyle> btn, boolean backwards) {
        TerminalStyle next = btn.getNextValue(backwards);
        this.config.setTerminalStyle(next);
        btn.set(next);
        this.reinitalize();
    }

    private <SE extends Enum<SE>> void toggleServerSetting(SettingToggleButton<SE> btn, boolean backwards) {
        SE next = btn.getNextValue(backwards);
        NetworkHandler.instance().sendToServer(new ConfigValuePacket(btn.getSetting(), next));
        btn.set(next);
    }

    private void setSearchText(String text) {
        this.repo.setSearchString(text);
        this.repo.updateView();
        this.updateScrollbar();
    }

    private void reinitalize() {
        this.storeState();
        new ArrayList<class_364>(this.method_25396()).forEach(x$0 -> this.method_37066((class_364)x$0));
        this.method_25426();
    }

    public void storeState() {
        rememberedSearch = this.searchField.method_1882();
    }
}

