/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.guidebook.compiler;

import appeng.client.guidebook.compiler.FrontmatterNavigation;
import appeng.client.guidebook.compiler.IdUtils;
import appeng.shaded.snakeyaml.LoaderOptions;
import appeng.shaded.snakeyaml.Yaml;
import appeng.shaded.snakeyaml.constructor.SafeConstructor;
import java.util.Map;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

public record Frontmatter(FrontmatterNavigation navigationEntry, Map<String, Object> additionalProperties) {
    public static Frontmatter parse(class_2960 pageId, String yamlText) {
        Yaml yaml = new Yaml(new SafeConstructor(new LoaderOptions()));
        FrontmatterNavigation navigation = null;
        Map data = (Map)yaml.load(yamlText);
        Object navigationObj = data.remove("navigation");
        if (navigationObj != null) {
            if (!(navigationObj instanceof Map)) {
                throw new IllegalArgumentException("The navigation key in the frontmatter has to be a map");
            }
            Map navigationMap = (Map)navigationObj;
            String title = Frontmatter.getString(navigationMap, "title");
            if (title == null) {
                throw new IllegalArgumentException("title is missing in navigation frontmatter");
            }
            String parentIdStr = Frontmatter.getString(navigationMap, "parent");
            int position = 0;
            if (navigationMap.containsKey("position")) {
                position = Frontmatter.getInt(navigationMap, "position");
            }
            String iconIdStr = Frontmatter.getString(navigationMap, "icon");
            class_2487 iconNbt = null;
            class_2960 parentId = null;
            if (parentIdStr != null) {
                parentId = IdUtils.resolveId(parentIdStr, pageId.method_12836());
            }
            class_2960 iconId = null;
            if (iconIdStr != null) {
                iconId = IdUtils.resolveId(iconIdStr, pageId.method_12836());
            }
            navigation = new FrontmatterNavigation(title, parentId, position, iconId, iconNbt);
        }
        return new Frontmatter(navigation, Map.copyOf(data));
    }

    @Nullable
    private static String getString(Map<?, ?> map, String key) {
        Object value = map.get(key);
        if (value != null && !(value instanceof String)) {
            throw new IllegalArgumentException("Key " + key + " has to be a String!");
        }
        return (String)value;
    }

    private static int getInt(Map<?, ?> map, String key) {
        Object value = map.get(key);
        if (value == null) {
            throw new IllegalArgumentException("Key " + key + " is missing in navigation frontmatter");
        }
        if (!(value instanceof Number)) {
            throw new IllegalArgumentException("Key " + key + " has to be a number!");
        }
        Number number = (Number)value;
        return number.intValue();
    }
}

