/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.guidebook.compiler.tags;

import appeng.client.guidebook.compiler.PageCompiler;
import appeng.client.guidebook.compiler.tags.BlockTagCompiler;
import appeng.client.guidebook.compiler.tags.MdxAttrs;
import appeng.client.guidebook.document.block.LytBlock;
import appeng.client.guidebook.document.block.LytBlockContainer;
import appeng.client.guidebook.document.block.recipes.LytCraftingRecipe;
import appeng.client.guidebook.document.block.recipes.LytInscriberRecipe;
import appeng.libs.mdast.mdx.model.MdxJsxElementFields;
import appeng.recipes.handlers.InscriberRecipe;
import appeng.util.Platform;
import java.util.List;
import java.util.function.Function;
import net.minecraft.class_1263;
import net.minecraft.class_1792;
import net.minecraft.class_1860;
import net.minecraft.class_1863;
import net.minecraft.class_2960;
import net.minecraft.class_3956;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;

public class RecipeForCompiler
extends BlockTagCompiler {
    private final List<RecipeTypeMapping<?, ?>> mappings = List.of(new RecipeTypeMapping(class_3956.field_17545, LytCraftingRecipe::new), new RecipeTypeMapping(InscriberRecipe.TYPE, LytInscriberRecipe::new));

    @Override
    protected void compile(PageCompiler compiler, LytBlockContainer parent, MdxJsxElementFields el) {
        Pair<class_2960, class_1792> itemAndId = MdxAttrs.getRequiredItemAndId(compiler, parent, el, "id");
        if (itemAndId == null) {
            return;
        }
        class_2960 id = (class_2960)itemAndId.getLeft();
        class_1792 item = (class_1792)itemAndId.getRight();
        class_1863 recipeManager = Platform.getClientRecipeManager();
        if (recipeManager == null) {
            parent.appendError(compiler, "Cannot show recipe for " + id + " while not in-game", el);
            return;
        }
        for (RecipeTypeMapping<?, ?> mapping : this.mappings) {
            LytBlock block = mapping.tryCreate(recipeManager, item);
            if (block == null) continue;
            parent.append(block);
            return;
        }
        parent.appendError(compiler, "Couldn't find recipe for " + id, el);
    }

    private record RecipeTypeMapping<T extends class_1860<C>, C extends class_1263>(class_3956<T> recipeType, Function<T, LytBlock> factory) {
        @Nullable
        LytBlock tryCreate(class_1863 recipeManager, class_1792 resultItem) {
            for (class_1860 recipe : recipeManager.method_17717(this.recipeType).values()) {
                if (recipe.method_8110().method_7909() != resultItem) continue;
                return this.factory.apply(recipe);
            }
            return null;
        }
    }
}

