/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.guidebook.document.block;

import appeng.client.guidebook.document.LytRect;
import appeng.client.guidebook.document.block.LytBlock;
import appeng.client.guidebook.document.block.LytBlockContainer;
import appeng.client.guidebook.document.block.LytNode;
import appeng.client.guidebook.document.flow.LytFlowContainer;
import appeng.client.guidebook.document.flow.LytFlowContent;
import appeng.client.guidebook.document.flow.LytFlowInlineBlock;
import appeng.client.guidebook.layout.LayoutContext;
import appeng.client.guidebook.layout.Layouts;
import appeng.client.guidebook.render.SimpleRenderContext;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_4597;
import org.jetbrains.annotations.Nullable;

public class LytDocument
extends LytNode
implements LytBlockContainer {
    private final List<LytBlock> blocks = new ArrayList<LytBlock>();
    @Nullable
    private Layout layout;
    @Nullable
    private HitTestResult hoveredElement;

    public int getAvailableWidth() {
        return this.layout != null ? this.layout.availableWidth() : 0;
    }

    public int getContentHeight() {
        return this.layout != null ? this.layout.contentHeight() : 0;
    }

    public List<LytBlock> getBlocks() {
        return this.blocks;
    }

    public List<LytBlock> getChildren() {
        return this.blocks;
    }

    @Override
    public LytRect getBounds() {
        return this.layout != null ? new LytRect(0, 0, this.layout.availableWidth, this.layout.contentHeight) : null;
    }

    @Override
    public void removeChild(LytNode node) {
        if (node instanceof LytBlock) {
            LytBlock block = (LytBlock)node;
            this.blocks.remove(block);
        }
    }

    @Override
    public void append(LytBlock block) {
        if (block.parent != null) {
            block.parent.removeChild(block);
        }
        block.parent = this;
        this.blocks.add(block);
    }

    public void updateLayout(LayoutContext context, int availableWidth) {
        if (this.layout != null && this.layout.availableWidth == availableWidth) {
            return;
        }
        this.layout = this.createLayout(context, availableWidth);
    }

    private Layout createLayout(LayoutContext context, int availableWidth) {
        LytRect bounds = Layouts.verticalLayout(context, this.blocks, 0, 0, availableWidth, 5, 5, 5, 5);
        return new Layout(availableWidth, bounds.height());
    }

    public void render(SimpleRenderContext context) {
        for (LytBlock block : this.blocks) {
            if (block.isCulled(context.viewport())) continue;
            block.render(context);
        }
    }

    public void renderBatch(SimpleRenderContext context, class_4597 buffers) {
        for (LytBlock block : this.blocks) {
            if (!block.getBounds().intersects(context.viewport())) continue;
            block.renderBatch(context, buffers);
        }
    }

    public HitTestResult getHoveredElement() {
        return this.hoveredElement;
    }

    public void setHoveredElement(HitTestResult hoveredElement) {
        if (hoveredElement != this.hoveredElement) {
            if (this.hoveredElement != null) {
                this.hoveredElement.node.onMouseLeave();
            }
            this.hoveredElement = hoveredElement;
            if (this.hoveredElement != null) {
                this.hoveredElement.node.onMouseEnter(hoveredElement.content());
            }
        }
    }

    public HitTestResult pick(int x, int y) {
        return LytDocument.pick(this, x, y);
    }

    private static HitTestResult pick(LytNode root, int x, int y) {
        LytNode node = root.pickNode(x, y);
        if (node != null) {
            LytFlowInlineBlock inlineBlock;
            LytFlowContainer container;
            LytFlowContent content = null;
            if (node instanceof LytFlowContainer && (content = (container = (LytFlowContainer)((Object)node)).pickContent(x, y)) instanceof LytFlowInlineBlock && (inlineBlock = (LytFlowInlineBlock)content).getBlock() != null) {
                return LytDocument.pick(inlineBlock.getBlock(), x, y);
            }
            return new HitTestResult(node, content);
        }
        return null;
    }

    @Override
    public void onMouseEnter(@Nullable LytFlowContent hoveredContent) {
    }

    public record Layout(int availableWidth, int contentHeight) {
    }

    public record HitTestResult(LytNode node, @Nullable LytFlowContent content) {
    }
}

