/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.guidebook.document.block;

import appeng.client.guidebook.document.LytRect;
import appeng.client.guidebook.document.block.LytBlock;
import appeng.client.guidebook.document.block.LytNode;
import appeng.client.guidebook.document.flow.LytFlowContainer;
import appeng.client.guidebook.document.flow.LytFlowContent;
import appeng.client.guidebook.layout.LayoutContext;
import appeng.client.guidebook.layout.flow.FlowBuilder;
import appeng.client.guidebook.layout.flow.LineBlock;
import appeng.client.guidebook.layout.flow.LineElement;
import appeng.client.guidebook.render.RenderContext;
import appeng.client.guidebook.style.ResolvedTextStyle;
import java.util.stream.Stream;
import net.minecraft.class_4597;
import org.jetbrains.annotations.Nullable;

public class LytParagraph
extends LytBlock
implements LytFlowContainer {
    protected final FlowBuilder content = new FlowBuilder();
    protected int paddingLeft;
    protected int paddingTop;
    protected int paddingRight;
    protected int paddingBottom;
    @Nullable
    protected LytFlowContent hoveredContent;

    @Override
    public void append(LytFlowContent child) {
        this.content.append(child);
        child.setParent(this);
    }

    @Override
    public boolean isCulled(LytRect viewport) {
        if (this.content.floatsIntersect(viewport)) {
            return false;
        }
        return super.isCulled(viewport);
    }

    @Override
    public LytRect computeLayout(LayoutContext context, int x, int y, int availableWidth) {
        ResolvedTextStyle style = this.resolveStyle();
        LytRect bounds = this.content.computeLayout(context, x += this.paddingLeft, y += this.paddingTop, availableWidth -= this.paddingLeft + this.paddingRight, style.alignment());
        if (this.paddingBottom != 0) {
            return bounds.withHeight(bounds.height() + this.paddingBottom);
        }
        return bounds;
    }

    @Override
    public void onMouseEnter(@Nullable LytFlowContent hoveredContent) {
        super.onMouseEnter(hoveredContent);
        this.hoveredContent = hoveredContent;
    }

    @Override
    public void onMouseLeave() {
        super.onMouseLeave();
        this.hoveredContent = null;
    }

    @Override
    @Nullable
    public LytNode pickNode(int x, int y) {
        LineBlock fl = this.content.pickFloatingElement(x, y);
        if (fl != null) {
            return this;
        }
        return super.pickNode(x, y);
    }

    @Override
    public void renderBatch(RenderContext context, class_4597 buffers) {
        if (this.bounds.intersects(context.viewport())) {
            this.content.renderBatch(context, buffers, this.hoveredContent);
        }
        this.content.renderFloatsBatch(context, buffers, this.hoveredContent);
    }

    @Override
    public void render(RenderContext context) {
        if (this.bounds.intersects(context.viewport())) {
            this.content.render(context, this.hoveredContent);
        }
        this.content.renderFloats(context, this.hoveredContent);
    }

    @Override
    @Nullable
    public LytFlowContent pickContent(int x, int y) {
        LineElement lineEl = this.content.pick(x, y);
        return lineEl != null ? lineEl.getFlowContent() : null;
    }

    @Override
    public Stream<LytRect> enumerateContentBounds(LytFlowContent content) {
        return this.content.enumerateContentBounds(content);
    }

    public int getPaddingLeft() {
        return this.paddingLeft;
    }

    public void setPaddingLeft(int paddingLeft) {
        this.paddingLeft = paddingLeft;
    }

    public int getPaddingTop() {
        return this.paddingTop;
    }

    public void setPaddingTop(int paddingTop) {
        this.paddingTop = paddingTop;
    }

    public int getPaddingRight() {
        return this.paddingRight;
    }

    public void setPaddingRight(int paddingRight) {
        this.paddingRight = paddingRight;
    }

    public int getPaddingBottom() {
        return this.paddingBottom;
    }

    public void setPaddingBottom(int paddingBottom) {
        this.paddingBottom = paddingBottom;
    }
}

