/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.guidebook.document.block;

import appeng.client.gui.Icon;
import appeng.client.guidebook.document.LytRect;
import appeng.client.guidebook.document.block.LytBox;
import appeng.client.guidebook.document.block.LytSlot;
import appeng.client.guidebook.layout.LayoutContext;
import appeng.client.guidebook.render.ColorRef;
import appeng.client.guidebook.render.RenderContext;
import net.minecraft.class_1856;

public class LytSlotGrid
extends LytBox {
    private final int width;
    private final int height;
    private final LytSlot[] slots;
    private boolean renderEmptySlots = true;

    public LytSlotGrid(int width, int height) {
        this.width = width;
        this.height = height;
        this.slots = new LytSlot[width * height];
    }

    public boolean isRenderEmptySlots() {
        return this.renderEmptySlots;
    }

    public void setRenderEmptySlots(boolean renderEmptySlots) {
        this.renderEmptySlots = renderEmptySlots;
    }

    @Override
    protected LytRect computeBoxLayout(LayoutContext context, int x, int y, int availableWidth) {
        for (int row = 0; row < this.height; ++row) {
            for (int col = 0; col < this.width; ++col) {
                LytSlot slot;
                int index = this.getSlotIndex(col, row);
                if (index >= this.slots.length || (slot = this.slots[index]) == null) continue;
                slot.layout(context, x + col * 18, y + row * 18, availableWidth);
            }
        }
        return new LytRect(x, y, 18 * this.width, 18 * this.height);
    }

    public void setIngredient(int x, int y, class_1856 ingredient) {
        if (x < 0 || x >= this.width) {
            throw new IndexOutOfBoundsException("x: " + x);
        }
        if (y < 0 || y >= this.height) {
            throw new IndexOutOfBoundsException("y: " + y);
        }
        int slotIndex = this.getSlotIndex(x, y);
        LytSlot slot = this.slots[slotIndex];
        if (slot != null) {
            slot.removeChild(slot);
            this.slots[slotIndex] = null;
        }
        slot = this.slots[slotIndex] = new LytSlot(ingredient);
        this.append(slot);
    }

    @Override
    public void render(RenderContext context) {
        if (this.renderEmptySlots) {
            for (int y = 0; y < this.height; ++y) {
                for (int x = 0; x < this.width; ++x) {
                    int index = this.getSlotIndex(x, y);
                    if (index < this.slots.length && this.slots[index] != null) continue;
                    context.drawIcon(this.bounds.x() + 18 * x, this.bounds.y() + 18 * y, Icon.SLOT_BACKGROUND, ColorRef.WHITE);
                }
            }
        }
        super.render(context);
    }

    private int getSlotIndex(int col, int row) {
        return row * this.width + col;
    }
}

