/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.guidebook.render;

import appeng.client.gui.Icon;
import appeng.client.gui.style.BackgroundGenerator;
import appeng.client.guidebook.document.LytRect;
import appeng.client.guidebook.render.ColorRef;
import appeng.client.guidebook.render.GuidePageTexture;
import appeng.client.guidebook.render.LightDarkMode;
import appeng.client.guidebook.style.ResolvedTextStyle;
import net.minecraft.class_1044;
import net.minecraft.class_1058;
import net.minecraft.class_1159;
import net.minecraft.class_1160;
import net.minecraft.class_1799;
import net.minecraft.class_241;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_4587;
import net.minecraft.class_4597;

public interface RenderContext {
    public LightDarkMode lightDarkMode();

    default public boolean isDarkMode() {
        return this.lightDarkMode() == LightDarkMode.DARK_MODE;
    }

    public class_4587 poseStack();

    public LytRect viewport();

    public int resolveColor(ColorRef var1);

    public void fillRect(LytRect var1, ColorRef var2, ColorRef var3, ColorRef var4, ColorRef var5);

    default public void fillTexturedRect(LytRect rect, class_1044 texture, ColorRef topLeft, ColorRef topRight, ColorRef bottomRight, ColorRef bottomLeft) {
        this.fillTexturedRect(rect, texture, topLeft, topRight, bottomRight, bottomLeft, 0.0f, 0.0f, 1.0f, 1.0f);
    }

    public void fillTexturedRect(LytRect var1, class_1044 var2, ColorRef var3, ColorRef var4, ColorRef var5, ColorRef var6, float var7, float var8, float var9, float var10);

    default public void fillTexturedRect(LytRect rect, GuidePageTexture texture) {
        this.fillTexturedRect(rect, texture.use(), ColorRef.WHITE);
    }

    default public void fillTexturedRect(LytRect rect, class_1044 texture) {
        this.fillTexturedRect(rect, texture, ColorRef.WHITE);
    }

    default public void fillTexturedRect(LytRect rect, class_1044 texture, ColorRef color) {
        this.fillTexturedRect(rect, texture, color, color, color, color);
    }

    default public void fillTexturedRect(LytRect rect, GuidePageTexture texture, ColorRef color) {
        this.fillTexturedRect(rect, texture.use(), color, color, color, color);
    }

    default public void fillTexturedRect(LytRect rect, class_1058 sprite, ColorRef color) {
        this.fillTexturedRect(rect, (class_1044)sprite.method_24119(), color, color, color, color, sprite.method_4594(), sprite.method_4593(), sprite.method_4577(), sprite.method_4575());
    }

    default public void drawIcon(int x, int y, Icon icon, ColorRef color) {
        float u0 = (float)icon.x / 256.0f;
        float v0 = (float)icon.y / 256.0f;
        float u1 = (float)(icon.x + icon.width) / 256.0f;
        float v1 = (float)(icon.y + icon.height) / 256.0f;
        class_1044 texture = class_310.method_1551().method_1531().method_4619(Icon.TEXTURE);
        this.fillTexturedRect(new LytRect(x, y, icon.width, icon.height), texture, color, color, color, color, u0, v0, u1, v1);
    }

    default public void fillTexturedRect(LytRect rect, class_2960 textureId) {
        this.fillTexturedRect(rect, textureId, ColorRef.WHITE);
    }

    default public void fillTexturedRect(LytRect rect, class_2960 textureId, ColorRef color) {
        class_1044 texture = class_310.method_1551().method_1531().method_4619(textureId);
        this.fillTexturedRect(rect, texture, color);
    }

    public void fillTriangle(class_241 var1, class_241 var2, class_241 var3, ColorRef var4);

    default public class_327 font() {
        return class_310.method_1551().field_1772;
    }

    default public float getAdvance(int codePoint, ResolvedTextStyle style) {
        return this.font().method_27526(style.font()).method_2011(codePoint, false).method_16798(Boolean.TRUE.equals(style.bold()));
    }

    default public float getWidth(String text, ResolvedTextStyle style) {
        return (float)text.codePoints().mapToDouble(cp -> this.getAdvance(cp, style)).sum();
    }

    default public void renderText(String text, ResolvedTextStyle style, float x, float y) {
        class_4597.class_4598 bufferSource = class_4597.method_22991((class_287)class_289.method_1348().method_1349());
        this.renderTextInBatch(text, style, x, y, (class_4597)bufferSource);
        bufferSource.method_22993();
    }

    default public void renderTextInBatch(String text, ResolvedTextStyle style, float x, float y, class_4597 buffers) {
        class_2583 effectiveStyle = class_2583.field_24360.method_10982(Boolean.valueOf(style.bold())).method_10978(Boolean.valueOf(style.italic())).method_30938(Boolean.valueOf(style.underlined())).method_36140(Boolean.valueOf(style.strikethrough())).method_27704(style.font());
        class_1159 matrix = this.poseStack().method_23760().method_23761();
        if (style.fontScale() != 1.0f) {
            matrix = matrix.method_22673();
            matrix.method_31544(style.fontScale(), style.fontScale(), 1.0f);
            matrix.method_22671(new class_1160(x, y, 0.0f));
            x = 0.0f;
            y = 0.0f;
        }
        this.font().method_30882((class_2561)class_2561.method_43470((String)text).method_27696(effectiveStyle), x, y, this.resolveColor(style.color()), false, matrix, buffers, false, 0, 0xF000F0);
    }

    default public void fillRect(int x, int y, int width, int height, ColorRef color) {
        this.fillRect(new LytRect(x, y, width, height), color);
    }

    default public void fillRect(LytRect rect, ColorRef color) {
        this.fillRect(rect, color, color, color, color);
    }

    default public void fillGradientVertical(LytRect rect, ColorRef top, ColorRef bottom) {
        this.fillRect(rect, top, top, bottom, bottom);
    }

    default public void fillGradientVertical(int x, int y, int width, int height, ColorRef top, ColorRef bottom) {
        this.fillGradientVertical(new LytRect(x, y, width, height), top, bottom);
    }

    default public void fillGradientHorizontal(LytRect rect, ColorRef left, ColorRef right) {
        this.fillRect(rect, left, right, right, left);
    }

    default public void fillGradientHorizontal(int x, int y, int width, int height, ColorRef left, ColorRef right) {
        this.fillGradientHorizontal(new LytRect(x, y, width, height), left, right);
    }

    default public class_4597.class_4598 beginBatch() {
        return class_4597.method_22991((class_287)class_289.method_1348().method_1349());
    }

    default public void endBatch(class_4597.class_4598 batch) {
        batch.method_22993();
    }

    default public void renderItem(class_1799 stack, int x, int y, float width, float height) {
        this.renderItem(stack, x, y, 0, width, height);
    }

    public void renderItem(class_1799 var1, int var2, int var3, int var4, float var5, float var6);

    default public void renderPanel(LytRect bounds) {
        BackgroundGenerator.draw(bounds.width(), bounds.height(), this.poseStack(), 0, bounds.x(), bounds.y());
    }
}

