/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.guidebook.screen;

import appeng.client.Point;
import appeng.client.gui.DashPattern;
import appeng.client.gui.DashedRectangle;
import appeng.client.guidebook.GuidePage;
import appeng.client.guidebook.PageAnchor;
import appeng.client.guidebook.PageCollection;
import appeng.client.guidebook.document.LytRect;
import appeng.client.guidebook.document.block.LytBlock;
import appeng.client.guidebook.document.block.LytDocument;
import appeng.client.guidebook.document.block.LytHeading;
import appeng.client.guidebook.document.block.LytNode;
import appeng.client.guidebook.document.block.LytParagraph;
import appeng.client.guidebook.document.flow.LytFlowContainer;
import appeng.client.guidebook.document.flow.LytFlowContent;
import appeng.client.guidebook.document.interaction.GuideTooltip;
import appeng.client.guidebook.document.interaction.InteractiveElement;
import appeng.client.guidebook.layout.LayoutContext;
import appeng.client.guidebook.layout.MinecraftFontMetrics;
import appeng.client.guidebook.render.ColorRef;
import appeng.client.guidebook.render.GuidePageTexture;
import appeng.client.guidebook.render.LightDarkMode;
import appeng.client.guidebook.render.SimpleRenderContext;
import appeng.client.guidebook.screen.GuideNavBar;
import appeng.client.guidebook.screen.GuideScrollbar;
import appeng.client.guidebook.screen.TooltipFrame;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.class_2561;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_312;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5684;
import org.jetbrains.annotations.Nullable;

public class GuideScreen
extends class_437 {
    private static final int HISTORY_SIZE = 100;
    private static final List<PageAnchor> history = new ArrayList<PageAnchor>();
    private static int historyPosition;
    private static final DashPattern DEBUG_NODE_OUTLINE;
    private static final DashPattern DEBUG_CONTENT_OUTLINE;
    private final PageCollection pages;
    private final GuideScrollbar scrollbar;
    private GuidePage currentPage;
    private class_4185 backButton;
    private class_4185 forwardButton;

    private GuideScreen(PageCollection pages, PageAnchor anchor) {
        super((class_2561)class_2561.method_43470((String)"AE2 Guidebook"));
        this.pages = pages;
        this.scrollbar = new GuideScrollbar();
        this.loadPage(anchor);
    }

    public static GuideScreen openNew(PageCollection pages, PageAnchor anchor) {
        if (history.lastIndexOf(anchor) != history.size()) {
            historyPosition = history.size();
            history.add(anchor);
        }
        return new GuideScreen(pages, anchor);
    }

    public static GuideScreen openAtPreviousPage(PageCollection pages, PageAnchor anchor) {
        if (historyPosition >= history.size()) {
            return GuideScreen.openNew(pages, anchor);
        }
        anchor = history.get(historyPosition);
        return new GuideScreen(pages, anchor);
    }

    protected void method_25426() {
        super.method_25426();
        this.updatePageLayout();
        LytRect docRect = this.getDocumentRect();
        this.method_37063((class_364)this.scrollbar);
        this.scrollbar.move(docRect.right(), docRect.y(), docRect.height());
        GuideNavBar navbar = new GuideNavBar(this);
        this.method_37063((class_364)navbar);
        this.backButton = new class_4185(docRect.right() - 40, docRect.y() - 15, 20, 15, (class_2561)class_2561.method_43470((String)"<"), button -> this.navigateBack());
        this.method_37063((class_364)this.backButton);
        this.forwardButton = new class_4185(docRect.right() - 20, docRect.y() - 15, 20, 15, (class_2561)class_2561.method_43470((String)">"), button -> this.navigateForward());
        this.method_37063((class_364)this.forwardButton);
        this.updateNavigationButtons();
    }

    public void method_25394(class_4587 poseStack, int mouseX, int mouseY, float partialTick) {
        this.updateNavigationButtons();
        this.method_25420(poseStack);
        LytRect documentRect = this.getDocumentRect();
        GuideScreen.method_25294((class_4587)poseStack, (int)documentRect.x(), (int)documentRect.y(), (int)documentRect.right(), (int)documentRect.bottom(), (int)-2144128205);
        LytRect documentViewport = this.getDocumentViewport();
        poseStack.method_22903();
        poseStack.method_22904((double)(documentRect.x() - documentViewport.x()), (double)(documentRect.y() - documentViewport.y()), 0.0);
        LytDocument document = this.currentPage.getDocument();
        SimpleRenderContext context = new SimpleRenderContext(documentViewport, poseStack, LightDarkMode.LIGHT_MODE);
        GuideScreen.method_44379((int)documentRect.x(), (int)documentRect.y(), (int)documentRect.right(), (int)documentRect.bottom());
        class_4597.class_4598 buffers = context.beginBatch();
        document.renderBatch(context, (class_4597)buffers);
        context.endBatch(buffers);
        document.render(context);
        GuideScreen.method_44380();
        poseStack.method_22909();
        poseStack.method_22903();
        poseStack.method_22904(0.0, 0.0, 100.0);
        super.method_25394(poseStack, mouseX, mouseY, partialTick);
        poseStack.method_22909();
        if (document.getHoveredElement() != null) {
            this.renderTooltip(poseStack, mouseX, mouseY);
        }
    }

    private void renderTooltip(class_4587 poseStack, int x, int y) {
        Point docPos = this.getDocumentPoint(x, y);
        if (docPos == null) {
            return;
        }
        GuideTooltip tooltip = this.dispatchInteraction(docPos.getX(), docPos.getY(), InteractiveElement::getTooltip).orElse(null);
        if (tooltip != null) {
            this.renderTooltip(poseStack, tooltip, x, y);
        }
    }

    private static void renderHoverOutline(LytDocument document, SimpleRenderContext context) {
        LytDocument.HitTestResult hoveredElement = document.getHoveredElement();
        if (hoveredElement != null) {
            LytNode lytNode = hoveredElement.node();
            if (lytNode instanceof LytBlock) {
                LytBlock block = (LytBlock)lytNode;
                LytRect bounds = block.getBounds();
                if (block.getMarginTop() > 0) {
                    context.fillRect(bounds.withHeight(block.getMarginTop()).move(0, -block.getMarginTop()), new ColorRef(0x7FFFFF00));
                }
                if (block.getMarginBottom() > 0) {
                    context.fillRect(bounds.withHeight(block.getMarginBottom()).move(0, bounds.height()), new ColorRef(0x7FFFFF00));
                }
                if (block.getMarginLeft() > 0) {
                    context.fillRect(bounds.withWidth(block.getMarginLeft()).move(-block.getMarginLeft(), 0), new ColorRef(0x7FFFFF00));
                }
                if (block.getMarginRight() > 0) {
                    context.fillRect(bounds.withWidth(block.getMarginRight()).move(bounds.width(), 0), new ColorRef(0x7FFFFF00));
                }
            }
            DashedRectangle.render(context.poseStack(), hoveredElement.node().getBounds(), DEBUG_NODE_OUTLINE, 0.0f);
            if (hoveredElement.content() != null && (lytNode = hoveredElement.node()) instanceof LytFlowContainer) {
                LytFlowContainer flowContainer = (LytFlowContainer)((Object)lytNode);
                flowContainer.enumerateContentBounds(hoveredElement.content()).forEach(bound -> DashedRectangle.render(context.poseStack(), bound, DEBUG_CONTENT_OUTLINE, 0.0f));
            }
        }
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (super.method_25402(mouseX, mouseY, button)) {
            return true;
        }
        Point docPoint = this.getDocumentPoint(mouseX, mouseY);
        if (docPoint != null) {
            if (button == 3) {
                this.navigateBack();
            } else if (button == 4) {
                this.navigateForward();
            }
            return this.dispatchEvent(docPoint.getX(), docPoint.getY(), el -> el.mouseClicked(this, docPoint.getX(), docPoint.getY(), button));
        }
        return false;
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        if (super.method_25406(mouseX, mouseY, button)) {
            return true;
        }
        Point docPoint = this.getDocumentPoint(mouseX, mouseY);
        if (docPoint != null) {
            return this.dispatchEvent(docPoint.getX(), docPoint.getY(), el -> el.mouseReleased(this, docPoint.getX(), docPoint.getY(), button));
        }
        return false;
    }

    public void navigateTo(class_2960 pageId) {
        this.navigateTo(new PageAnchor(pageId, null));
    }

    public void navigateTo(PageAnchor anchor) {
        if (this.currentPage.getId().equals((Object)anchor.pageId())) {
            return;
        }
        this.loadPage(anchor);
        if (historyPosition + 1 < history.size()) {
            history.subList(historyPosition + 1, history.size()).clear();
        }
        if (history.size() >= 100) {
            history.subList(0, history.size() - 100).clear();
        }
        historyPosition = history.size();
        history.add(anchor);
    }

    private void navigateForward() {
        if (historyPosition + 1 < history.size()) {
            this.loadPage(history.get(++historyPosition));
        }
    }

    private void navigateBack() {
        if (historyPosition > 0) {
            this.loadPage(history.get(--historyPosition));
        }
    }

    private void loadPage(PageAnchor anchor) {
        GuidePageTexture.releaseUsedTextures();
        this.currentPage = this.pages.getPage(anchor.pageId());
        if (this.currentPage == null) {
            this.currentPage = this.buildNotFoundPage(anchor);
        }
        this.scrollbar.setScrollAmount(0);
        this.updatePageLayout();
    }

    private GuidePage buildNotFoundPage(PageAnchor anchor) {
        LytDocument document = new LytDocument();
        LytHeading title = new LytHeading();
        title.appendText("Page not Found");
        title.setDepth(1);
        document.append(title);
        LytParagraph body = new LytParagraph();
        body.appendText("Page " + anchor.pageId() + " could not be found.");
        document.append(body);
        return new GuidePage("ae2", anchor.pageId(), document);
    }

    public void method_25432() {
        super.method_25432();
        GuidePageTexture.releaseUsedTextures();
    }

    public void reloadPage() {
        GuidePageTexture.releaseUsedTextures();
        this.currentPage = this.pages.getPage(this.currentPage.getId());
        this.updatePageLayout();
    }

    private boolean dispatchEvent(int x, int y, EventInvoker invoker) {
        return this.dispatchInteraction(x, y, el -> {
            if (invoker.invoke((InteractiveElement)el)) {
                return Optional.of(true);
            }
            return Optional.empty();
        }).orElse(false);
    }

    private <T> Optional<T> dispatchInteraction(int x, int y, Function<InteractiveElement, Optional<T>> invoker) {
        LytDocument.HitTestResult underCursor = this.currentPage.getDocument().pick(x, y);
        if (underCursor != null) {
            InteractiveElement interactiveEl;
            Optional<T> result;
            for (LytFlowContent el = underCursor.content(); el != null; el = el.getFlowParent()) {
                if (!(el instanceof InteractiveElement) || !(result = invoker.apply(interactiveEl = (InteractiveElement)((Object)el))).isPresent()) continue;
                return result;
            }
            for (LytNode node = underCursor.node(); node != null; node = node.getParent()) {
                if (!(node instanceof InteractiveElement) || !(result = invoker.apply(interactiveEl = (InteractiveElement)((Object)node))).isPresent()) continue;
                return result;
            }
        }
        return Optional.empty();
    }

    public void method_37068() {
        super.method_37068();
        LytDocument document = this.currentPage.getDocument();
        class_312 mouseHandler = this.field_22787.field_1729;
        double scale = (double)this.field_22787.method_22683().method_4486() / (double)this.field_22787.method_22683().method_4480();
        double x = mouseHandler.method_1603() * scale;
        double y = mouseHandler.method_1604() * scale;
        if (this.method_19355(x, y).isPresent()) {
            document.setHoveredElement(null);
            return;
        }
        Point docPoint = this.getDocumentPoint(x, y);
        if (docPoint != null) {
            LytDocument.HitTestResult hoveredEl = document.pick(docPoint.getX(), docPoint.getY());
            document.setHoveredElement(hoveredEl);
        } else {
            document.setHoveredElement(null);
        }
    }

    @Nullable
    private Point getDocumentPoint(double screenX, double screenY) {
        LytRect documentRect = this.getDocumentRect();
        if (screenX >= (double)documentRect.x() && screenX < (double)documentRect.right() && screenY >= (double)documentRect.y() && screenY < (double)documentRect.bottom()) {
            int docX = (int)Math.round(screenX - (double)documentRect.x());
            int docY = (int)Math.round(screenY + (double)this.scrollbar.getScrollAmount() - (double)documentRect.y());
            return new Point(docX, docY);
        }
        return null;
    }

    private LytRect getDocumentRect() {
        int margin = 20;
        return new LytRect(margin, margin, this.field_22789 - 2 * margin, this.field_22790 - 2 * margin);
    }

    private LytRect getDocumentViewport() {
        LytRect documentRect = this.getDocumentRect();
        return new LytRect(0, this.scrollbar.getScrollAmount(), documentRect.width(), documentRect.height());
    }

    public boolean method_25401(double mouseX, double mouseY, double delta) {
        if (!super.method_25401(mouseX, mouseY, delta)) {
            return this.scrollbar.method_25401(mouseX, mouseY, delta);
        }
        return true;
    }

    private void renderTooltip(class_4587 poseStack, GuideTooltip tooltip, int mouseX, int mouseY) {
        class_5684 line;
        int i;
        class_310 minecraft = class_310.method_1551();
        List<class_5684> clientLines = tooltip.getLines(this);
        if (clientLines.isEmpty()) {
            return;
        }
        int frameWidth = 0;
        int frameHeight = clientLines.size() == 1 ? -2 : 0;
        for (class_5684 clientTooltipComponent : clientLines) {
            frameWidth = Math.max(frameWidth, clientTooltipComponent.method_32664(minecraft.field_1772));
            frameHeight += clientTooltipComponent.method_32661();
        }
        if (!tooltip.getIcon().method_7960()) {
            frameWidth += 18;
            frameHeight = Math.max(frameHeight, 18);
        }
        int x = mouseX + 12;
        int y = mouseY - 12;
        if (x + frameWidth > this.field_22789) {
            x -= 28 + frameWidth;
        }
        if (y + frameHeight + 6 > this.field_22790) {
            y = this.field_22790 - frameHeight - 6;
        }
        int zOffset = 400;
        TooltipFrame.render(poseStack, x, y, frameWidth, frameHeight, zOffset);
        float prevZOffset = this.field_22788.field_4730;
        this.field_22788.field_4730 = zOffset;
        if (!tooltip.getIcon().method_7960()) {
            x += 18;
        }
        class_4597.class_4598 bufferSource = class_4597.method_22991((class_287)class_289.method_1348().method_1349());
        poseStack.method_22903();
        poseStack.method_22904(0.0, 0.0, (double)zOffset);
        int currentY = y;
        for (i = 0; i < clientLines.size(); ++i) {
            line = clientLines.get(i);
            line.method_32665(minecraft.field_1772, x, currentY, poseStack.method_23760().method_23761(), bufferSource);
            currentY += line.method_32661() + (i == 0 ? 2 : 0);
        }
        bufferSource.method_22993();
        poseStack.method_22909();
        currentY = y;
        if (!tooltip.getIcon().method_7960()) {
            this.field_22788.method_4010(tooltip.getIcon(), x - 18, y);
        }
        for (i = 0; i < clientLines.size(); ++i) {
            line = clientLines.get(i);
            line.method_32666(minecraft.field_1772, x, currentY, poseStack, this.field_22788, zOffset);
            currentY += line.method_32661() + (i == 0 ? 2 : 0);
        }
        this.field_22788.field_4730 = prevZOffset;
    }

    private void updatePageLayout() {
        LytRect docViewport = this.getDocumentViewport();
        LayoutContext context = new LayoutContext(new MinecraftFontMetrics(), docViewport);
        LytDocument document = this.currentPage.getDocument();
        document.updateLayout(context, docViewport.width());
        this.scrollbar.setContentHeight(document.getContentHeight());
    }

    public class_2960 getCurrentPageId() {
        return this.currentPage.getId();
    }

    private void updateNavigationButtons() {
        this.backButton.field_22763 = historyPosition > 0;
        this.forwardButton.field_22763 = historyPosition + 1 < history.size();
    }

    public PageCollection getPages() {
        return this.pages;
    }

    static {
        DEBUG_NODE_OUTLINE = new DashPattern(1.0f, 4.0f, 3.0f, -1, 500.0f);
        DEBUG_CONTENT_OUTLINE = new DashPattern(0.5f, 2.0f, 1.0f, Integer.MAX_VALUE, 500.0f);
    }

    @FunctionalInterface
    static interface EventInvoker {
        public boolean invoke(InteractiveElement var1);
    }
}

