/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.render.model;

import appeng.client.render.cablebus.QuadRotator;
import appeng.client.render.model.AEModelData;
import java.util.function.Supplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.renderer.v1.model.FabricBakedModel;
import net.fabricmc.fabric.api.renderer.v1.model.ForwardingBakedModel;
import net.fabricmc.fabric.api.renderer.v1.render.RenderContext;
import net.fabricmc.fabric.api.rendering.data.v1.RenderAttachedBlockView;
import net.minecraft.class_1087;
import net.minecraft.class_1799;
import net.minecraft.class_1920;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_5819;

@Environment(value=EnvType.CLIENT)
public class AutoRotatingBakedModel
extends ForwardingBakedModel
implements FabricBakedModel {
    public AutoRotatingBakedModel(class_1087 wrapped) {
        this.wrapped = wrapped;
    }

    public boolean isVanillaAdapter() {
        return false;
    }

    public class_1087 getWrapped() {
        return this.wrapped;
    }

    public void emitBlockQuads(class_1920 blockView, class_2680 state, class_2338 pos, Supplier<class_5819> randomSupplier, RenderContext context) {
        RenderContext.QuadTransform transform = this.getTransform(blockView, pos);
        if (transform != null) {
            context.pushTransform(transform);
        }
        super.emitBlockQuads(blockView, state, pos, randomSupplier, context);
        if (transform != null) {
            context.popTransform();
        }
    }

    public void emitItemQuads(class_1799 stack, Supplier<class_5819> randomSupplier, RenderContext context) {
        super.emitItemQuads(stack, randomSupplier, context);
    }

    private RenderContext.QuadTransform getTransform(class_1920 view, class_2338 pos) {
        if (!(view instanceof RenderAttachedBlockView)) {
            return null;
        }
        RenderAttachedBlockView renderBlockView = (RenderAttachedBlockView)view;
        Object data = renderBlockView.getBlockEntityRenderAttachment(pos);
        if (!(data instanceof AEModelData)) {
            return null;
        }
        AEModelData aeModelData = (AEModelData)data;
        RenderContext.QuadTransform transform = QuadRotator.get(aeModelData.getForward(), aeModelData.getUp());
        if (transform == QuadRotator.NULL_TRANSFORM) {
            return null;
        }
        return transform;
    }
}

