/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.render.tesr;

import appeng.blockentity.storage.ChestBlockEntity;
import appeng.client.render.BakedModelUnwrapper;
import appeng.client.render.FacingToRotation;
import appeng.client.render.model.DriveBakedModel;
import appeng.client.render.tesr.CellLedRenderer;
import appeng.core.definitions.AEBlocks;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.fabricmc.fabric.api.renderer.v1.model.ForwardingBakedModel;
import net.minecraft.class_1087;
import net.minecraft.class_1092;
import net.minecraft.class_1792;
import net.minecraft.class_1920;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5614;
import net.minecraft.class_5819;
import net.minecraft.class_777;
import net.minecraft.class_778;
import net.minecraft.class_827;

public class ChestBlockEntityRenderer
implements class_827<ChestBlockEntity> {
    private final class_1092 modelManager;
    private final class_778 blockRenderer;

    public ChestBlockEntityRenderer(class_5614.class_5615 context) {
        class_310 client = class_310.method_1551();
        this.modelManager = client.method_1554();
        this.blockRenderer = client.method_1541().method_3350();
    }

    public void render(ChestBlockEntity chest, float partialTicks, class_4587 poseStack, class_4597 buffers, int combinedLight, int combinedOverlay) {
        class_1937 level = chest.method_10997();
        if (level == null) {
            return;
        }
        class_1792 cellItem = chest.getCellItem(0);
        if (cellItem == null) {
            return;
        }
        DriveBakedModel driveModel = this.getDriveModel();
        if (driveModel == null) {
            return;
        }
        class_1087 cellModel = driveModel.getCellChassisModel(cellItem);
        poseStack.method_22903();
        poseStack.method_22904(0.5, 0.5, 0.5);
        FacingToRotation rotation = FacingToRotation.get(chest.getForward(), chest.getUp());
        rotation.push(poseStack);
        poseStack.method_22904(-0.5, -0.5, -0.5);
        poseStack.method_22904(0.3125, 0.25, 0.0);
        class_4588 buffer = buffers.getBuffer(class_1921.method_23581());
        FaceRotatingModel rotatedModel = new FaceRotatingModel(cellModel, rotation);
        this.blockRenderer.method_3374((class_1920)level, (class_1087)rotatedModel, chest.method_11010(), chest.method_11016(), poseStack, buffer, false, class_5819.method_43047(), 0L, combinedOverlay);
        class_4588 ledBuffer = buffers.getBuffer(CellLedRenderer.RENDER_LAYER);
        CellLedRenderer.renderLed(chest, 0, ledBuffer, poseStack, partialTicks);
        poseStack.method_22909();
    }

    private DriveBakedModel getDriveModel() {
        class_1087 driveModel = this.modelManager.method_4743().method_3335(AEBlocks.DRIVE.block().method_9564());
        return BakedModelUnwrapper.unwrap(driveModel, DriveBakedModel.class);
    }

    private static class FaceRotatingModel
    extends ForwardingBakedModel {
        private final FacingToRotation r;

        protected FaceRotatingModel(class_1087 base, FacingToRotation r) {
            this.wrapped = base;
            this.r = r;
        }

        public List<class_777> method_4707(@Nullable class_2680 state, @Nullable class_2350 side, class_5819 rand) {
            if (side != null) {
                side = this.r.resultingRotate(side);
            }
            ArrayList<class_777> quads = new ArrayList<class_777>(super.method_4707(state, side, rand));
            for (int i = 0; i < quads.size(); ++i) {
                class_777 quad = (class_777)quads.get(i);
                quads.set(i, new class_777(quad.method_3357(), quad.method_3359(), this.r.rotate(quad.method_3358()), quad.method_35788(), quad.method_24874()));
            }
            return quads;
        }
    }
}

