/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.sync.packets;

import appeng.api.config.Setting;
import appeng.api.util.IConfigManager;
import appeng.api.util.IConfigurableObject;
import appeng.core.sync.BasePacket;
import io.netty.buffer.Unpooled;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_2540;
import net.minecraft.class_3222;

public class ConfigValuePacket
extends BasePacket {
    private final String name;
    private final String value;

    public ConfigValuePacket(class_2540 stream) {
        this.name = stream.method_19772();
        this.value = stream.method_19772();
    }

    private ConfigValuePacket(String name, String value) {
        this.name = name;
        this.value = value;
        class_2540 data = new class_2540(Unpooled.buffer());
        data.writeInt(this.getPacketID());
        data.method_10814(name);
        data.method_10814(value);
        this.configureWrite(data);
    }

    public <T extends Enum<T>> ConfigValuePacket(Setting<T> setting, T value) {
        this(setting.getName(), value.name());
        if (!setting.getValues().contains(value)) {
            throw new IllegalStateException(value + " not a valid value for " + setting);
        }
    }

    public <T extends Enum<T>> ConfigValuePacket(Setting<T> setting, IConfigManager configManager) {
        this(setting, setting.getValue(configManager));
    }

    @Override
    public void serverPacketData(class_3222 player) {
        class_1703 c = player.field_7512;
        if (c instanceof IConfigurableObject) {
            IConfigurableObject configurableObject = (IConfigurableObject)c;
            this.loadSetting(configurableObject);
        }
    }

    @Override
    public void clientPacketData(class_1657 player) {
        class_1703 c = player.field_7512;
        if (c instanceof IConfigurableObject) {
            IConfigurableObject configurableObject = (IConfigurableObject)c;
            this.loadSetting(configurableObject);
        }
    }

    private void loadSetting(IConfigurableObject configurableObject) {
        IConfigManager cm = configurableObject.getConfigManager();
        for (Setting<?> setting : cm.getSettings()) {
            if (!setting.getName().equals(this.name)) continue;
            setting.setFromString(cm, this.value);
            break;
        }
    }
}

